/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.manager.tableOps.create;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.stream.Stream;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.admin.TimeType;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.fate.Repo;
import org.apache.accumulo.core.fate.zookeeper.ServiceLock;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.metadata.schema.MetadataTime;
import org.apache.accumulo.manager.Manager;
import org.apache.accumulo.manager.tableOps.ManagerRepo;
import org.apache.accumulo.manager.tableOps.TableInfo;
import org.apache.accumulo.manager.tableOps.Utils;
import org.apache.accumulo.manager.tableOps.create.FinishCreateTable;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.util.MetadataTableUtil;
import org.apache.hadoop.io.Text;

class PopulateMetadata
extends ManagerRepo {
    private static final long serialVersionUID = 1L;
    private final TableInfo tableInfo;

    PopulateMetadata(TableInfo ti) {
        this.tableInfo = ti;
    }

    @Override
    public long isReady(long tid, Manager environment) {
        return 0L;
    }

    @Override
    public Repo<Manager> call(long tid, Manager env) throws Exception {
        KeyExtent extent = new KeyExtent(this.tableInfo.getTableId(), null, null);
        MetadataTableUtil.addTablet((KeyExtent)extent, (String)"default_tablet", (ServerContext)env.getContext(), (TimeType)this.tableInfo.getTimeType(), (ServiceLock)env.getManagerLock());
        if (this.tableInfo.getInitialSplitSize() > 0) {
            SortedSet<Text> splits = Utils.getSortedSetFromFile(env, this.tableInfo.getSplitPath(), true);
            SortedSet<Text> dirs = Utils.getSortedSetFromFile(env, this.tableInfo.getSplitDirsPath(), false);
            Map<Text, Text> splitDirMap = this.createSplitDirectoryMap(splits, dirs);
            try (BatchWriter bw = env.getContext().createBatchWriter(MetadataTable.NAME);){
                this.writeSplitsToMetadataTable(env.getContext(), this.tableInfo.getTableId(), splits, splitDirMap, this.tableInfo.getTimeType(), env.getManagerLock(), bw);
            }
        }
        return new FinishCreateTable(this.tableInfo);
    }

    private void writeSplitsToMetadataTable(ServerContext context, TableId tableId, SortedSet<Text> splits, Map<Text, Text> data, TimeType timeType, ServiceLock lock, BatchWriter bw) throws MutationsRejectedException {
        Text prevSplit = null;
        Iterable iter = () -> Stream.concat(splits.stream(), Stream.of((Text)null)).iterator();
        for (Text split : iter) {
            Mutation mut = MetadataSchema.TabletsSection.TabletColumnFamily.createPrevRowMutation((KeyExtent)new KeyExtent(tableId, split, prevSplit));
            Value dirValue = split == null ? new Value((CharSequence)"default_tablet") : new Value(data.get(split));
            MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN.put(mut, dirValue);
            MetadataSchema.TabletsSection.ServerColumnFamily.TIME_COLUMN.put(mut, new Value((CharSequence)new MetadataTime(0L, timeType).encode()));
            MetadataTableUtil.putLockID((ServerContext)context, (ServiceLock)lock, (Mutation)mut);
            prevSplit = split;
            bw.addMutation(mut);
        }
    }

    @Override
    public void undo(long tid, Manager environment) throws Exception {
        MetadataTableUtil.deleteTable((TableId)this.tableInfo.getTableId(), (boolean)false, (ServerContext)environment.getContext(), (ServiceLock)environment.getManagerLock());
    }

    private Map<Text, Text> createSplitDirectoryMap(SortedSet<Text> splits, SortedSet<Text> dirs) {
        Preconditions.checkArgument((splits.size() == dirs.size() ? 1 : 0) != 0);
        HashMap<Text, Text> data = new HashMap<Text, Text>();
        Iterator s = splits.iterator();
        Iterator d = dirs.iterator();
        while (s.hasNext() && d.hasNext()) {
            data.put((Text)s.next(), (Text)d.next());
        }
        return data;
    }
}

