/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.monitor.rest.tservers;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.xml.bind.annotation.XmlAttribute;
import java.util.ArrayList;
import java.util.List;
import org.apache.accumulo.core.master.thrift.RecoveryStatus;
import org.apache.accumulo.core.master.thrift.TableInfo;
import org.apache.accumulo.core.master.thrift.TabletServerStatus;
import org.apache.accumulo.monitor.Monitor;
import org.apache.accumulo.monitor.rest.tables.CompactionsList;
import org.apache.accumulo.monitor.rest.tables.CompactionsTypes;
import org.apache.accumulo.monitor.rest.trace.RecoveryStatusInformation;
import org.apache.accumulo.server.util.TableInfoUtil;

@SuppressFBWarnings(value={"PA_PUBLIC_PRIMITIVE_ATTRIBUTE"}, justification="public member variables only referenced from tests, class used for serialization")
public class TabletServerInformation {
    @XmlAttribute(name="id")
    public String server;
    public String hostname;
    public long lastContact;
    public long responseTime;
    public double osload;
    public String version;
    public CompactionsTypes compactions;
    public int tablets;
    public double ingest;
    public double query;
    public double ingestMB;
    public double queryMB;
    public Integer scans;
    public Double scansessions;
    public Double scanssessions;
    public long holdtime;
    public String ip;
    public Integer scansRunning;
    public Integer scansQueued;
    public String minorCombo;
    public String majorCombo;
    public String scansCombo;
    public Integer minorRunning;
    public Integer minorQueued;
    public Integer majorRunning;
    public Integer majorQueued;
    private CompactionsList scansCompacting;
    private CompactionsList major;
    private CompactionsList minor;
    public long entries;
    public long lookups;
    public long indexCacheHits;
    public long indexCacheRequests;
    public long dataCacheHits;
    public long dataCacheRequests;
    public double indexCacheHitRate;
    public double dataCacheHitRate;
    public List<RecoveryStatusInformation> logRecoveries;

    public TabletServerInformation() {
    }

    public TabletServerInformation(Monitor monitor, TabletServerStatus thriftStatus) {
        TableInfo summary = TableInfoUtil.summarizeTableStats((TabletServerStatus)thriftStatus);
        this.updateTabletServerInfo(monitor, thriftStatus, summary);
    }

    public void updateTabletServerInfo(Monitor monitor, TabletServerStatus thriftStatus, TableInfo summary) {
        long now = System.currentTimeMillis();
        this.ip = this.hostname = thriftStatus.name;
        this.server = this.hostname;
        this.tablets = summary.tablets;
        this.lastContact = now - thriftStatus.lastContact;
        this.responseTime = thriftStatus.responseTime;
        this.entries = summary.recs;
        this.ingest = this.cleanNumber(summary.ingestRate);
        this.query = this.cleanNumber(summary.queryRate);
        this.holdtime = thriftStatus.holdTime;
        this.scansRunning = summary.scans != null ? summary.scans.running : 0;
        this.scansQueued = summary.scans != null ? summary.scans.queued : 0;
        this.scansCombo = this.scansRunning + "(" + this.scansQueued + ")";
        this.scans = this.scansRunning;
        this.scansCompacting = new CompactionsList(this.scansRunning, this.scansQueued);
        this.minorRunning = summary.minors != null ? summary.minors.running : 0;
        this.minorQueued = summary.minors != null ? summary.minors.queued : 0;
        this.minorCombo = this.minorRunning + "(" + this.minorQueued + ")";
        this.minor = new CompactionsList(this.minorRunning, this.minorQueued);
        this.majorRunning = summary.majors != null ? summary.majors.running : 0;
        this.majorQueued = summary.majors != null ? summary.majors.queued : 0;
        this.majorCombo = this.majorRunning + "(" + this.majorQueued + ")";
        this.major = new CompactionsList(this.majorRunning, this.majorQueued);
        this.compactions = new CompactionsTypes(this.scansCompacting, this.major, this.minor);
        this.osload = thriftStatus.osLoad;
        this.version = thriftStatus.version;
        this.lookups = thriftStatus.lookups;
        this.dataCacheHits = thriftStatus.dataCacheHits;
        this.dataCacheRequests = thriftStatus.dataCacheRequest;
        this.indexCacheHits = thriftStatus.indexCacheHits;
        this.indexCacheRequests = thriftStatus.indexCacheRequest;
        this.indexCacheHitRate = (double)this.indexCacheHits / (double)Math.max(this.indexCacheRequests, 1L);
        this.dataCacheHitRate = (double)this.dataCacheHits / (double)Math.max(this.dataCacheRequests, 1L);
        this.ingestMB = this.cleanNumber(summary.ingestByteRate);
        this.queryMB = this.cleanNumber(summary.queryByteRate);
        this.scanssessions = this.scansessions = Double.valueOf(monitor.getLookupRate());
        this.logRecoveries = new ArrayList<RecoveryStatusInformation>(thriftStatus.logSorts.size());
        for (RecoveryStatus recovery : thriftStatus.logSorts) {
            this.logRecoveries.add(new RecoveryStatusInformation(recovery));
        }
    }

    private double cleanNumber(double dirtyNumber) {
        return dirtyNumber < 1.0 ? 0.0 : dirtyNumber;
    }
}

