/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.clientImpl;

import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.TabletLocatorImpl;
import org.apache.accumulo.core.fate.zookeeper.ServiceLock;
import org.apache.accumulo.core.fate.zookeeper.ZooCache;

public class ZookeeperLockChecker
implements TabletLocatorImpl.TabletServerLockChecker {
    private final ZooCache zc;
    private final String root;

    ZookeeperLockChecker(ClientContext context) {
        this.zc = context.getZooCache();
        this.root = context.getZooKeeperRoot() + "/tservers";
    }

    public boolean doesTabletServerLockExist(String server) {
        ServiceLock.ServiceLockPath zLockPath = ServiceLock.path(this.root + "/" + server);
        return ServiceLock.getSessionId(this.zc, zLockPath) != 0L;
    }

    @Override
    public boolean isLockHeld(String tserver, String session) {
        ServiceLock.ServiceLockPath zLockPath = ServiceLock.path(this.root + "/" + tserver);
        return ServiceLock.getSessionId(this.zc, zLockPath) == Long.parseLong(session, 16);
    }

    @Override
    public void invalidateCache(String tserver) {
        this.zc.clear(this.root + "/" + tserver);
    }
}

