/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.clientImpl.bulk;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.util.TextUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;

public class Bulk {
    public static Tablet toTablet(KeyExtent keyExtent) {
        return new Tablet(keyExtent.endRow(), keyExtent.prevEndRow());
    }

    public static KeyExtent toKeyExtent(TableId tableId, Tablet tablet) {
        return new KeyExtent(tableId, tablet.getEndRow(), tablet.getPrevEndRow());
    }

    public static class Tablet {
        private final byte[] endRow;
        private final byte[] prevEndRow;

        public Tablet(Text endRow, Text prevEndRow) {
            this.endRow = endRow == null ? null : TextUtil.getBytes(endRow);
            this.prevEndRow = prevEndRow == null ? null : TextUtil.getBytes(prevEndRow);
        }

        public KeyExtent toKeyExtent(TableId tableId) {
            return Bulk.toKeyExtent(tableId, this);
        }

        public Text getEndRow() {
            if (this.endRow == null) {
                return null;
            }
            return new Text(this.endRow);
        }

        public Text getPrevEndRow() {
            if (this.prevEndRow == null) {
                return null;
            }
            return new Text(this.prevEndRow);
        }

        public String toString() {
            return String.valueOf(this.getEndRow()) + ";" + String.valueOf(this.getPrevEndRow());
        }
    }

    public static class Files
    implements Iterable<FileInfo> {
        Map<String, FileInfo> files = new HashMap<String, FileInfo>();

        public Files(Collection<FileInfo> files) {
            files.forEach(this::add);
        }

        public Files() {
        }

        public void add(FileInfo fi) {
            if (this.files.putIfAbsent(fi.name, fi) != null) {
                throw new IllegalArgumentException("File already present " + fi.name);
            }
        }

        public FileInfo get(String fileName) {
            return this.files.get(fileName);
        }

        public Files mapNames(Map<String, String> renames) {
            Files renamed = new Files();
            this.files.forEach((? super K k, ? super V v) -> {
                String newName = (String)renames.get(k);
                FileInfo nfi = new FileInfo(newName, v.estSize, v.estEntries);
                renamed.files.put(newName, nfi);
            });
            return renamed;
        }

        void merge(Files other) {
            other.files.forEach((? super K k, ? super V v) -> this.files.merge((String)k, (FileInfo)v, FileInfo::merge));
        }

        public int getSize() {
            return this.files.size();
        }

        @Override
        public Iterator<FileInfo> iterator() {
            return this.files.values().iterator();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Files)) {
                return false;
            }
            Files other = (Files)o;
            return this.files.equals(other.files);
        }

        public int hashCode() {
            return this.files.hashCode();
        }

        public String toString() {
            return this.files.toString();
        }
    }

    public static class FileInfo {
        final String name;
        final long estSize;
        final long estEntries;

        public FileInfo(String fileName, long estFileSize, long estNumEntries) {
            this.name = fileName;
            this.estSize = estFileSize;
            this.estEntries = estNumEntries;
        }

        public FileInfo(Path path, long estSize) {
            this(path.getName(), estSize, 0L);
        }

        static FileInfo merge(FileInfo fi1, FileInfo fi2) {
            Preconditions.checkArgument((boolean)fi1.name.equals(fi2.name));
            return new FileInfo(fi1.name, fi1.estSize + fi2.estSize, fi1.estEntries + fi2.estEntries);
        }

        public String getFileName() {
            return this.name;
        }

        public long getEstFileSize() {
            return this.estSize;
        }

        public long getEstNumEntries() {
            return this.estEntries;
        }

        public String toString() {
            return String.format("file:%s  estSize:%d estEntries:%s", this.name, this.estSize, this.estEntries);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FileInfo)) {
                return false;
            }
            FileInfo other = (FileInfo)o;
            return this.name.equals(other.name) && this.estSize == other.estSize && this.estEntries == other.estEntries;
        }

        public int hashCode() {
            return Objects.hash(this.name, this.estSize, this.estEntries);
        }
    }

    public static class Mapping {
        private final Tablet tablet;
        private final Collection<FileInfo> files;

        public Mapping(KeyExtent tablet, Files files) {
            this.tablet = Bulk.toTablet(tablet);
            this.files = files.files.values();
        }

        public Tablet getTablet() {
            return this.tablet;
        }

        public KeyExtent getKeyExtent(TableId tableId) {
            return this.tablet.toKeyExtent(tableId);
        }

        public Files getFiles() {
            return new Files(this.files);
        }
    }
}

