/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.rpc;

import org.apache.commons.lang3.StringUtils;

public enum ThriftServerType {
    CUSTOM_HS_HA("custom_hs_ha"),
    THREADPOOL("threadpool"),
    SSL("ssl"),
    SASL("sasl"),
    THREADED_SELECTOR("threaded_selector");

    private final String name;

    private ThriftServerType(String name) {
        this.name = name;
    }

    public static ThriftServerType get(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return ThriftServerType.getDefault();
        }
        return ThriftServerType.valueOf(name.trim().toUpperCase());
    }

    public String toString() {
        return this.name;
    }

    public static ThriftServerType getDefault() {
        return CUSTOM_HS_HA;
    }
}

