/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.kahadb.plist;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.BrokerServiceAware;
import org.apache.activemq.store.JournaledStore;
import org.apache.activemq.store.PList;
import org.apache.activemq.store.PListStore;
import org.apache.activemq.store.kahadb.disk.index.BTreeIndex;
import org.apache.activemq.store.kahadb.disk.journal.Journal;
import org.apache.activemq.store.kahadb.disk.journal.Location;
import org.apache.activemq.store.kahadb.disk.page.Page;
import org.apache.activemq.store.kahadb.disk.page.PageFile;
import org.apache.activemq.store.kahadb.disk.page.Transaction;
import org.apache.activemq.store.kahadb.disk.util.StringMarshaller;
import org.apache.activemq.store.kahadb.disk.util.VariableMarshaller;
import org.apache.activemq.store.kahadb.plist.PListImpl;
import org.apache.activemq.thread.Scheduler;
import org.apache.activemq.util.ByteSequence;
import org.apache.activemq.util.IOHelper;
import org.apache.activemq.util.LockFile;
import org.apache.activemq.util.ServiceStopper;
import org.apache.activemq.util.ServiceSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PListStoreImpl
extends ServiceSupport
implements BrokerServiceAware,
Runnable,
PListStore,
JournaledStore {
    static final Logger LOG = LoggerFactory.getLogger(PListStoreImpl.class);
    private static final int DATABASE_LOCKED_WAIT_DELAY = 10000;
    static final int CLOSED_STATE = 1;
    static final int OPEN_STATE = 2;
    private File directory;
    private File indexDirectory;
    PageFile pageFile;
    private Journal journal;
    private LockFile lockFile;
    private boolean failIfDatabaseIsLocked;
    private int journalMaxFileLength = 0x2000000;
    private int journalMaxWriteBatchSize = 0x400000;
    private boolean enableIndexWriteAsync = false;
    private boolean initialized = false;
    private boolean lazyInit = true;
    MetaData metaData = new MetaData(this);
    final MetaDataMarshaller metaDataMarshaller = new MetaDataMarshaller(this);
    Map<String, PListImpl> persistentLists = new HashMap<String, PListImpl>();
    final Object indexLock = new Object();
    private Scheduler scheduler;
    private long cleanupInterval = 30000L;
    private int indexPageSize = PageFile.DEFAULT_PAGE_SIZE;
    private int indexCacheSize = PageFile.DEFAULT_PAGE_CACHE_SIZE;
    private int indexWriteBatchSize = PageFile.DEFAULT_WRITE_BATCH_SIZE;
    private boolean indexEnablePageCaching = true;

    public Object getIndexLock() {
        return this.indexLock;
    }

    @Override
    public void setBrokerService(BrokerService brokerService) {
        this.scheduler = brokerService.getScheduler();
    }

    public int getIndexPageSize() {
        return this.indexPageSize;
    }

    public int getIndexCacheSize() {
        return this.indexCacheSize;
    }

    public int getIndexWriteBatchSize() {
        return this.indexWriteBatchSize;
    }

    public void setIndexPageSize(int indexPageSize) {
        this.indexPageSize = indexPageSize;
    }

    public void setIndexCacheSize(int indexCacheSize) {
        this.indexCacheSize = indexCacheSize;
    }

    public void setIndexWriteBatchSize(int indexWriteBatchSize) {
        this.indexWriteBatchSize = indexWriteBatchSize;
    }

    public boolean getIndexEnablePageCaching() {
        return this.indexEnablePageCaching;
    }

    public void setIndexEnablePageCaching(boolean indexEnablePageCaching) {
        this.indexEnablePageCaching = indexEnablePageCaching;
    }

    public Journal getJournal() {
        return this.journal;
    }

    @Override
    public File getDirectory() {
        return this.directory;
    }

    @Override
    public void setDirectory(File directory) {
        this.directory = directory;
    }

    public File getIndexDirectory() {
        return this.indexDirectory != null ? this.indexDirectory : this.directory;
    }

    public void setIndexDirectory(File indexDirectory) {
        this.indexDirectory = indexDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long size() {
        PListStoreImpl pListStoreImpl = this;
        synchronized (pListStoreImpl) {
            if (!this.initialized) {
                return 0L;
            }
        }
        try {
            return this.journal.getDiskSize() + this.pageFile.getDiskSize();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PListImpl getPList(final String name) throws Exception {
        if (!this.isStarted()) {
            throw new IllegalStateException("Not started");
        }
        this.intialize();
        Object object = this.indexLock;
        synchronized (object) {
            PListStoreImpl pListStoreImpl = this;
            synchronized (pListStoreImpl) {
                PListImpl result = this.persistentLists.get(name);
                if (result == null) {
                    final PListImpl pl = new PListImpl(this);
                    pl.setName(name);
                    this.getPageFile().tx().execute(new Transaction.Closure<IOException>(){

                        @Override
                        public void execute(Transaction tx) throws IOException {
                            pl.setHeadPageId(tx.allocate().getPageId());
                            pl.load(tx);
                            PListStoreImpl.this.metaData.lists.put(tx, name, pl);
                        }
                    });
                    result = pl;
                    this.persistentLists.put(name, pl);
                }
                final PListImpl toLoad = result;
                this.getPageFile().tx().execute(new Transaction.Closure<IOException>(){

                    @Override
                    public void execute(Transaction tx) throws IOException {
                        toLoad.load(tx);
                    }
                });
                return result;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removePList(final String name) throws Exception {
        boolean result = false;
        Object object = this.indexLock;
        synchronized (object) {
            PListStoreImpl pListStoreImpl = this;
            synchronized (pListStoreImpl) {
                final PList pl = this.persistentLists.remove(name);
                boolean bl = result = pl != null;
                if (result) {
                    this.getPageFile().tx().execute(new Transaction.Closure<IOException>(){

                        @Override
                        public void execute(Transaction tx) throws IOException {
                            PListStoreImpl.this.metaData.lists.remove(tx, name);
                            pl.destroy();
                        }
                    });
                }
            }
        }
        return result;
    }

    protected synchronized void intialize() throws Exception {
        if (this.isStarted() && !this.initialized) {
            if (this.directory == null) {
                this.directory = this.getDefaultDirectory();
            }
            IOHelper.mkdirs(this.directory);
            IOHelper.deleteChildren(this.directory);
            if (this.indexDirectory != null) {
                IOHelper.mkdirs(this.indexDirectory);
                IOHelper.deleteChildren(this.indexDirectory);
            }
            this.lock();
            this.journal = new Journal();
            this.journal.setDirectory(this.directory);
            this.journal.setMaxFileLength(this.getJournalMaxFileLength());
            this.journal.setWriteBatchSize(this.getJournalMaxWriteBatchSize());
            this.journal.start();
            this.pageFile = new PageFile(this.getIndexDirectory(), "tmpDB");
            this.pageFile.setEnablePageCaching(this.getIndexEnablePageCaching());
            this.pageFile.setPageSize(this.getIndexPageSize());
            this.pageFile.setWriteBatchSize(this.getIndexWriteBatchSize());
            this.pageFile.setPageCacheSize(this.getIndexCacheSize());
            this.pageFile.load();
            this.pageFile.tx().execute(new Transaction.Closure<IOException>(){

                @Override
                public void execute(Transaction tx) throws IOException {
                    if (PListStoreImpl.this.pageFile.getPageCount() == 0L) {
                        Page<MetaData> page = tx.allocate();
                        assert (page.getPageId() == 0L);
                        page.set(PListStoreImpl.this.metaData);
                        PListStoreImpl.this.metaData.page = page;
                        PListStoreImpl.this.metaData.createIndexes(tx);
                        tx.store(PListStoreImpl.this.metaData.page, PListStoreImpl.this.metaDataMarshaller, true);
                    } else {
                        Page<MetaData> page = tx.load(0L, PListStoreImpl.this.metaDataMarshaller);
                        PListStoreImpl.this.metaData = page.get();
                        PListStoreImpl.this.metaData.page = page;
                    }
                    PListStoreImpl.this.metaData.load(tx);
                    PListStoreImpl.this.metaData.loadLists(tx, PListStoreImpl.this.persistentLists);
                }
            });
            this.pageFile.flush();
            if (this.cleanupInterval > 0L) {
                if (this.scheduler == null) {
                    this.scheduler = new Scheduler(PListStoreImpl.class.getSimpleName());
                    this.scheduler.start();
                }
                this.scheduler.executePeriodically(this, this.cleanupInterval);
            }
            this.initialized = true;
            LOG.info(String.valueOf(this) + " initialized");
        }
    }

    protected File getDefaultDirectory() {
        return new File(IOHelper.getDefaultDataDirectory() + File.pathSeparator + "delayedDB");
    }

    protected void cleanupDirectory(File dir) {
        if (dir != null && dir.exists()) {
            IOHelper.delete(dir);
        }
    }

    @Override
    protected synchronized void doStart() throws Exception {
        if (!this.lazyInit) {
            this.intialize();
        } else {
            if (this.directory == null) {
                this.directory = this.getDefaultDirectory();
            }
            this.cleanupDirectory(this.directory);
            this.cleanupDirectory(this.indexDirectory);
        }
        LOG.info(String.valueOf(this) + " started");
    }

    @Override
    protected synchronized void doStop(ServiceStopper stopper) throws Exception {
        if (this.scheduler != null && PListStoreImpl.class.getSimpleName().equals(this.scheduler.getName())) {
            this.scheduler.stop();
            this.scheduler = null;
        }
        for (PListImpl pl : this.persistentLists.values()) {
            pl.unload(null);
        }
        if (this.pageFile != null) {
            this.pageFile.unload();
        }
        if (this.journal != null) {
            this.journal.close();
        }
        if (this.lockFile != null) {
            this.lockFile.unlock();
        }
        this.lockFile = null;
        this.initialized = false;
        LOG.info(String.valueOf(this) + " stopped");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block12: {
            try {
                if (this.isStopping()) {
                    return;
                }
                int lastJournalFileId = this.journal.getLastAppendLocation().getDataFileId();
                Set<Integer> candidates = this.journal.getFileMap().keySet();
                LOG.trace("Full gc candidate set:" + String.valueOf(candidates));
                if (candidates.size() <= 1) break block12;
                Iterator<Integer> iterator = candidates.iterator();
                while (iterator.hasNext()) {
                    if (iterator.next() < lastJournalFileId) continue;
                    iterator.remove();
                }
                ArrayList<PListImpl> plists = null;
                Iterator iterator2 = this.indexLock;
                synchronized (iterator2) {
                    PListStoreImpl pListStoreImpl = this;
                    synchronized (pListStoreImpl) {
                        plists = new ArrayList<PListImpl>(this.persistentLists.values());
                    }
                }
                for (PListImpl list : plists) {
                    list.claimFileLocations(candidates);
                    if (this.isStopping()) {
                        return;
                    }
                    LOG.trace("Remaining gc candidate set after refs from: " + list.getName() + ":" + String.valueOf(candidates));
                }
                LOG.trace("GC Candidate set:" + String.valueOf(candidates));
                this.journal.removeDataFiles(candidates);
            }
            catch (IOException e) {
                LOG.error("Exception on periodic cleanup: " + String.valueOf(e), e);
            }
        }
    }

    ByteSequence getPayload(Location location) throws IllegalStateException, IOException {
        ByteSequence result = null;
        result = this.journal.read(location);
        return result;
    }

    Location write(ByteSequence payload, boolean sync) throws IllegalStateException, IOException {
        return this.journal.write(payload, sync);
    }

    private void lock() throws IOException {
        if (this.lockFile == null) {
            File lockFileName = new File(this.directory, "lock");
            this.lockFile = new LockFile(lockFileName, true);
            if (this.failIfDatabaseIsLocked) {
                this.lockFile.lock();
            } else {
                while (true) {
                    try {
                        this.lockFile.lock();
                    }
                    catch (IOException e) {
                        LOG.info("Database " + String.valueOf(lockFileName) + " is locked... waiting 10 seconds for the database to be unlocked. Reason: " + String.valueOf(e));
                        try {
                            Thread.sleep(10000L);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    break;
                }
            }
        }
    }

    PageFile getPageFile() {
        this.pageFile.isLoaded();
        return this.pageFile;
    }

    public boolean isFailIfDatabaseIsLocked() {
        return this.failIfDatabaseIsLocked;
    }

    public void setFailIfDatabaseIsLocked(boolean failIfDatabaseIsLocked) {
        this.failIfDatabaseIsLocked = failIfDatabaseIsLocked;
    }

    @Override
    public int getJournalMaxFileLength() {
        return this.journalMaxFileLength;
    }

    public void setJournalMaxFileLength(int journalMaxFileLength) {
        this.journalMaxFileLength = journalMaxFileLength;
    }

    public int getJournalMaxWriteBatchSize() {
        return this.journalMaxWriteBatchSize;
    }

    public void setJournalMaxWriteBatchSize(int journalMaxWriteBatchSize) {
        this.journalMaxWriteBatchSize = journalMaxWriteBatchSize;
    }

    public boolean isEnableIndexWriteAsync() {
        return this.enableIndexWriteAsync;
    }

    public void setEnableIndexWriteAsync(boolean enableIndexWriteAsync) {
        this.enableIndexWriteAsync = enableIndexWriteAsync;
    }

    public long getCleanupInterval() {
        return this.cleanupInterval;
    }

    public void setCleanupInterval(long cleanupInterval) {
        this.cleanupInterval = cleanupInterval;
    }

    public boolean isLazyInit() {
        return this.lazyInit;
    }

    public void setLazyInit(boolean lazyInit) {
        this.lazyInit = lazyInit;
    }

    public String toString() {
        Object path;
        Object object = path = this.getDirectory() != null ? this.getDirectory().getAbsolutePath() : "DIRECTORY_NOT_SET";
        if (this.indexDirectory != null) {
            path = (String)path + "|" + this.indexDirectory.getAbsolutePath();
        }
        return "PListStore:[" + (String)path + "]";
    }

    class PListMarshaller
    extends VariableMarshaller<PListImpl> {
        private final PListStoreImpl store;

        PListMarshaller(PListStoreImpl store) {
            this.store = store;
        }

        @Override
        public PListImpl readPayload(DataInput dataIn) throws IOException {
            PListImpl result = new PListImpl(this.store);
            result.read(dataIn);
            return result;
        }

        @Override
        public void writePayload(PListImpl list, DataOutput dataOut) throws IOException {
            list.write(dataOut);
        }
    }

    class MetaDataMarshaller
    extends VariableMarshaller<MetaData> {
        private final PListStoreImpl store;

        MetaDataMarshaller(PListStoreImpl store) {
            this.store = store;
        }

        @Override
        public MetaData readPayload(DataInput dataIn) throws IOException {
            MetaData rc = new MetaData(this.store);
            rc.read(dataIn);
            return rc;
        }

        @Override
        public void writePayload(MetaData object, DataOutput dataOut) throws IOException {
            object.write(dataOut);
        }
    }

    protected class MetaData {
        private final PListStoreImpl store;
        Page<MetaData> page;
        BTreeIndex<String, PListImpl> lists;

        protected MetaData(PListStoreImpl store) {
            this.store = store;
        }

        void createIndexes(Transaction tx) throws IOException {
            this.lists = new BTreeIndex(PListStoreImpl.this.pageFile, tx.allocate().getPageId());
        }

        void load(Transaction tx) throws IOException {
            this.lists.setKeyMarshaller(StringMarshaller.INSTANCE);
            this.lists.setValueMarshaller(new PListMarshaller(this.store));
            this.lists.load(tx);
        }

        void loadLists(Transaction tx, Map<String, PListImpl> lists) throws IOException {
            Iterator<Map.Entry<String, PListImpl>> i2 = this.lists.iterator(tx);
            while (i2.hasNext()) {
                Map.Entry<String, PListImpl> entry = i2.next();
                entry.getValue().load(tx);
                lists.put(entry.getKey(), entry.getValue());
            }
        }

        public void read(DataInput is) throws IOException {
            this.lists = new BTreeIndex(PListStoreImpl.this.pageFile, is.readLong());
            this.lists.setKeyMarshaller(StringMarshaller.INSTANCE);
            this.lists.setValueMarshaller(new PListMarshaller(this.store));
        }

        public void write(DataOutput os) throws IOException {
            os.writeLong(this.lists.getPageId());
        }
    }
}

