/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import org.apache.camel.Endpoint;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.model.EndpointRequiredDefinition;
import org.apache.camel.model.NoOutputDefinition;
import org.apache.camel.spi.Metadata;
import org.apache.camel.util.URISupport;

@Metadata(label="eip,routing")
@XmlRootElement(name="poll")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class PollDefinition
extends NoOutputDefinition<PollDefinition>
implements EndpointRequiredDefinition {
    @XmlTransient
    private String endpointUriToString;
    @XmlTransient
    protected Endpoint endpoint;
    @XmlTransient
    protected EndpointConsumerBuilder endpointConsumerBuilder;
    @XmlAttribute
    private String variableReceive;
    @XmlAttribute
    @Metadata(required=true)
    private String uri;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.time.Duration", defaultValue="20000")
    private String timeout;

    public PollDefinition() {
    }

    protected PollDefinition(PollDefinition source) {
        super(source);
        this.endpointUriToString = source.endpointUriToString;
        this.endpoint = source.endpoint;
        this.endpointConsumerBuilder = source.endpointConsumerBuilder;
        this.variableReceive = source.variableReceive;
        this.uri = source.uri;
        this.timeout = source.timeout;
    }

    public PollDefinition(String uri) {
        this();
        this.setUri(uri);
    }

    public PollDefinition(Endpoint endpoint) {
        this();
        this.setEndpoint(endpoint);
    }

    public PollDefinition(EndpointConsumerBuilder endpointDefinition) {
        this();
        this.setEndpointConsumerBuilder(endpointDefinition);
    }

    public String getShortName() {
        return "poll";
    }

    public String toString() {
        return "Poll[" + this.getLabel() + "]";
    }

    public String getVariableReceive() {
        return this.variableReceive;
    }

    public void setVariableReceive(String variableReceive) {
        this.variableReceive = variableReceive;
    }

    @Override
    public PollDefinition copyDefinition() {
        return new PollDefinition(this);
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.clear();
        this.uri = uri;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(Endpoint endpoint) {
        this.clear();
        this.endpoint = endpoint;
        this.uri = endpoint != null ? endpoint.getEndpointUri() : null;
    }

    public String getTimeout() {
        return this.timeout;
    }

    public void setTimeout(String timeout) {
        this.timeout = timeout;
    }

    public EndpointConsumerBuilder getEndpointConsumerBuilder() {
        return this.endpointConsumerBuilder;
    }

    public void setEndpointConsumerBuilder(EndpointConsumerBuilder endpointConsumerBuilder) {
        this.clear();
        this.endpointConsumerBuilder = endpointConsumerBuilder;
    }

    @Override
    public String getEndpointUri() {
        if (this.endpointConsumerBuilder != null) {
            return this.endpointConsumerBuilder.getRawUri();
        }
        if (this.endpoint != null) {
            return this.endpoint.getEndpointUri();
        }
        return this.uri;
    }

    @Override
    public String getLabel() {
        String uri;
        if (this.endpointUriToString == null) {
            String value = null;
            try {
                value = this.getEndpointUri();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            this.endpointUriToString = URISupport.sanitizeUri((String)value);
        }
        return (uri = this.endpointUriToString) != null ? uri : "no uri supplied";
    }

    protected void clear() {
        this.endpointUriToString = null;
        this.endpointConsumerBuilder = null;
        this.endpoint = null;
        this.uri = null;
    }
}

