/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.CamelContext;
import org.apache.camel.spi.FactoryFinder;
import org.apache.camel.spi.PollDynamicAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PollDynamicAwareResolver {
    public static final String RESOURCE_PATH = "META-INF/services/org/apache/camel/poll-dynamic/";
    private static final Logger LOG = LoggerFactory.getLogger(PollDynamicAwareResolver.class);
    private FactoryFinder factoryFinder;

    public PollDynamicAware resolve(CamelContext context, String scheme) {
        Class<?> type = null;
        try {
            type = this.findFactory(scheme, context);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (type != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Found PollDynamicAware: {} via: {}{}", new Object[]{type.getName(), this.factoryFinder.getResourcePath(), scheme});
            }
            if (PollDynamicAware.class.isAssignableFrom(type)) {
                PollDynamicAware answer = (PollDynamicAware)context.getInjector().newInstance(type, false);
                answer.setScheme(scheme);
                answer.setCamelContext(context);
                return answer;
            }
            throw new IllegalArgumentException("Type is not a PollDynamicAware implementation. Found: " + type.getName());
        }
        return null;
    }

    private Class<?> findFactory(String name, CamelContext context) {
        if (this.factoryFinder == null) {
            this.factoryFinder = context.getCamelContextExtension().getFactoryFinder(RESOURCE_PATH);
        }
        return this.factoryFinder.findClass(name).orElse(null);
    }
}

