/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.RollbackExchangeException;
import org.apache.camel.Traceable;
import org.apache.camel.processor.BaseProcessorSupport;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.RouteIdAware;

public class RollbackProcessor
extends BaseProcessorSupport
implements Traceable,
IdAware,
RouteIdAware {
    private String id;
    private String routeId;
    private boolean markRollbackOnly;
    private boolean markRollbackOnlyLast;
    private String message;

    public RollbackProcessor() {
    }

    public RollbackProcessor(String message) {
        this.message = message;
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        if (this.isMarkRollbackOnlyLast()) {
            exchange.setRollbackOnlyLast(true);
        } else {
            exchange.setRollbackOnly(true);
        }
        if (this.markRollbackOnly || this.markRollbackOnlyLast) {
            callback.done(true);
            return true;
        }
        if (this.message != null) {
            exchange.setException((Throwable)new RollbackExchangeException(this.message, exchange));
        } else {
            exchange.setException((Throwable)new RollbackExchangeException(exchange));
        }
        callback.done(true);
        return true;
    }

    public String toString() {
        return this.id;
    }

    public String getTraceLabel() {
        return "rollback";
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRouteId() {
        return this.routeId;
    }

    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean isMarkRollbackOnly() {
        return this.markRollbackOnly;
    }

    public void setMarkRollbackOnly(boolean markRollbackOnly) {
        this.markRollbackOnly = markRollbackOnly;
    }

    public boolean isMarkRollbackOnlyLast() {
        return this.markRollbackOnlyLast;
    }

    public void setMarkRollbackOnlyLast(boolean markRollbackOnlyLast) {
        this.markRollbackOnlyLast = markRollbackOnlyLast;
    }
}

