/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.annotation;

import java.util.LinkedHashSet;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.beans.factory.aot.BeanRegistrationAotContribution;
import org.springframework.beans.factory.aot.BeanRegistrationAotProcessor;
import org.springframework.beans.factory.aot.BeanRegistrationCode;
import org.springframework.beans.factory.support.RegisteredBean;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.lang.Nullable;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

class TransactionBeanRegistrationAotProcessor
implements BeanRegistrationAotProcessor {
    private static final String JAKARTA_TRANSACTIONAL_CLASS_NAME = "jakarta.transaction.Transactional";

    TransactionBeanRegistrationAotProcessor() {
    }

    @Override
    @Nullable
    public BeanRegistrationAotContribution processAheadOfTime(RegisteredBean registeredBean) {
        Class<?> beanClass = registeredBean.getBeanClass();
        if (this.isTransactional(beanClass)) {
            return new AotContribution(beanClass);
        }
        return null;
    }

    private boolean isTransactional(Class<?> beanClass) {
        LinkedHashSet elements = new LinkedHashSet();
        elements.add(beanClass);
        ReflectionUtils.doWithMethods(beanClass, elements::add);
        for (Class<?> interfaceClass : ClassUtils.getAllInterfacesForClass(beanClass)) {
            elements.add(interfaceClass);
            ReflectionUtils.doWithMethods(interfaceClass, elements::add);
        }
        return elements.stream().anyMatch(element -> {
            MergedAnnotations mergedAnnotations = MergedAnnotations.from(element, MergedAnnotations.SearchStrategy.TYPE_HIERARCHY);
            return mergedAnnotations.isPresent(Transactional.class) || mergedAnnotations.isPresent(JAKARTA_TRANSACTIONAL_CLASS_NAME);
        });
    }

    private static class AotContribution
    implements BeanRegistrationAotContribution {
        private final Class<?> beanClass;

        public AotContribution(Class<?> beanClass) {
            this.beanClass = beanClass;
        }

        @Override
        public void applyTo(GenerationContext generationContext, BeanRegistrationCode beanRegistrationCode) {
            Class<?>[] proxyInterfaces;
            RuntimeHints runtimeHints = generationContext.getRuntimeHints();
            for (Class<?> proxyInterface : proxyInterfaces = ClassUtils.getAllInterfacesForClass(this.beanClass)) {
                runtimeHints.reflection().registerType(proxyInterface, MemberCategory.INVOKE_DECLARED_METHODS);
            }
        }
    }
}

