/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import java.util.concurrent.TimeUnit;
import org.apache.camel.NamedNode;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.SamplingDefinition;
import org.apache.camel.processor.SamplingThrottler;
import org.apache.camel.reifier.ProcessorReifier;

public class SamplingReifier
extends ProcessorReifier<SamplingDefinition> {
    public SamplingReifier(Route route, ProcessorDefinition<?> definition) {
        super(route, (SamplingDefinition)definition);
    }

    @Override
    public Processor createProcessor() throws Exception {
        SamplingThrottler answer;
        Long freq = this.parseLong(((SamplingDefinition)this.definition).getMessageFrequency());
        if (freq != null) {
            answer = new SamplingThrottler(freq.longValue());
        } else {
            long time = this.parseDuration(((SamplingDefinition)this.definition).getSamplePeriod(), 1L);
            answer = new SamplingThrottler(time, TimeUnit.MILLISECONDS);
        }
        answer.setDisabled(SamplingReifier.isDisabled(this.camelContext, (NamedNode)this.definition));
        return answer;
    }
}

