/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.service.serializer.json;

import java.lang.reflect.InvocationTargetException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.YearMonth;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import java.util.Deque;
import java.util.TimeZone;
import javax.management.AttributeNotFoundException;
import org.jolokia.server.core.config.ConfigKey;
import org.jolokia.service.serializer.json.Extractor;
import org.jolokia.service.serializer.json.ObjectToJsonConverter;
import org.jolokia.service.serializer.object.StringToObjectConverter;

public class TemporalExtractor
implements Extractor {
    private DateTimeFormatter formatter;
    protected boolean useUnixTimestamp = false;
    protected boolean useUnixMillis = false;
    protected boolean useUnixNanos = false;

    public TemporalExtractor(String dateFormat, TimeZone timeZone) {
        if ("time".equals(dateFormat) || "long".equals(dateFormat) || "millis".equals(dateFormat)) {
            this.useUnixMillis = true;
        } else if ("unix".equals(dateFormat)) {
            this.useUnixTimestamp = true;
        } else if ("nanos".equals(dateFormat)) {
            this.useUnixNanos = true;
        } else {
            try {
                this.formatter = DateTimeFormatter.ofPattern(dateFormat).withZone(timeZone.toZoneId());
            }
            catch (IllegalArgumentException e) {
                this.formatter = DateTimeFormatter.ofPattern(ConfigKey.DATE_FORMAT.getDefaultValue()).withZone(TimeZone.getTimeZone(ConfigKey.DATE_FORMAT_ZONE.getDefaultValue()).toZoneId());
            }
        }
    }

    @Override
    public Class<?> getType() {
        return Temporal.class;
    }

    @Override
    public Object extractObject(ObjectToJsonConverter pConverter, Object pValue, Deque<String> pExtraArgs, boolean jsonify) throws AttributeNotFoundException {
        if (!jsonify || pValue == null) {
            return pValue;
        }
        Temporal temporal = (Temporal)pValue;
        boolean hasInstant = temporal.isSupported(ChronoField.INSTANT_SECONDS);
        if (hasInstant) {
            if (this.useUnixTimestamp) {
                return temporal.getLong(ChronoField.INSTANT_SECONDS);
            }
            if (this.useUnixMillis) {
                return temporal.getLong(ChronoField.INSTANT_SECONDS) * 1000L + temporal.getLong(ChronoField.MILLI_OF_SECOND);
            }
            if (this.useUnixNanos) {
                return temporal.getLong(ChronoField.INSTANT_SECONDS) * 1000000000L + temporal.getLong(ChronoField.NANO_OF_SECOND);
            }
            return this.formatter.format(temporal);
        }
        LocalDateTime now = LocalDateTime.now();
        int year = temporal.isSupported(ChronoField.YEAR) ? temporal.get(ChronoField.YEAR) : now.getYear();
        int month = temporal.isSupported(ChronoField.MONTH_OF_YEAR) ? temporal.get(ChronoField.MONTH_OF_YEAR) : now.getMonthValue();
        int day = temporal.isSupported(ChronoField.DAY_OF_MONTH) ? temporal.get(ChronoField.DAY_OF_MONTH) : now.getDayOfMonth();
        int hour = temporal.isSupported(ChronoField.HOUR_OF_DAY) ? temporal.get(ChronoField.HOUR_OF_DAY) : 0;
        int minute = temporal.isSupported(ChronoField.MINUTE_OF_HOUR) ? temporal.get(ChronoField.MINUTE_OF_HOUR) : 0;
        int seconds = temporal.isSupported(ChronoField.SECOND_OF_MINUTE) ? temporal.get(ChronoField.SECOND_OF_MINUTE) : 0;
        int nanos = temporal.isSupported(ChronoField.NANO_OF_SECOND) ? temporal.get(ChronoField.NANO_OF_SECOND) : 0;
        ZoneOffset offset = null;
        if (temporal.isSupported(ChronoField.OFFSET_SECONDS)) {
            offset = ZoneOffset.ofTotalSeconds(temporal.get(ChronoField.OFFSET_SECONDS));
        } else if (temporal instanceof LocalDateTime) {
            offset = this.formatter.getZone().getRules().getOffset((LocalDateTime)temporal);
        } else if (temporal instanceof LocalDate) {
            offset = this.formatter.getZone().getRules().getOffset(LocalDateTime.of((LocalDate)temporal, LocalTime.of(0, 0, 0)));
        } else if (temporal instanceof YearMonth) {
            int y = ((YearMonth)temporal).getYear();
            int m = ((YearMonth)temporal).getMonthValue();
            offset = this.formatter.getZone().getRules().getOffset(LocalDateTime.of(LocalDate.of(y, m, 1), LocalTime.of(0, 0, 0)));
        } else {
            offset = temporal instanceof OffsetTime ? ((OffsetTime)temporal).getOffset() : this.formatter.getZone().getRules().getOffset(Instant.now());
        }
        OffsetDateTime odt = OffsetDateTime.of(year, month, day, hour, minute, seconds, nanos, offset);
        return this.formatter.format(odt);
    }

    @Override
    public Object setObjectValue(StringToObjectConverter pConverter, Object pInner, String pAttribute, Object pValue) throws IllegalAccessException, InvocationTargetException, IllegalArgumentException {
        throw new IllegalArgumentException("java.time.Temporal instance is immutable an cannot change its value");
    }

    @Override
    public boolean canSetValue() {
        return false;
    }
}

