/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.factory.serialize;

import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import javax.jms.Message;
import javax.jms.Session;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.cli.commands.tools.xml.XMLMessageExporter;
import org.apache.activemq.artemis.cli.commands.tools.xml.XMLMessageImporter;
import org.apache.activemq.artemis.cli.commands.tools.xml.XmlDataExporter;
import org.apache.activemq.artemis.cli.factory.serialize.MessageSerializer;
import org.apache.activemq.artemis.jms.client.ActiveMQMessage;
import org.apache.activemq.artemis.jms.client.ActiveMQSession;
import org.apache.activemq.artemis.utils.XmlProvider;

public class XMLMessageSerializer
implements MessageSerializer {
    private XMLMessageExporter writer;
    private XMLMessageImporter reader;
    private ClientSession clientSession;
    private OutputStream out;

    @Override
    public synchronized Message read() throws Exception {
        this.reader.getRawXMLReader().nextTag();
        if (this.reader.getRawXMLReader().getLocalName().equals("messages")) {
            return null;
        }
        XMLMessageImporter.MessageInfo messageInfo = this.reader.readMessage(true);
        if (messageInfo == null) {
            return null;
        }
        ActiveMQMessage jmsMessage = new ActiveMQMessage((ClientMessage)messageInfo.message, this.clientSession);
        return jmsMessage;
    }

    @Override
    public synchronized void write(Message message) {
        try {
            ClientMessage core = ((ActiveMQMessage)message).getCoreMessage();
            this.writer.printSingleMessageAsXML((ICoreMessage)core, null, true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setOutput(OutputStream outputStream) throws Exception {
        this.out = outputStream;
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        XMLStreamWriter rawXmlWriter = factory.createXMLStreamWriter(outputStream, "UTF-8");
        XmlDataExporter.PrettyPrintHandler handler = new XmlDataExporter.PrettyPrintHandler(rawXmlWriter);
        XMLStreamWriter xmlWriter = (XMLStreamWriter)Proxy.newProxyInstance(XMLStreamWriter.class.getClassLoader(), new Class[]{XMLStreamWriter.class}, (InvocationHandler)handler);
        this.writer = new XMLMessageExporter(xmlWriter);
    }

    @Override
    public void setInput(InputStream inputStream, Session session) throws Exception {
        XMLStreamReader streamReader = XmlProvider.createXMLStreamReader((InputStream)inputStream);
        this.clientSession = ((ActiveMQSession)session).getCoreSession();
        this.reader = new XMLMessageImporter(streamReader, this.clientSession);
    }

    @Override
    public synchronized void start() throws Exception {
        if (this.writer != null) {
            this.writer.getRawXMLWriter().writeStartDocument("1.0");
            this.writer.getRawXMLWriter().writeStartElement("messages");
        }
        if (this.reader != null) {
            this.reader.getRawXMLReader().nextTag();
        }
    }

    @Override
    public synchronized void stop() throws Exception {
        if (this.writer != null) {
            this.writer.getRawXMLWriter().writeEndElement();
            this.writer.getRawXMLWriter().writeEndDocument();
            this.writer.getRawXMLWriter().flush();
            this.writer.getRawXMLWriter().close();
            this.out.flush();
        }
    }
}

