/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.rumen;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public class RewindableInputStream
extends InputStream {
    private InputStream input;

    public RewindableInputStream(InputStream input) {
        this(input, 0x100000);
    }

    public RewindableInputStream(InputStream input, int maxBytesToRemember) {
        this.input = new BufferedInputStream(input, maxBytesToRemember);
        this.input.mark(maxBytesToRemember);
    }

    @Override
    public int read() throws IOException {
        return this.input.read();
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        return this.input.read(buffer, offset, length);
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }

    public InputStream rewind() throws IOException {
        try {
            this.input.reset();
            return this;
        }
        catch (IOException e) {
            throw new IOException("Unable to rewind the stream", e);
        }
    }
}

