/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to you under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.calcite.avatica.noop;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

/**
 * A {@link Statement} implementation which does nothing.
 */
public class AvaticaNoopStatement implements Statement {

  private static final AvaticaNoopStatement INSTANCE = new AvaticaNoopStatement();

  public static AvaticaNoopStatement getInstance() {
    return INSTANCE;
  }

  private AvaticaNoopStatement() {}

  private UnsupportedOperationException unsupported() {
    return new UnsupportedOperationException("Unsupported");
  }

  @Override public ResultSet executeQuery(String sql) throws SQLException {
    return AvaticaNoopResultSet.getInstance();
  }

  @Override public int executeUpdate(String sql) throws SQLException {
    return 1;
  }

  @Override public void close() throws SQLException {}

  @Override public int getMaxFieldSize() throws SQLException {
    throw unsupported();
  }

  @Override public void setMaxFieldSize(int max) throws SQLException {}

  @Override public int getMaxRows() throws SQLException {
    throw unsupported();
  }

  @Override public void setMaxRows(int max) throws SQLException {}

  @Override public void setEscapeProcessing(boolean enable) throws SQLException {}

  @Override public int getQueryTimeout() throws SQLException {
    throw unsupported();
  }

  @Override public void setQueryTimeout(int seconds) throws SQLException {}

  @Override public void cancel() throws SQLException {}

  @Override public SQLWarning getWarnings() throws SQLException {
    throw unsupported();
  }

  @Override public void clearWarnings() throws SQLException {}

  @Override public void setCursorName(String name) throws SQLException {}

  @Override public boolean execute(String sql) throws SQLException {
    return false;
  }

  @Override public ResultSet getResultSet() throws SQLException {
    return AvaticaNoopResultSet.getInstance();
  }

  @Override public int getUpdateCount() throws SQLException {
    return 1;
  }

  @Override public boolean getMoreResults() throws SQLException {
    return false;
  }

  @Override public void setFetchDirection(int direction) throws SQLException {}

  @Override public int getFetchDirection() throws SQLException {
    throw unsupported();
  }

  @Override public void setFetchSize(int rows) throws SQLException {}

  @Override public int getFetchSize() throws SQLException {
    throw unsupported();
  }

  @Override public int getResultSetConcurrency() throws SQLException {
    throw unsupported();
  }

  @Override public int getResultSetType() throws SQLException {
    throw unsupported();
  }

  @Override public void addBatch(String sql) throws SQLException {}

  @Override public void clearBatch() throws SQLException {}

  @Override public int[] executeBatch() throws SQLException {
    return new int[0];
  }

  @Override public Connection getConnection() throws SQLException {
    return AvaticaNoopConnection.getInstance();
  }

  @Override public boolean getMoreResults(int current) throws SQLException {
    throw unsupported();
  }

  @Override public ResultSet getGeneratedKeys() throws SQLException {
    throw unsupported();
  }

  @Override public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
    return 1;
  }

  @Override public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
    return 1;
  }

  @Override public int executeUpdate(String sql, String[] columnNames) throws SQLException {
    return 1;
  }

  @Override public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
    return true;
  }

  @Override public boolean execute(String sql, int[] columnIndexes) throws SQLException {
    return true;
  }

  @Override public boolean execute(String sql, String[] columnNames) throws SQLException {
    return true;
  }

  @Override public int getResultSetHoldability() throws SQLException {
    throw unsupported();
  }

  @Override public boolean isClosed() throws SQLException {
    return false;
  }

  @Override public void setPoolable(boolean poolable) throws SQLException {}

  @Override public boolean isPoolable() throws SQLException {
    return true;
  }

  @Override public void closeOnCompletion() throws SQLException {}

  @Override public boolean isCloseOnCompletion() throws SQLException {
    throw unsupported();
  }

  @Override public <T> T unwrap(Class<T> iface) throws SQLException {
    throw unsupported();
  }

  @Override public boolean isWrapperFor(Class<?> iface) throws SQLException {
    throw unsupported();
  }
}

// End AvaticaNoopStatement.java
