//
// Licensed to the Apache Software Foundation (ASF) under one or more
// contributor license agreements.  See the NOTICE file distributed with
// this work for additional information regarding copyright ownership.
// The ASF licenses this file to you under the Apache License, Version 2.0
// (the "License"); you may not use this file except in compliance with
// the License.  You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.5
// 	protoc        v5.29.3
// source: common.proto

package message

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Has to be consistent with Meta.StatementType
type StatementType int32

const (
	StatementType_SELECT    StatementType = 0
	StatementType_INSERT    StatementType = 1
	StatementType_UPDATE    StatementType = 2
	StatementType_DELETE    StatementType = 3
	StatementType_UPSERT    StatementType = 4
	StatementType_MERGE     StatementType = 5
	StatementType_OTHER_DML StatementType = 6
	StatementType_CREATE    StatementType = 7
	StatementType_DROP      StatementType = 8
	StatementType_ALTER     StatementType = 9
	StatementType_OTHER_DDL StatementType = 10
	StatementType_CALL      StatementType = 11
)

// Enum value maps for StatementType.
var (
	StatementType_name = map[int32]string{
		0:  "SELECT",
		1:  "INSERT",
		2:  "UPDATE",
		3:  "DELETE",
		4:  "UPSERT",
		5:  "MERGE",
		6:  "OTHER_DML",
		7:  "CREATE",
		8:  "DROP",
		9:  "ALTER",
		10: "OTHER_DDL",
		11: "CALL",
	}
	StatementType_value = map[string]int32{
		"SELECT":    0,
		"INSERT":    1,
		"UPDATE":    2,
		"DELETE":    3,
		"UPSERT":    4,
		"MERGE":     5,
		"OTHER_DML": 6,
		"CREATE":    7,
		"DROP":      8,
		"ALTER":     9,
		"OTHER_DDL": 10,
		"CALL":      11,
	}
)

func (x StatementType) Enum() *StatementType {
	p := new(StatementType)
	*p = x
	return p
}

func (x StatementType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (StatementType) Descriptor() protoreflect.EnumDescriptor {
	return file_common_proto_enumTypes[0].Descriptor()
}

func (StatementType) Type() protoreflect.EnumType {
	return &file_common_proto_enumTypes[0]
}

func (x StatementType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

type Rep int32

const (
	Rep_PRIMITIVE_BOOLEAN  Rep = 0
	Rep_PRIMITIVE_BYTE     Rep = 1
	Rep_PRIMITIVE_CHAR     Rep = 2
	Rep_PRIMITIVE_SHORT    Rep = 3
	Rep_PRIMITIVE_INT      Rep = 4
	Rep_PRIMITIVE_LONG     Rep = 5
	Rep_PRIMITIVE_FLOAT    Rep = 6
	Rep_PRIMITIVE_DOUBLE   Rep = 7
	Rep_BOOLEAN            Rep = 8
	Rep_BYTE               Rep = 9
	Rep_CHARACTER          Rep = 10
	Rep_SHORT              Rep = 11
	Rep_INTEGER            Rep = 12
	Rep_LONG               Rep = 13
	Rep_FLOAT              Rep = 14
	Rep_DOUBLE             Rep = 15
	Rep_BIG_INTEGER        Rep = 25
	Rep_BIG_DECIMAL        Rep = 26
	Rep_JAVA_SQL_TIME      Rep = 16
	Rep_JAVA_SQL_TIMESTAMP Rep = 17
	Rep_JAVA_SQL_DATE      Rep = 18
	Rep_JAVA_UTIL_DATE     Rep = 19
	Rep_BYTE_STRING        Rep = 20
	Rep_STRING             Rep = 21
	Rep_NUMBER             Rep = 22
	Rep_OBJECT             Rep = 23
	Rep_NULL               Rep = 24
	Rep_ARRAY              Rep = 27
	Rep_STRUCT             Rep = 28
	Rep_MULTISET           Rep = 29
)

// Enum value maps for Rep.
var (
	Rep_name = map[int32]string{
		0:  "PRIMITIVE_BOOLEAN",
		1:  "PRIMITIVE_BYTE",
		2:  "PRIMITIVE_CHAR",
		3:  "PRIMITIVE_SHORT",
		4:  "PRIMITIVE_INT",
		5:  "PRIMITIVE_LONG",
		6:  "PRIMITIVE_FLOAT",
		7:  "PRIMITIVE_DOUBLE",
		8:  "BOOLEAN",
		9:  "BYTE",
		10: "CHARACTER",
		11: "SHORT",
		12: "INTEGER",
		13: "LONG",
		14: "FLOAT",
		15: "DOUBLE",
		25: "BIG_INTEGER",
		26: "BIG_DECIMAL",
		16: "JAVA_SQL_TIME",
		17: "JAVA_SQL_TIMESTAMP",
		18: "JAVA_SQL_DATE",
		19: "JAVA_UTIL_DATE",
		20: "BYTE_STRING",
		21: "STRING",
		22: "NUMBER",
		23: "OBJECT",
		24: "NULL",
		27: "ARRAY",
		28: "STRUCT",
		29: "MULTISET",
	}
	Rep_value = map[string]int32{
		"PRIMITIVE_BOOLEAN":  0,
		"PRIMITIVE_BYTE":     1,
		"PRIMITIVE_CHAR":     2,
		"PRIMITIVE_SHORT":    3,
		"PRIMITIVE_INT":      4,
		"PRIMITIVE_LONG":     5,
		"PRIMITIVE_FLOAT":    6,
		"PRIMITIVE_DOUBLE":   7,
		"BOOLEAN":            8,
		"BYTE":               9,
		"CHARACTER":          10,
		"SHORT":              11,
		"INTEGER":            12,
		"LONG":               13,
		"FLOAT":              14,
		"DOUBLE":             15,
		"BIG_INTEGER":        25,
		"BIG_DECIMAL":        26,
		"JAVA_SQL_TIME":      16,
		"JAVA_SQL_TIMESTAMP": 17,
		"JAVA_SQL_DATE":      18,
		"JAVA_UTIL_DATE":     19,
		"BYTE_STRING":        20,
		"STRING":             21,
		"NUMBER":             22,
		"OBJECT":             23,
		"NULL":               24,
		"ARRAY":              27,
		"STRUCT":             28,
		"MULTISET":           29,
	}
)

func (x Rep) Enum() *Rep {
	p := new(Rep)
	*p = x
	return p
}

func (x Rep) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Rep) Descriptor() protoreflect.EnumDescriptor {
	return file_common_proto_enumTypes[1].Descriptor()
}

func (Rep) Type() protoreflect.EnumType {
	return &file_common_proto_enumTypes[1]
}

func (x Rep) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// The severity of some unexpected outcome to an operation.
// Protobuf enum values must be unique across all other enums
type Severity int32

const (
	Severity_UNKNOWN_SEVERITY Severity = 0
	Severity_FATAL_SEVERITY   Severity = 1
	Severity_ERROR_SEVERITY   Severity = 2
	Severity_WARNING_SEVERITY Severity = 3
)

// Enum value maps for Severity.
var (
	Severity_name = map[int32]string{
		0: "UNKNOWN_SEVERITY",
		1: "FATAL_SEVERITY",
		2: "ERROR_SEVERITY",
		3: "WARNING_SEVERITY",
	}
	Severity_value = map[string]int32{
		"UNKNOWN_SEVERITY": 0,
		"FATAL_SEVERITY":   1,
		"ERROR_SEVERITY":   2,
		"WARNING_SEVERITY": 3,
	}
)

func (x Severity) Enum() *Severity {
	p := new(Severity)
	*p = x
	return p
}

func (x Severity) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Severity) Descriptor() protoreflect.EnumDescriptor {
	return file_common_proto_enumTypes[2].Descriptor()
}

func (Severity) Type() protoreflect.EnumType {
	return &file_common_proto_enumTypes[2]
}

func (x Severity) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Enumeration corresponding to DatabaseMetaData operations
type MetaDataOperation int32

const (
	MetaDataOperation_GET_ATTRIBUTES             MetaDataOperation = 0
	MetaDataOperation_GET_BEST_ROW_IDENTIFIER    MetaDataOperation = 1
	MetaDataOperation_GET_CATALOGS               MetaDataOperation = 2
	MetaDataOperation_GET_CLIENT_INFO_PROPERTIES MetaDataOperation = 3
	MetaDataOperation_GET_COLUMN_PRIVILEGES      MetaDataOperation = 4
	MetaDataOperation_GET_COLUMNS                MetaDataOperation = 5
	MetaDataOperation_GET_CROSS_REFERENCE        MetaDataOperation = 6
	MetaDataOperation_GET_EXPORTED_KEYS          MetaDataOperation = 7
	MetaDataOperation_GET_FUNCTION_COLUMNS       MetaDataOperation = 8
	MetaDataOperation_GET_FUNCTIONS              MetaDataOperation = 9
	MetaDataOperation_GET_IMPORTED_KEYS          MetaDataOperation = 10
	MetaDataOperation_GET_INDEX_INFO             MetaDataOperation = 11
	MetaDataOperation_GET_PRIMARY_KEYS           MetaDataOperation = 12
	MetaDataOperation_GET_PROCEDURE_COLUMNS      MetaDataOperation = 13
	MetaDataOperation_GET_PROCEDURES             MetaDataOperation = 14
	MetaDataOperation_GET_PSEUDO_COLUMNS         MetaDataOperation = 15
	MetaDataOperation_GET_SCHEMAS                MetaDataOperation = 16
	MetaDataOperation_GET_SCHEMAS_WITH_ARGS      MetaDataOperation = 17
	MetaDataOperation_GET_SUPER_TABLES           MetaDataOperation = 18
	MetaDataOperation_GET_SUPER_TYPES            MetaDataOperation = 19
	MetaDataOperation_GET_TABLE_PRIVILEGES       MetaDataOperation = 20
	MetaDataOperation_GET_TABLES                 MetaDataOperation = 21
	MetaDataOperation_GET_TABLE_TYPES            MetaDataOperation = 22
	MetaDataOperation_GET_TYPE_INFO              MetaDataOperation = 23
	MetaDataOperation_GET_UDTS                   MetaDataOperation = 24
	MetaDataOperation_GET_VERSION_COLUMNS        MetaDataOperation = 25
)

// Enum value maps for MetaDataOperation.
var (
	MetaDataOperation_name = map[int32]string{
		0:  "GET_ATTRIBUTES",
		1:  "GET_BEST_ROW_IDENTIFIER",
		2:  "GET_CATALOGS",
		3:  "GET_CLIENT_INFO_PROPERTIES",
		4:  "GET_COLUMN_PRIVILEGES",
		5:  "GET_COLUMNS",
		6:  "GET_CROSS_REFERENCE",
		7:  "GET_EXPORTED_KEYS",
		8:  "GET_FUNCTION_COLUMNS",
		9:  "GET_FUNCTIONS",
		10: "GET_IMPORTED_KEYS",
		11: "GET_INDEX_INFO",
		12: "GET_PRIMARY_KEYS",
		13: "GET_PROCEDURE_COLUMNS",
		14: "GET_PROCEDURES",
		15: "GET_PSEUDO_COLUMNS",
		16: "GET_SCHEMAS",
		17: "GET_SCHEMAS_WITH_ARGS",
		18: "GET_SUPER_TABLES",
		19: "GET_SUPER_TYPES",
		20: "GET_TABLE_PRIVILEGES",
		21: "GET_TABLES",
		22: "GET_TABLE_TYPES",
		23: "GET_TYPE_INFO",
		24: "GET_UDTS",
		25: "GET_VERSION_COLUMNS",
	}
	MetaDataOperation_value = map[string]int32{
		"GET_ATTRIBUTES":             0,
		"GET_BEST_ROW_IDENTIFIER":    1,
		"GET_CATALOGS":               2,
		"GET_CLIENT_INFO_PROPERTIES": 3,
		"GET_COLUMN_PRIVILEGES":      4,
		"GET_COLUMNS":                5,
		"GET_CROSS_REFERENCE":        6,
		"GET_EXPORTED_KEYS":          7,
		"GET_FUNCTION_COLUMNS":       8,
		"GET_FUNCTIONS":              9,
		"GET_IMPORTED_KEYS":          10,
		"GET_INDEX_INFO":             11,
		"GET_PRIMARY_KEYS":           12,
		"GET_PROCEDURE_COLUMNS":      13,
		"GET_PROCEDURES":             14,
		"GET_PSEUDO_COLUMNS":         15,
		"GET_SCHEMAS":                16,
		"GET_SCHEMAS_WITH_ARGS":      17,
		"GET_SUPER_TABLES":           18,
		"GET_SUPER_TYPES":            19,
		"GET_TABLE_PRIVILEGES":       20,
		"GET_TABLES":                 21,
		"GET_TABLE_TYPES":            22,
		"GET_TYPE_INFO":              23,
		"GET_UDTS":                   24,
		"GET_VERSION_COLUMNS":        25,
	}
)

func (x MetaDataOperation) Enum() *MetaDataOperation {
	p := new(MetaDataOperation)
	*p = x
	return p
}

func (x MetaDataOperation) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MetaDataOperation) Descriptor() protoreflect.EnumDescriptor {
	return file_common_proto_enumTypes[3].Descriptor()
}

func (MetaDataOperation) Type() protoreflect.EnumType {
	return &file_common_proto_enumTypes[3]
}

func (x MetaDataOperation) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

type StateType int32

const (
	StateType_SQL      StateType = 0
	StateType_METADATA StateType = 1
)

// Enum value maps for StateType.
var (
	StateType_name = map[int32]string{
		0: "SQL",
		1: "METADATA",
	}
	StateType_value = map[string]int32{
		"SQL":      0,
		"METADATA": 1,
	}
)

func (x StateType) Enum() *StateType {
	p := new(StateType)
	*p = x
	return p
}

func (x StateType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (StateType) Descriptor() protoreflect.EnumDescriptor {
	return file_common_proto_enumTypes[4].Descriptor()
}

func (StateType) Type() protoreflect.EnumType {
	return &file_common_proto_enumTypes[4]
}

func (x StateType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

type CursorFactory_Style int32

const (
	CursorFactory_OBJECT            CursorFactory_Style = 0
	CursorFactory_RECORD            CursorFactory_Style = 1
	CursorFactory_RECORD_PROJECTION CursorFactory_Style = 2
	CursorFactory_ARRAY             CursorFactory_Style = 3
	CursorFactory_LIST              CursorFactory_Style = 4
	CursorFactory_MAP               CursorFactory_Style = 5
)

// Enum value maps for CursorFactory_Style.
var (
	CursorFactory_Style_name = map[int32]string{
		0: "OBJECT",
		1: "RECORD",
		2: "RECORD_PROJECTION",
		3: "ARRAY",
		4: "LIST",
		5: "MAP",
	}
	CursorFactory_Style_value = map[string]int32{
		"OBJECT":            0,
		"RECORD":            1,
		"RECORD_PROJECTION": 2,
		"ARRAY":             3,
		"LIST":              4,
		"MAP":               5,
	}
)

func (x CursorFactory_Style) Enum() *CursorFactory_Style {
	p := new(CursorFactory_Style)
	*p = x
	return p
}

func (x CursorFactory_Style) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CursorFactory_Style) Descriptor() protoreflect.EnumDescriptor {
	return file_common_proto_enumTypes[5].Descriptor()
}

func (CursorFactory_Style) Type() protoreflect.EnumType {
	return &file_common_proto_enumTypes[5]
}

func (x CursorFactory_Style) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

type MetaDataOperationArgument_ArgumentType int32

const (
	MetaDataOperationArgument_STRING          MetaDataOperationArgument_ArgumentType = 0
	MetaDataOperationArgument_BOOL            MetaDataOperationArgument_ArgumentType = 1
	MetaDataOperationArgument_INT             MetaDataOperationArgument_ArgumentType = 2
	MetaDataOperationArgument_REPEATED_STRING MetaDataOperationArgument_ArgumentType = 3
	MetaDataOperationArgument_REPEATED_INT    MetaDataOperationArgument_ArgumentType = 4
	MetaDataOperationArgument_NULL            MetaDataOperationArgument_ArgumentType = 5
)

// Enum value maps for MetaDataOperationArgument_ArgumentType.
var (
	MetaDataOperationArgument_ArgumentType_name = map[int32]string{
		0: "STRING",
		1: "BOOL",
		2: "INT",
		3: "REPEATED_STRING",
		4: "REPEATED_INT",
		5: "NULL",
	}
	MetaDataOperationArgument_ArgumentType_value = map[string]int32{
		"STRING":          0,
		"BOOL":            1,
		"INT":             2,
		"REPEATED_STRING": 3,
		"REPEATED_INT":    4,
		"NULL":            5,
	}
)

func (x MetaDataOperationArgument_ArgumentType) Enum() *MetaDataOperationArgument_ArgumentType {
	p := new(MetaDataOperationArgument_ArgumentType)
	*p = x
	return p
}

func (x MetaDataOperationArgument_ArgumentType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MetaDataOperationArgument_ArgumentType) Descriptor() protoreflect.EnumDescriptor {
	return file_common_proto_enumTypes[6].Descriptor()
}

func (MetaDataOperationArgument_ArgumentType) Type() protoreflect.EnumType {
	return &file_common_proto_enumTypes[6]
}

func (x MetaDataOperationArgument_ArgumentType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Details about a connection
type ConnectionProperties struct {
	state                           protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_IsDirty              bool                   `protobuf:"varint,1,opt,name=is_dirty,json=isDirty,proto3"`
	xxx_hidden_AutoCommit           bool                   `protobuf:"varint,2,opt,name=auto_commit,json=autoCommit,proto3"`
	xxx_hidden_HasAutoCommit        bool                   `protobuf:"varint,7,opt,name=has_auto_commit,json=hasAutoCommit,proto3"`
	xxx_hidden_ReadOnly             bool                   `protobuf:"varint,3,opt,name=read_only,json=readOnly,proto3"`
	xxx_hidden_HasReadOnly          bool                   `protobuf:"varint,8,opt,name=has_read_only,json=hasReadOnly,proto3"`
	xxx_hidden_TransactionIsolation uint32                 `protobuf:"varint,4,opt,name=transaction_isolation,json=transactionIsolation,proto3"`
	xxx_hidden_Catalog              string                 `protobuf:"bytes,5,opt,name=catalog,proto3"`
	xxx_hidden_Schema               string                 `protobuf:"bytes,6,opt,name=schema,proto3"`
	unknownFields                   protoimpl.UnknownFields
	sizeCache                       protoimpl.SizeCache
}

func (x *ConnectionProperties) Reset() {
	*x = ConnectionProperties{}
	mi := &file_common_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ConnectionProperties) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConnectionProperties) ProtoMessage() {}

func (x *ConnectionProperties) ProtoReflect() protoreflect.Message {
	mi := &file_common_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ConnectionProperties) GetIsDirty() bool {
	if x != nil {
		return x.xxx_hidden_IsDirty
	}
	return false
}

func (x *ConnectionProperties) GetAutoCommit() bool {
	if x != nil {
		return x.xxx_hidden_AutoCommit
	}
	return false
}

func (x *ConnectionProperties) GetHasAutoCommit() bool {
	if x != nil {
		return x.xxx_hidden_HasAutoCommit
	}
	return false
}

func (x *ConnectionProperties) GetReadOnly() bool {
	if x != nil {
		return x.xxx_hidden_ReadOnly
	}
	return false
}

func (x *ConnectionProperties) GetHasReadOnly() bool {
	if x != nil {
		return x.xxx_hidden_HasReadOnly
	}
	return false
}

func (x *ConnectionProperties) GetTransactionIsolation() uint32 {
	if x != nil {
		return x.xxx_hidden_TransactionIsolation
	}
	return 0
}

func (x *ConnectionProperties) GetCatalog() string {
	if x != nil {
		return x.xxx_hidden_Catalog
	}
	return ""
}

func (x *ConnectionProperties) GetSchema() string {
	if x != nil {
		return x.xxx_hidden_Schema
	}
	return ""
}

func (x *ConnectionProperties) SetIsDirty(v bool) {
	x.xxx_hidden_IsDirty = v
}

func (x *ConnectionProperties) SetAutoCommit(v bool) {
	x.xxx_hidden_AutoCommit = v
}

func (x *ConnectionProperties) SetHasAutoCommit(v bool) {
	x.xxx_hidden_HasAutoCommit = v
}

func (x *ConnectionProperties) SetReadOnly(v bool) {
	x.xxx_hidden_ReadOnly = v
}

func (x *ConnectionProperties) SetHasReadOnly(v bool) {
	x.xxx_hidden_HasReadOnly = v
}

func (x *ConnectionProperties) SetTransactionIsolation(v uint32) {
	x.xxx_hidden_TransactionIsolation = v
}

func (x *ConnectionProperties) SetCatalog(v string) {
	x.xxx_hidden_Catalog = v
}

func (x *ConnectionProperties) SetSchema(v string) {
	x.xxx_hidden_Schema = v
}

type ConnectionProperties_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	IsDirty              bool
	AutoCommit           bool
	HasAutoCommit        bool
	ReadOnly             bool
	HasReadOnly          bool
	TransactionIsolation uint32
	Catalog              string
	Schema               string
}

func (b0 ConnectionProperties_builder) Build() *ConnectionProperties {
	m0 := &ConnectionProperties{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_IsDirty = b.IsDirty
	x.xxx_hidden_AutoCommit = b.AutoCommit
	x.xxx_hidden_HasAutoCommit = b.HasAutoCommit
	x.xxx_hidden_ReadOnly = b.ReadOnly
	x.xxx_hidden_HasReadOnly = b.HasReadOnly
	x.xxx_hidden_TransactionIsolation = b.TransactionIsolation
	x.xxx_hidden_Catalog = b.Catalog
	x.xxx_hidden_Schema = b.Schema
	return m0
}

// Statement handle
type StatementHandle struct {
	state                   protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_ConnectionId string                 `protobuf:"bytes,1,opt,name=connection_id,json=connectionId,proto3"`
	xxx_hidden_Id           uint32                 `protobuf:"varint,2,opt,name=id,proto3"`
	xxx_hidden_Signature    *Signature             `protobuf:"bytes,3,opt,name=signature,proto3"`
	unknownFields           protoimpl.UnknownFields
	sizeCache               protoimpl.SizeCache
}

func (x *StatementHandle) Reset() {
	*x = StatementHandle{}
	mi := &file_common_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StatementHandle) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StatementHandle) ProtoMessage() {}

func (x *StatementHandle) ProtoReflect() protoreflect.Message {
	mi := &file_common_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *StatementHandle) GetConnectionId() string {
	if x != nil {
		return x.xxx_hidden_ConnectionId
	}
	return ""
}

func (x *StatementHandle) GetId() uint32 {
	if x != nil {
		return x.xxx_hidden_Id
	}
	return 0
}

func (x *StatementHandle) GetSignature() *Signature {
	if x != nil {
		return x.xxx_hidden_Signature
	}
	return nil
}

func (x *StatementHandle) SetConnectionId(v string) {
	x.xxx_hidden_ConnectionId = v
}

func (x *StatementHandle) SetId(v uint32) {
	x.xxx_hidden_Id = v
}

func (x *StatementHandle) SetSignature(v *Signature) {
	x.xxx_hidden_Signature = v
}

func (x *StatementHandle) HasSignature() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Signature != nil
}

func (x *StatementHandle) ClearSignature() {
	x.xxx_hidden_Signature = nil
}

type StatementHandle_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	ConnectionId string
	Id           uint32
	Signature    *Signature
}

func (b0 StatementHandle_builder) Build() *StatementHandle {
	m0 := &StatementHandle{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_ConnectionId = b.ConnectionId
	x.xxx_hidden_Id = b.Id
	x.xxx_hidden_Signature = b.Signature
	return m0
}

// Results of preparing a statement
type Signature struct {
	state                    protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Columns       *[]*ColumnMetaData     `protobuf:"bytes,1,rep,name=columns,proto3"`
	xxx_hidden_Sql           string                 `protobuf:"bytes,2,opt,name=sql,proto3"`
	xxx_hidden_Parameters    *[]*AvaticaParameter   `protobuf:"bytes,3,rep,name=parameters,proto3"`
	xxx_hidden_CursorFactory *CursorFactory         `protobuf:"bytes,4,opt,name=cursor_factory,json=cursorFactory,proto3"`
	xxx_hidden_StatementType StatementType          `protobuf:"varint,5,opt,name=statementType,proto3,enum=StatementType"`
	unknownFields            protoimpl.UnknownFields
	sizeCache                protoimpl.SizeCache
}

func (x *Signature) Reset() {
	*x = Signature{}
	mi := &file_common_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Signature) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Signature) ProtoMessage() {}

func (x *Signature) ProtoReflect() protoreflect.Message {
	mi := &file_common_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *Signature) GetColumns() []*ColumnMetaData {
	if x != nil {
		if x.xxx_hidden_Columns != nil {
			return *x.xxx_hidden_Columns
		}
	}
	return nil
}

func (x *Signature) GetSql() string {
	if x != nil {
		return x.xxx_hidden_Sql
	}
	return ""
}

func (x *Signature) GetParameters() []*AvaticaParameter {
	if x != nil {
		if x.xxx_hidden_Parameters != nil {
			return *x.xxx_hidden_Parameters
		}
	}
	return nil
}

func (x *Signature) GetCursorFactory() *CursorFactory {
	if x != nil {
		return x.xxx_hidden_CursorFactory
	}
	return nil
}

func (x *Signature) GetStatementType() StatementType {
	if x != nil {
		return x.xxx_hidden_StatementType
	}
	return StatementType_SELECT
}

func (x *Signature) SetColumns(v []*ColumnMetaData) {
	x.xxx_hidden_Columns = &v
}

func (x *Signature) SetSql(v string) {
	x.xxx_hidden_Sql = v
}

func (x *Signature) SetParameters(v []*AvaticaParameter) {
	x.xxx_hidden_Parameters = &v
}

func (x *Signature) SetCursorFactory(v *CursorFactory) {
	x.xxx_hidden_CursorFactory = v
}

func (x *Signature) SetStatementType(v StatementType) {
	x.xxx_hidden_StatementType = v
}

func (x *Signature) HasCursorFactory() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_CursorFactory != nil
}

func (x *Signature) ClearCursorFactory() {
	x.xxx_hidden_CursorFactory = nil
}

type Signature_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Columns       []*ColumnMetaData
	Sql           string
	Parameters    []*AvaticaParameter
	CursorFactory *CursorFactory
	StatementType StatementType
}

func (b0 Signature_builder) Build() *Signature {
	m0 := &Signature{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Columns = &b.Columns
	x.xxx_hidden_Sql = b.Sql
	x.xxx_hidden_Parameters = &b.Parameters
	x.xxx_hidden_CursorFactory = b.CursorFactory
	x.xxx_hidden_StatementType = b.StatementType
	return m0
}

type ColumnMetaData struct {
	state                         protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Ordinal            uint32                 `protobuf:"varint,1,opt,name=ordinal,proto3"`
	xxx_hidden_AutoIncrement      bool                   `protobuf:"varint,2,opt,name=auto_increment,json=autoIncrement,proto3"`
	xxx_hidden_CaseSensitive      bool                   `protobuf:"varint,3,opt,name=case_sensitive,json=caseSensitive,proto3"`
	xxx_hidden_Searchable         bool                   `protobuf:"varint,4,opt,name=searchable,proto3"`
	xxx_hidden_Currency           bool                   `protobuf:"varint,5,opt,name=currency,proto3"`
	xxx_hidden_Nullable           uint32                 `protobuf:"varint,6,opt,name=nullable,proto3"`
	xxx_hidden_Signed             bool                   `protobuf:"varint,7,opt,name=signed,proto3"`
	xxx_hidden_DisplaySize        uint32                 `protobuf:"varint,8,opt,name=display_size,json=displaySize,proto3"`
	xxx_hidden_Label              string                 `protobuf:"bytes,9,opt,name=label,proto3"`
	xxx_hidden_ColumnName         string                 `protobuf:"bytes,10,opt,name=column_name,json=columnName,proto3"`
	xxx_hidden_SchemaName         string                 `protobuf:"bytes,11,opt,name=schema_name,json=schemaName,proto3"`
	xxx_hidden_Precision          uint32                 `protobuf:"varint,12,opt,name=precision,proto3"`
	xxx_hidden_Scale              uint32                 `protobuf:"varint,13,opt,name=scale,proto3"`
	xxx_hidden_TableName          string                 `protobuf:"bytes,14,opt,name=table_name,json=tableName,proto3"`
	xxx_hidden_CatalogName        string                 `protobuf:"bytes,15,opt,name=catalog_name,json=catalogName,proto3"`
	xxx_hidden_ReadOnly           bool                   `protobuf:"varint,16,opt,name=read_only,json=readOnly,proto3"`
	xxx_hidden_Writable           bool                   `protobuf:"varint,17,opt,name=writable,proto3"`
	xxx_hidden_DefinitelyWritable bool                   `protobuf:"varint,18,opt,name=definitely_writable,json=definitelyWritable,proto3"`
	xxx_hidden_ColumnClassName    string                 `protobuf:"bytes,19,opt,name=column_class_name,json=columnClassName,proto3"`
	xxx_hidden_Type               *AvaticaType           `protobuf:"bytes,20,opt,name=type,proto3"`
	unknownFields                 protoimpl.UnknownFields
	sizeCache                     protoimpl.SizeCache
}

func (x *ColumnMetaData) Reset() {
	*x = ColumnMetaData{}
	mi := &file_common_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ColumnMetaData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ColumnMetaData) ProtoMessage() {}

func (x *ColumnMetaData) ProtoReflect() protoreflect.Message {
	mi := &file_common_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ColumnMetaData) GetOrdinal() uint32 {
	if x != nil {
		return x.xxx_hidden_Ordinal
	}
	return 0
}

func (x *ColumnMetaData) GetAutoIncrement() bool {
	if x != nil {
		return x.xxx_hidden_AutoIncrement
	}
	return false
}

func (x *ColumnMetaData) GetCaseSensitive() bool {
	if x != nil {
		return x.xxx_hidden_CaseSensitive
	}
	return false
}

func (x *ColumnMetaData) GetSearchable() bool {
	if x != nil {
		return x.xxx_hidden_Searchable
	}
	return false
}

func (x *ColumnMetaData) GetCurrency() bool {
	if x != nil {
		return x.xxx_hidden_Currency
	}
	return false
}

func (x *ColumnMetaData) GetNullable() uint32 {
	if x != nil {
		return x.xxx_hidden_Nullable
	}
	return 0
}

func (x *ColumnMetaData) GetSigned() bool {
	if x != nil {
		return x.xxx_hidden_Signed
	}
	return false
}

func (x *ColumnMetaData) GetDisplaySize() uint32 {
	if x != nil {
		return x.xxx_hidden_DisplaySize
	}
	return 0
}

func (x *ColumnMetaData) GetLabel() string {
	if x != nil {
		return x.xxx_hidden_Label
	}
	return ""
}

func (x *ColumnMetaData) GetColumnName() string {
	if x != nil {
		return x.xxx_hidden_ColumnName
	}
	return ""
}

func (x *ColumnMetaData) GetSchemaName() string {
	if x != nil {
		return x.xxx_hidden_SchemaName
	}
	return ""
}

func (x *ColumnMetaData) GetPrecision() uint32 {
	if x != nil {
		return x.xxx_hidden_Precision
	}
	return 0
}

func (x *ColumnMetaData) GetScale() uint32 {
	if x != nil {
		return x.xxx_hidden_Scale
	}
	return 0
}

func (x *ColumnMetaData) GetTableName() string {
	if x != nil {
		return x.xxx_hidden_TableName
	}
	return ""
}

func (x *ColumnMetaData) GetCatalogName() string {
	if x != nil {
		return x.xxx_hidden_CatalogName
	}
	return ""
}

func (x *ColumnMetaData) GetReadOnly() bool {
	if x != nil {
		return x.xxx_hidden_ReadOnly
	}
	return false
}

func (x *ColumnMetaData) GetWritable() bool {
	if x != nil {
		return x.xxx_hidden_Writable
	}
	return false
}

func (x *ColumnMetaData) GetDefinitelyWritable() bool {
	if x != nil {
		return x.xxx_hidden_DefinitelyWritable
	}
	return false
}

func (x *ColumnMetaData) GetColumnClassName() string {
	if x != nil {
		return x.xxx_hidden_ColumnClassName
	}
	return ""
}

func (x *ColumnMetaData) GetType() *AvaticaType {
	if x != nil {
		return x.xxx_hidden_Type
	}
	return nil
}

func (x *ColumnMetaData) SetOrdinal(v uint32) {
	x.xxx_hidden_Ordinal = v
}

func (x *ColumnMetaData) SetAutoIncrement(v bool) {
	x.xxx_hidden_AutoIncrement = v
}

func (x *ColumnMetaData) SetCaseSensitive(v bool) {
	x.xxx_hidden_CaseSensitive = v
}

func (x *ColumnMetaData) SetSearchable(v bool) {
	x.xxx_hidden_Searchable = v
}

func (x *ColumnMetaData) SetCurrency(v bool) {
	x.xxx_hidden_Currency = v
}

func (x *ColumnMetaData) SetNullable(v uint32) {
	x.xxx_hidden_Nullable = v
}

func (x *ColumnMetaData) SetSigned(v bool) {
	x.xxx_hidden_Signed = v
}

func (x *ColumnMetaData) SetDisplaySize(v uint32) {
	x.xxx_hidden_DisplaySize = v
}

func (x *ColumnMetaData) SetLabel(v string) {
	x.xxx_hidden_Label = v
}

func (x *ColumnMetaData) SetColumnName(v string) {
	x.xxx_hidden_ColumnName = v
}

func (x *ColumnMetaData) SetSchemaName(v string) {
	x.xxx_hidden_SchemaName = v
}

func (x *ColumnMetaData) SetPrecision(v uint32) {
	x.xxx_hidden_Precision = v
}

func (x *ColumnMetaData) SetScale(v uint32) {
	x.xxx_hidden_Scale = v
}

func (x *ColumnMetaData) SetTableName(v string) {
	x.xxx_hidden_TableName = v
}

func (x *ColumnMetaData) SetCatalogName(v string) {
	x.xxx_hidden_CatalogName = v
}

func (x *ColumnMetaData) SetReadOnly(v bool) {
	x.xxx_hidden_ReadOnly = v
}

func (x *ColumnMetaData) SetWritable(v bool) {
	x.xxx_hidden_Writable = v
}

func (x *ColumnMetaData) SetDefinitelyWritable(v bool) {
	x.xxx_hidden_DefinitelyWritable = v
}

func (x *ColumnMetaData) SetColumnClassName(v string) {
	x.xxx_hidden_ColumnClassName = v
}

func (x *ColumnMetaData) SetType(v *AvaticaType) {
	x.xxx_hidden_Type = v
}

func (x *ColumnMetaData) HasType() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Type != nil
}

func (x *ColumnMetaData) ClearType() {
	x.xxx_hidden_Type = nil
}

type ColumnMetaData_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Ordinal            uint32
	AutoIncrement      bool
	CaseSensitive      bool
	Searchable         bool
	Currency           bool
	Nullable           uint32
	Signed             bool
	DisplaySize        uint32
	Label              string
	ColumnName         string
	SchemaName         string
	Precision          uint32
	Scale              uint32
	TableName          string
	CatalogName        string
	ReadOnly           bool
	Writable           bool
	DefinitelyWritable bool
	ColumnClassName    string
	Type               *AvaticaType
}

func (b0 ColumnMetaData_builder) Build() *ColumnMetaData {
	m0 := &ColumnMetaData{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Ordinal = b.Ordinal
	x.xxx_hidden_AutoIncrement = b.AutoIncrement
	x.xxx_hidden_CaseSensitive = b.CaseSensitive
	x.xxx_hidden_Searchable = b.Searchable
	x.xxx_hidden_Currency = b.Currency
	x.xxx_hidden_Nullable = b.Nullable
	x.xxx_hidden_Signed = b.Signed
	x.xxx_hidden_DisplaySize = b.DisplaySize
	x.xxx_hidden_Label = b.Label
	x.xxx_hidden_ColumnName = b.ColumnName
	x.xxx_hidden_SchemaName = b.SchemaName
	x.xxx_hidden_Precision = b.Precision
	x.xxx_hidden_Scale = b.Scale
	x.xxx_hidden_TableName = b.TableName
	x.xxx_hidden_CatalogName = b.CatalogName
	x.xxx_hidden_ReadOnly = b.ReadOnly
	x.xxx_hidden_Writable = b.Writable
	x.xxx_hidden_DefinitelyWritable = b.DefinitelyWritable
	x.xxx_hidden_ColumnClassName = b.ColumnClassName
	x.xxx_hidden_Type = b.Type
	return m0
}

// Base class for a column type
type AvaticaType struct {
	state                protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Id        uint32                 `protobuf:"varint,1,opt,name=id,proto3"`
	xxx_hidden_Name      string                 `protobuf:"bytes,2,opt,name=name,proto3"`
	xxx_hidden_Rep       Rep                    `protobuf:"varint,3,opt,name=rep,proto3,enum=Rep"`
	xxx_hidden_Columns   *[]*ColumnMetaData     `protobuf:"bytes,4,rep,name=columns,proto3"`
	xxx_hidden_Component *AvaticaType           `protobuf:"bytes,5,opt,name=component,proto3"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *AvaticaType) Reset() {
	*x = AvaticaType{}
	mi := &file_common_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AvaticaType) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AvaticaType) ProtoMessage() {}

func (x *AvaticaType) ProtoReflect() protoreflect.Message {
	mi := &file_common_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *AvaticaType) GetId() uint32 {
	if x != nil {
		return x.xxx_hidden_Id
	}
	return 0
}

func (x *AvaticaType) GetName() string {
	if x != nil {
		return x.xxx_hidden_Name
	}
	return ""
}

func (x *AvaticaType) GetRep() Rep {
	if x != nil {
		return x.xxx_hidden_Rep
	}
	return Rep_PRIMITIVE_BOOLEAN
}

func (x *AvaticaType) GetColumns() []*ColumnMetaData {
	if x != nil {
		if x.xxx_hidden_Columns != nil {
			return *x.xxx_hidden_Columns
		}
	}
	return nil
}

func (x *AvaticaType) GetComponent() *AvaticaType {
	if x != nil {
		return x.xxx_hidden_Component
	}
	return nil
}

func (x *AvaticaType) SetId(v uint32) {
	x.xxx_hidden_Id = v
}

func (x *AvaticaType) SetName(v string) {
	x.xxx_hidden_Name = v
}

func (x *AvaticaType) SetRep(v Rep) {
	x.xxx_hidden_Rep = v
}

func (x *AvaticaType) SetColumns(v []*ColumnMetaData) {
	x.xxx_hidden_Columns = &v
}

func (x *AvaticaType) SetComponent(v *AvaticaType) {
	x.xxx_hidden_Component = v
}

func (x *AvaticaType) HasComponent() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Component != nil
}

func (x *AvaticaType) ClearComponent() {
	x.xxx_hidden_Component = nil
}

type AvaticaType_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Id        uint32
	Name      string
	Rep       Rep
	Columns   []*ColumnMetaData
	Component *AvaticaType
}

func (b0 AvaticaType_builder) Build() *AvaticaType {
	m0 := &AvaticaType{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Id = b.Id
	x.xxx_hidden_Name = b.Name
	x.xxx_hidden_Rep = b.Rep
	x.xxx_hidden_Columns = &b.Columns
	x.xxx_hidden_Component = b.Component
	return m0
}

// Metadata for a parameter
type AvaticaParameter struct {
	state                    protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Signed        bool                   `protobuf:"varint,1,opt,name=signed,proto3"`
	xxx_hidden_Precision     uint32                 `protobuf:"varint,2,opt,name=precision,proto3"`
	xxx_hidden_Scale         uint32                 `protobuf:"varint,3,opt,name=scale,proto3"`
	xxx_hidden_ParameterType uint32                 `protobuf:"varint,4,opt,name=parameter_type,json=parameterType,proto3"`
	xxx_hidden_TypeName      string                 `protobuf:"bytes,5,opt,name=type_name,json=typeName,proto3"`
	xxx_hidden_ClassName     string                 `protobuf:"bytes,6,opt,name=class_name,json=className,proto3"`
	xxx_hidden_Name          string                 `protobuf:"bytes,7,opt,name=name,proto3"`
	unknownFields            protoimpl.UnknownFields
	sizeCache                protoimpl.SizeCache
}

func (x *AvaticaParameter) Reset() {
	*x = AvaticaParameter{}
	mi := &file_common_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AvaticaParameter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AvaticaParameter) ProtoMessage() {}

func (x *AvaticaParameter) ProtoReflect() protoreflect.Message {
	mi := &file_common_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *AvaticaParameter) GetSigned() bool {
	if x != nil {
		return x.xxx_hidden_Signed
	}
	return false
}

func (x *AvaticaParameter) GetPrecision() uint32 {
	if x != nil {
		return x.xxx_hidden_Precision
	}
	return 0
}

func (x *AvaticaParameter) GetScale() uint32 {
	if x != nil {
		return x.xxx_hidden_Scale
	}
	return 0
}

func (x *AvaticaParameter) GetParameterType() uint32 {
	if x != nil {
		return x.xxx_hidden_ParameterType
	}
	return 0
}

func (x *AvaticaParameter) GetTypeName() string {
	if x != nil {
		return x.xxx_hidden_TypeName
	}
	return ""
}

func (x *AvaticaParameter) GetClassName() string {
	if x != nil {
		return x.xxx_hidden_ClassName
	}
	return ""
}

func (x *AvaticaParameter) GetName() string {
	if x != nil {
		return x.xxx_hidden_Name
	}
	return ""
}

func (x *AvaticaParameter) SetSigned(v bool) {
	x.xxx_hidden_Signed = v
}

func (x *AvaticaParameter) SetPrecision(v uint32) {
	x.xxx_hidden_Precision = v
}

func (x *AvaticaParameter) SetScale(v uint32) {
	x.xxx_hidden_Scale = v
}

func (x *AvaticaParameter) SetParameterType(v uint32) {
	x.xxx_hidden_ParameterType = v
}

func (x *AvaticaParameter) SetTypeName(v string) {
	x.xxx_hidden_TypeName = v
}

func (x *AvaticaParameter) SetClassName(v string) {
	x.xxx_hidden_ClassName = v
}

func (x *AvaticaParameter) SetName(v string) {
	x.xxx_hidden_Name = v
}

type AvaticaParameter_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Signed        bool
	Precision     uint32
	Scale         uint32
	ParameterType uint32
	TypeName      string
	ClassName     string
	Name          string
}

func (b0 AvaticaParameter_builder) Build() *AvaticaParameter {
	m0 := &AvaticaParameter{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Signed = b.Signed
	x.xxx_hidden_Precision = b.Precision
	x.xxx_hidden_Scale = b.Scale
	x.xxx_hidden_ParameterType = b.ParameterType
	x.xxx_hidden_TypeName = b.TypeName
	x.xxx_hidden_ClassName = b.ClassName
	x.xxx_hidden_Name = b.Name
	return m0
}

// Information necessary to convert an Iterable into a Calcite Cursor
type CursorFactory struct {
	state                 protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Style      CursorFactory_Style    `protobuf:"varint,1,opt,name=style,proto3,enum=CursorFactory_Style"`
	xxx_hidden_ClassName  string                 `protobuf:"bytes,2,opt,name=class_name,json=className,proto3"`
	xxx_hidden_FieldNames []string               `protobuf:"bytes,3,rep,name=field_names,json=fieldNames,proto3"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *CursorFactory) Reset() {
	*x = CursorFactory{}
	mi := &file_common_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CursorFactory) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CursorFactory) ProtoMessage() {}

func (x *CursorFactory) ProtoReflect() protoreflect.Message {
	mi := &file_common_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *CursorFactory) GetStyle() CursorFactory_Style {
	if x != nil {
		return x.xxx_hidden_Style
	}
	return CursorFactory_OBJECT
}

func (x *CursorFactory) GetClassName() string {
	if x != nil {
		return x.xxx_hidden_ClassName
	}
	return ""
}

func (x *CursorFactory) GetFieldNames() []string {
	if x != nil {
		return x.xxx_hidden_FieldNames
	}
	return nil
}

func (x *CursorFactory) SetStyle(v CursorFactory_Style) {
	x.xxx_hidden_Style = v
}

func (x *CursorFactory) SetClassName(v string) {
	x.xxx_hidden_ClassName = v
}

func (x *CursorFactory) SetFieldNames(v []string) {
	x.xxx_hidden_FieldNames = v
}

type CursorFactory_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Style      CursorFactory_Style
	ClassName  string
	FieldNames []string
}

func (b0 CursorFactory_builder) Build() *CursorFactory {
	m0 := &CursorFactory{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Style = b.Style
	x.xxx_hidden_ClassName = b.ClassName
	x.xxx_hidden_FieldNames = b.FieldNames
	return m0
}

// A collection of rows
type Frame struct {
	state             protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Offset uint64                 `protobuf:"varint,1,opt,name=offset,proto3"`
	xxx_hidden_Done   bool                   `protobuf:"varint,2,opt,name=done,proto3"`
	xxx_hidden_Rows   *[]*Row                `protobuf:"bytes,3,rep,name=rows,proto3"`
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *Frame) Reset() {
	*x = Frame{}
	mi := &file_common_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Frame) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Frame) ProtoMessage() {}

func (x *Frame) ProtoReflect() protoreflect.Message {
	mi := &file_common_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *Frame) GetOffset() uint64 {
	if x != nil {
		return x.xxx_hidden_Offset
	}
	return 0
}

func (x *Frame) GetDone() bool {
	if x != nil {
		return x.xxx_hidden_Done
	}
	return false
}

func (x *Frame) GetRows() []*Row {
	if x != nil {
		if x.xxx_hidden_Rows != nil {
			return *x.xxx_hidden_Rows
		}
	}
	return nil
}

func (x *Frame) SetOffset(v uint64) {
	x.xxx_hidden_Offset = v
}

func (x *Frame) SetDone(v bool) {
	x.xxx_hidden_Done = v
}

func (x *Frame) SetRows(v []*Row) {
	x.xxx_hidden_Rows = &v
}

type Frame_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Offset uint64
	Done   bool
	Rows   []*Row
}

func (b0 Frame_builder) Build() *Frame {
	m0 := &Frame{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Offset = b.Offset
	x.xxx_hidden_Done = b.Done
	x.xxx_hidden_Rows = &b.Rows
	return m0
}

// A row is a collection of values
type Row struct {
	state            protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Value *[]*ColumnValue        `protobuf:"bytes,1,rep,name=value,proto3"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *Row) Reset() {
	*x = Row{}
	mi := &file_common_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Row) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Row) ProtoMessage() {}

func (x *Row) ProtoReflect() protoreflect.Message {
	mi := &file_common_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *Row) GetValue() []*ColumnValue {
	if x != nil {
		if x.xxx_hidden_Value != nil {
			return *x.xxx_hidden_Value
		}
	}
	return nil
}

func (x *Row) SetValue(v []*ColumnValue) {
	x.xxx_hidden_Value = &v
}

type Row_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Value []*ColumnValue
}

func (b0 Row_builder) Build() *Row {
	m0 := &Row{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Value = &b.Value
	return m0
}

// Database property, list of functions the database provides for a certain operation
type DatabaseProperty struct {
	state                protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Name      string                 `protobuf:"bytes,1,opt,name=name,proto3"`
	xxx_hidden_Functions []string               `protobuf:"bytes,2,rep,name=functions,proto3"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *DatabaseProperty) Reset() {
	*x = DatabaseProperty{}
	mi := &file_common_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DatabaseProperty) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DatabaseProperty) ProtoMessage() {}

func (x *DatabaseProperty) ProtoReflect() protoreflect.Message {
	mi := &file_common_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *DatabaseProperty) GetName() string {
	if x != nil {
		return x.xxx_hidden_Name
	}
	return ""
}

func (x *DatabaseProperty) GetFunctions() []string {
	if x != nil {
		return x.xxx_hidden_Functions
	}
	return nil
}

func (x *DatabaseProperty) SetName(v string) {
	x.xxx_hidden_Name = v
}

func (x *DatabaseProperty) SetFunctions(v []string) {
	x.xxx_hidden_Functions = v
}

type DatabaseProperty_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Name      string
	Functions []string
}

func (b0 DatabaseProperty_builder) Build() *DatabaseProperty {
	m0 := &DatabaseProperty{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Name = b.Name
	x.xxx_hidden_Functions = b.Functions
	return m0
}

// Message which encapsulates another message to support a single RPC endpoint
type WireMessage struct {
	state                     protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Name           string                 `protobuf:"bytes,1,opt,name=name,proto3"`
	xxx_hidden_WrappedMessage []byte                 `protobuf:"bytes,2,opt,name=wrapped_message,json=wrappedMessage,proto3"`
	unknownFields             protoimpl.UnknownFields
	sizeCache                 protoimpl.SizeCache
}

func (x *WireMessage) Reset() {
	*x = WireMessage{}
	mi := &file_common_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WireMessage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WireMessage) ProtoMessage() {}

func (x *WireMessage) ProtoReflect() protoreflect.Message {
	mi := &file_common_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *WireMessage) GetName() string {
	if x != nil {
		return x.xxx_hidden_Name
	}
	return ""
}

func (x *WireMessage) GetWrappedMessage() []byte {
	if x != nil {
		return x.xxx_hidden_WrappedMessage
	}
	return nil
}

func (x *WireMessage) SetName(v string) {
	x.xxx_hidden_Name = v
}

func (x *WireMessage) SetWrappedMessage(v []byte) {
	if v == nil {
		v = []byte{}
	}
	x.xxx_hidden_WrappedMessage = v
}

type WireMessage_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Name           string
	WrappedMessage []byte
}

func (b0 WireMessage_builder) Build() *WireMessage {
	m0 := &WireMessage{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Name = b.Name
	x.xxx_hidden_WrappedMessage = b.WrappedMessage
	return m0
}

// A value might be a TypedValue or an Array of TypedValue's
type ColumnValue struct {
	state                    protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Value         *[]*TypedValue         `protobuf:"bytes,1,rep,name=value,proto3"`
	xxx_hidden_ArrayValue    *[]*TypedValue         `protobuf:"bytes,2,rep,name=array_value,json=arrayValue,proto3"`
	xxx_hidden_HasArrayValue bool                   `protobuf:"varint,3,opt,name=has_array_value,json=hasArrayValue,proto3"`
	xxx_hidden_ScalarValue   *TypedValue            `protobuf:"bytes,4,opt,name=scalar_value,json=scalarValue,proto3"`
	unknownFields            protoimpl.UnknownFields
	sizeCache                protoimpl.SizeCache
}

func (x *ColumnValue) Reset() {
	*x = ColumnValue{}
	mi := &file_common_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ColumnValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ColumnValue) ProtoMessage() {}

func (x *ColumnValue) ProtoReflect() protoreflect.Message {
	mi := &file_common_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ColumnValue) GetValue() []*TypedValue {
	if x != nil {
		if x.xxx_hidden_Value != nil {
			return *x.xxx_hidden_Value
		}
	}
	return nil
}

func (x *ColumnValue) GetArrayValue() []*TypedValue {
	if x != nil {
		if x.xxx_hidden_ArrayValue != nil {
			return *x.xxx_hidden_ArrayValue
		}
	}
	return nil
}

func (x *ColumnValue) GetHasArrayValue() bool {
	if x != nil {
		return x.xxx_hidden_HasArrayValue
	}
	return false
}

func (x *ColumnValue) GetScalarValue() *TypedValue {
	if x != nil {
		return x.xxx_hidden_ScalarValue
	}
	return nil
}

func (x *ColumnValue) SetValue(v []*TypedValue) {
	x.xxx_hidden_Value = &v
}

func (x *ColumnValue) SetArrayValue(v []*TypedValue) {
	x.xxx_hidden_ArrayValue = &v
}

func (x *ColumnValue) SetHasArrayValue(v bool) {
	x.xxx_hidden_HasArrayValue = v
}

func (x *ColumnValue) SetScalarValue(v *TypedValue) {
	x.xxx_hidden_ScalarValue = v
}

func (x *ColumnValue) HasScalarValue() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_ScalarValue != nil
}

func (x *ColumnValue) ClearScalarValue() {
	x.xxx_hidden_ScalarValue = nil
}

type ColumnValue_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Value         []*TypedValue
	ArrayValue    []*TypedValue
	HasArrayValue bool
	ScalarValue   *TypedValue
}

func (b0 ColumnValue_builder) Build() *ColumnValue {
	m0 := &ColumnValue{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Value = &b.Value
	x.xxx_hidden_ArrayValue = &b.ArrayValue
	x.xxx_hidden_HasArrayValue = b.HasArrayValue
	x.xxx_hidden_ScalarValue = b.ScalarValue
	return m0
}

// Generic wrapper to support any SQL type. Struct-like to work around no polymorphism construct.
type TypedValue struct {
	state                     protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Type           Rep                    `protobuf:"varint,1,opt,name=type,proto3,enum=Rep"`
	xxx_hidden_BoolValue      bool                   `protobuf:"varint,2,opt,name=bool_value,json=boolValue,proto3"`
	xxx_hidden_StringValue    string                 `protobuf:"bytes,3,opt,name=string_value,json=stringValue,proto3"`
	xxx_hidden_NumberValue    int64                  `protobuf:"zigzag64,4,opt,name=number_value,json=numberValue,proto3"`
	xxx_hidden_BytesValue     []byte                 `protobuf:"bytes,5,opt,name=bytes_value,json=bytesValue,proto3"`
	xxx_hidden_DoubleValue    float64                `protobuf:"fixed64,6,opt,name=double_value,json=doubleValue,proto3"`
	xxx_hidden_Null           bool                   `protobuf:"varint,7,opt,name=null,proto3"`
	xxx_hidden_ArrayValue     *[]*TypedValue         `protobuf:"bytes,8,rep,name=array_value,json=arrayValue,proto3"`
	xxx_hidden_ComponentType  Rep                    `protobuf:"varint,9,opt,name=component_type,json=componentType,proto3,enum=Rep"`
	xxx_hidden_ImplicitlyNull bool                   `protobuf:"varint,10,opt,name=implicitly_null,json=implicitlyNull,proto3"`
	unknownFields             protoimpl.UnknownFields
	sizeCache                 protoimpl.SizeCache
}

func (x *TypedValue) Reset() {
	*x = TypedValue{}
	mi := &file_common_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TypedValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TypedValue) ProtoMessage() {}

func (x *TypedValue) ProtoReflect() protoreflect.Message {
	mi := &file_common_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *TypedValue) GetType() Rep {
	if x != nil {
		return x.xxx_hidden_Type
	}
	return Rep_PRIMITIVE_BOOLEAN
}

func (x *TypedValue) GetBoolValue() bool {
	if x != nil {
		return x.xxx_hidden_BoolValue
	}
	return false
}

func (x *TypedValue) GetStringValue() string {
	if x != nil {
		return x.xxx_hidden_StringValue
	}
	return ""
}

func (x *TypedValue) GetNumberValue() int64 {
	if x != nil {
		return x.xxx_hidden_NumberValue
	}
	return 0
}

func (x *TypedValue) GetBytesValue() []byte {
	if x != nil {
		return x.xxx_hidden_BytesValue
	}
	return nil
}

func (x *TypedValue) GetDoubleValue() float64 {
	if x != nil {
		return x.xxx_hidden_DoubleValue
	}
	return 0
}

func (x *TypedValue) GetNull() bool {
	if x != nil {
		return x.xxx_hidden_Null
	}
	return false
}

func (x *TypedValue) GetArrayValue() []*TypedValue {
	if x != nil {
		if x.xxx_hidden_ArrayValue != nil {
			return *x.xxx_hidden_ArrayValue
		}
	}
	return nil
}

func (x *TypedValue) GetComponentType() Rep {
	if x != nil {
		return x.xxx_hidden_ComponentType
	}
	return Rep_PRIMITIVE_BOOLEAN
}

func (x *TypedValue) GetImplicitlyNull() bool {
	if x != nil {
		return x.xxx_hidden_ImplicitlyNull
	}
	return false
}

func (x *TypedValue) SetType(v Rep) {
	x.xxx_hidden_Type = v
}

func (x *TypedValue) SetBoolValue(v bool) {
	x.xxx_hidden_BoolValue = v
}

func (x *TypedValue) SetStringValue(v string) {
	x.xxx_hidden_StringValue = v
}

func (x *TypedValue) SetNumberValue(v int64) {
	x.xxx_hidden_NumberValue = v
}

func (x *TypedValue) SetBytesValue(v []byte) {
	if v == nil {
		v = []byte{}
	}
	x.xxx_hidden_BytesValue = v
}

func (x *TypedValue) SetDoubleValue(v float64) {
	x.xxx_hidden_DoubleValue = v
}

func (x *TypedValue) SetNull(v bool) {
	x.xxx_hidden_Null = v
}

func (x *TypedValue) SetArrayValue(v []*TypedValue) {
	x.xxx_hidden_ArrayValue = &v
}

func (x *TypedValue) SetComponentType(v Rep) {
	x.xxx_hidden_ComponentType = v
}

func (x *TypedValue) SetImplicitlyNull(v bool) {
	x.xxx_hidden_ImplicitlyNull = v
}

type TypedValue_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Type        Rep
	BoolValue   bool
	StringValue string
	NumberValue int64
	// includes numeric types and date/time types.
	BytesValue     []byte
	DoubleValue    float64
	Null           bool
	ArrayValue     []*TypedValue
	ComponentType  Rep
	ImplicitlyNull bool
}

func (b0 TypedValue_builder) Build() *TypedValue {
	m0 := &TypedValue{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Type = b.Type
	x.xxx_hidden_BoolValue = b.BoolValue
	x.xxx_hidden_StringValue = b.StringValue
	x.xxx_hidden_NumberValue = b.NumberValue
	x.xxx_hidden_BytesValue = b.BytesValue
	x.xxx_hidden_DoubleValue = b.DoubleValue
	x.xxx_hidden_Null = b.Null
	x.xxx_hidden_ArrayValue = &b.ArrayValue
	x.xxx_hidden_ComponentType = b.ComponentType
	x.xxx_hidden_ImplicitlyNull = b.ImplicitlyNull
	return m0
}

// Represents the breadth of arguments to DatabaseMetaData functions
type MetaDataOperationArgument struct {
	state                        protoimpl.MessageState                 `protogen:"opaque.v1"`
	xxx_hidden_StringValue       string                                 `protobuf:"bytes,1,opt,name=string_value,json=stringValue,proto3"`
	xxx_hidden_BoolValue         bool                                   `protobuf:"varint,2,opt,name=bool_value,json=boolValue,proto3"`
	xxx_hidden_IntValue          int32                                  `protobuf:"zigzag32,3,opt,name=int_value,json=intValue,proto3"`
	xxx_hidden_StringArrayValues []string                               `protobuf:"bytes,4,rep,name=string_array_values,json=stringArrayValues,proto3"`
	xxx_hidden_IntArrayValues    []int32                                `protobuf:"zigzag32,5,rep,packed,name=int_array_values,json=intArrayValues,proto3"`
	xxx_hidden_Type              MetaDataOperationArgument_ArgumentType `protobuf:"varint,6,opt,name=type,proto3,enum=MetaDataOperationArgument_ArgumentType"`
	unknownFields                protoimpl.UnknownFields
	sizeCache                    protoimpl.SizeCache
}

func (x *MetaDataOperationArgument) Reset() {
	*x = MetaDataOperationArgument{}
	mi := &file_common_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MetaDataOperationArgument) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MetaDataOperationArgument) ProtoMessage() {}

func (x *MetaDataOperationArgument) ProtoReflect() protoreflect.Message {
	mi := &file_common_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *MetaDataOperationArgument) GetStringValue() string {
	if x != nil {
		return x.xxx_hidden_StringValue
	}
	return ""
}

func (x *MetaDataOperationArgument) GetBoolValue() bool {
	if x != nil {
		return x.xxx_hidden_BoolValue
	}
	return false
}

func (x *MetaDataOperationArgument) GetIntValue() int32 {
	if x != nil {
		return x.xxx_hidden_IntValue
	}
	return 0
}

func (x *MetaDataOperationArgument) GetStringArrayValues() []string {
	if x != nil {
		return x.xxx_hidden_StringArrayValues
	}
	return nil
}

func (x *MetaDataOperationArgument) GetIntArrayValues() []int32 {
	if x != nil {
		return x.xxx_hidden_IntArrayValues
	}
	return nil
}

func (x *MetaDataOperationArgument) GetType() MetaDataOperationArgument_ArgumentType {
	if x != nil {
		return x.xxx_hidden_Type
	}
	return MetaDataOperationArgument_STRING
}

func (x *MetaDataOperationArgument) SetStringValue(v string) {
	x.xxx_hidden_StringValue = v
}

func (x *MetaDataOperationArgument) SetBoolValue(v bool) {
	x.xxx_hidden_BoolValue = v
}

func (x *MetaDataOperationArgument) SetIntValue(v int32) {
	x.xxx_hidden_IntValue = v
}

func (x *MetaDataOperationArgument) SetStringArrayValues(v []string) {
	x.xxx_hidden_StringArrayValues = v
}

func (x *MetaDataOperationArgument) SetIntArrayValues(v []int32) {
	x.xxx_hidden_IntArrayValues = v
}

func (x *MetaDataOperationArgument) SetType(v MetaDataOperationArgument_ArgumentType) {
	x.xxx_hidden_Type = v
}

type MetaDataOperationArgument_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	StringValue       string
	BoolValue         bool
	IntValue          int32
	StringArrayValues []string
	IntArrayValues    []int32
	Type              MetaDataOperationArgument_ArgumentType
}

func (b0 MetaDataOperationArgument_builder) Build() *MetaDataOperationArgument {
	m0 := &MetaDataOperationArgument{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_StringValue = b.StringValue
	x.xxx_hidden_BoolValue = b.BoolValue
	x.xxx_hidden_IntValue = b.IntValue
	x.xxx_hidden_StringArrayValues = b.StringArrayValues
	x.xxx_hidden_IntArrayValues = b.IntArrayValues
	x.xxx_hidden_Type = b.Type
	return m0
}

type QueryState struct {
	state              protoimpl.MessageState        `protogen:"opaque.v1"`
	xxx_hidden_Type    StateType                     `protobuf:"varint,1,opt,name=type,proto3,enum=StateType"`
	xxx_hidden_Sql     string                        `protobuf:"bytes,2,opt,name=sql,proto3"`
	xxx_hidden_Op      MetaDataOperation             `protobuf:"varint,3,opt,name=op,proto3,enum=MetaDataOperation"`
	xxx_hidden_Args    *[]*MetaDataOperationArgument `protobuf:"bytes,4,rep,name=args,proto3"`
	xxx_hidden_HasArgs bool                          `protobuf:"varint,5,opt,name=has_args,json=hasArgs,proto3"`
	xxx_hidden_HasSql  bool                          `protobuf:"varint,6,opt,name=has_sql,json=hasSql,proto3"`
	xxx_hidden_HasOp   bool                          `protobuf:"varint,7,opt,name=has_op,json=hasOp,proto3"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *QueryState) Reset() {
	*x = QueryState{}
	mi := &file_common_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *QueryState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryState) ProtoMessage() {}

func (x *QueryState) ProtoReflect() protoreflect.Message {
	mi := &file_common_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *QueryState) GetType() StateType {
	if x != nil {
		return x.xxx_hidden_Type
	}
	return StateType_SQL
}

func (x *QueryState) GetSql() string {
	if x != nil {
		return x.xxx_hidden_Sql
	}
	return ""
}

func (x *QueryState) GetOp() MetaDataOperation {
	if x != nil {
		return x.xxx_hidden_Op
	}
	return MetaDataOperation_GET_ATTRIBUTES
}

func (x *QueryState) GetArgs() []*MetaDataOperationArgument {
	if x != nil {
		if x.xxx_hidden_Args != nil {
			return *x.xxx_hidden_Args
		}
	}
	return nil
}

func (x *QueryState) GetHasArgs() bool {
	if x != nil {
		return x.xxx_hidden_HasArgs
	}
	return false
}

func (x *QueryState) GetHasSql() bool {
	if x != nil {
		return x.xxx_hidden_HasSql
	}
	return false
}

func (x *QueryState) GetHasOp() bool {
	if x != nil {
		return x.xxx_hidden_HasOp
	}
	return false
}

func (x *QueryState) SetType(v StateType) {
	x.xxx_hidden_Type = v
}

func (x *QueryState) SetSql(v string) {
	x.xxx_hidden_Sql = v
}

func (x *QueryState) SetOp(v MetaDataOperation) {
	x.xxx_hidden_Op = v
}

func (x *QueryState) SetArgs(v []*MetaDataOperationArgument) {
	x.xxx_hidden_Args = &v
}

func (x *QueryState) SetHasArgs(v bool) {
	x.xxx_hidden_HasArgs = v
}

func (x *QueryState) SetHasSql(v bool) {
	x.xxx_hidden_HasSql = v
}

func (x *QueryState) SetHasOp(v bool) {
	x.xxx_hidden_HasOp = v
}

type QueryState_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Type    StateType
	Sql     string
	Op      MetaDataOperation
	Args    []*MetaDataOperationArgument
	HasArgs bool
	HasSql  bool
	HasOp   bool
}

func (b0 QueryState_builder) Build() *QueryState {
	m0 := &QueryState{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Type = b.Type
	x.xxx_hidden_Sql = b.Sql
	x.xxx_hidden_Op = b.Op
	x.xxx_hidden_Args = &b.Args
	x.xxx_hidden_HasArgs = b.HasArgs
	x.xxx_hidden_HasSql = b.HasSql
	x.xxx_hidden_HasOp = b.HasOp
	return m0
}

var File_common_proto protoreflect.FileDescriptor

var file_common_proto_rawDesc = string([]byte{
	0x0a, 0x0c, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xa2,
	0x02, 0x0a, 0x14, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f,
	0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x12, 0x19, 0x0a, 0x08, 0x69, 0x73, 0x5f, 0x64, 0x69,
	0x72, 0x74, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x69, 0x73, 0x44, 0x69, 0x72,
	0x74, 0x79, 0x12, 0x1f, 0x0a, 0x0b, 0x61, 0x75, 0x74, 0x6f, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x69,
	0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x61, 0x75, 0x74, 0x6f, 0x43, 0x6f, 0x6d,
	0x6d, 0x69, 0x74, 0x12, 0x26, 0x0a, 0x0f, 0x68, 0x61, 0x73, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x5f,
	0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0d, 0x68, 0x61,
	0x73, 0x41, 0x75, 0x74, 0x6f, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x72,
	0x65, 0x61, 0x64, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08,
	0x72, 0x65, 0x61, 0x64, 0x4f, 0x6e, 0x6c, 0x79, 0x12, 0x22, 0x0a, 0x0d, 0x68, 0x61, 0x73, 0x5f,
	0x72, 0x65, 0x61, 0x64, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x08, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x0b, 0x68, 0x61, 0x73, 0x52, 0x65, 0x61, 0x64, 0x4f, 0x6e, 0x6c, 0x79, 0x12, 0x33, 0x0a, 0x15,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x73, 0x6f, 0x6c,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x14, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x73, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x18, 0x0a, 0x07, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x07, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x12, 0x16, 0x0a, 0x06, 0x73,
	0x63, 0x68, 0x65, 0x6d, 0x61, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x73, 0x63, 0x68,
	0x65, 0x6d, 0x61, 0x22, 0x70, 0x0a, 0x0f, 0x53, 0x74, 0x61, 0x74, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x0e, 0x0a, 0x02, 0x69,
	0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x02, 0x69, 0x64, 0x12, 0x28, 0x0a, 0x09, 0x73,
	0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0a,
	0x2e, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x52, 0x09, 0x73, 0x69, 0x67, 0x6e,
	0x61, 0x74, 0x75, 0x72, 0x65, 0x22, 0xe8, 0x01, 0x0a, 0x09, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x74,
	0x75, 0x72, 0x65, 0x12, 0x29, 0x0a, 0x07, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x0f, 0x2e, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x44, 0x61, 0x74, 0x61, 0x52, 0x07, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x73, 0x12, 0x10,
	0x0a, 0x03, 0x73, 0x71, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x73, 0x71, 0x6c,
	0x12, 0x31, 0x0a, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x03,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x41, 0x76, 0x61, 0x74, 0x69, 0x63, 0x61, 0x50, 0x61,
	0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x52, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74,
	0x65, 0x72, 0x73, 0x12, 0x35, 0x0a, 0x0e, 0x63, 0x75, 0x72, 0x73, 0x6f, 0x72, 0x5f, 0x66, 0x61,
	0x63, 0x74, 0x6f, 0x72, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0e, 0x2e, 0x43, 0x75,
	0x72, 0x73, 0x6f, 0x72, 0x46, 0x61, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x0d, 0x63, 0x75, 0x72,
	0x73, 0x6f, 0x72, 0x46, 0x61, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x34, 0x0a, 0x0d, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x0e, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70,
	0x65, 0x52, 0x0d, 0x73, 0x74, 0x61, 0x74, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65,
	0x22, 0x91, 0x05, 0x0a, 0x0e, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x44,
	0x61, 0x74, 0x61, 0x12, 0x18, 0x0a, 0x07, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x61, 0x6c, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0d, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x61, 0x6c, 0x12, 0x25, 0x0a,
	0x0e, 0x61, 0x75, 0x74, 0x6f, 0x5f, 0x69, 0x6e, 0x63, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0d, 0x61, 0x75, 0x74, 0x6f, 0x49, 0x6e, 0x63, 0x72, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x12, 0x25, 0x0a, 0x0e, 0x63, 0x61, 0x73, 0x65, 0x5f, 0x73, 0x65, 0x6e,
	0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0d, 0x63, 0x61,
	0x73, 0x65, 0x53, 0x65, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x12, 0x1e, 0x0a, 0x0a, 0x73,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x0a, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x63,
	0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x63,
	0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x79, 0x12, 0x1a, 0x0a, 0x08, 0x6e, 0x75, 0x6c, 0x6c, 0x61,
	0x62, 0x6c, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x08, 0x6e, 0x75, 0x6c, 0x6c, 0x61,
	0x62, 0x6c, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x06, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x12, 0x21, 0x0a, 0x0c, 0x64,
	0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28,
	0x0d, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x14,
	0x0a, 0x05, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x12, 0x1f, 0x0a, 0x0b, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x63, 0x6f, 0x6c, 0x75, 0x6d,
	0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x73, 0x63, 0x68, 0x65,
	0x6d, 0x61, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x70, 0x72, 0x65, 0x63, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x09, 0x70, 0x72, 0x65, 0x63, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x63, 0x61, 0x6c, 0x65, 0x18, 0x0d, 0x20,
	0x01, 0x28, 0x0d, 0x52, 0x05, 0x73, 0x63, 0x61, 0x6c, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x74, 0x61,
	0x62, 0x6c, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x74, 0x61, 0x62, 0x6c, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x63, 0x61, 0x74,
	0x61, 0x6c, 0x6f, 0x67, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0b, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x09,
	0x72, 0x65, 0x61, 0x64, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x10, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x08, 0x72, 0x65, 0x61, 0x64, 0x4f, 0x6e, 0x6c, 0x79, 0x12, 0x1a, 0x0a, 0x08, 0x77, 0x72, 0x69,
	0x74, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x11, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x77, 0x72, 0x69,
	0x74, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x2f, 0x0a, 0x13, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74,
	0x65, 0x6c, 0x79, 0x5f, 0x77, 0x72, 0x69, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x12, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x12, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x65, 0x6c, 0x79, 0x57, 0x72,
	0x69, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x2a, 0x0a, 0x11, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e,
	0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x13, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0f, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x20, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x0c, 0x2e, 0x41, 0x76, 0x61, 0x74, 0x69, 0x63, 0x61, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04,
	0x74, 0x79, 0x70, 0x65, 0x22, 0xa0, 0x01, 0x0a, 0x0b, 0x41, 0x76, 0x61, 0x74, 0x69, 0x63, 0x61,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d,
	0x52, 0x02, 0x69, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x16, 0x0a, 0x03, 0x72, 0x65, 0x70, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x04, 0x2e, 0x52, 0x65, 0x70, 0x52, 0x03, 0x72, 0x65, 0x70,
	0x12, 0x29, 0x0a, 0x07, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x0f, 0x2e, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x44, 0x61,
	0x74, 0x61, 0x52, 0x07, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x73, 0x12, 0x2a, 0x0a, 0x09, 0x63,
	0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0c,
	0x2e, 0x41, 0x76, 0x61, 0x74, 0x69, 0x63, 0x61, 0x54, 0x79, 0x70, 0x65, 0x52, 0x09, 0x63, 0x6f,
	0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x22, 0xd5, 0x01, 0x0a, 0x10, 0x41, 0x76, 0x61, 0x74,
	0x69, 0x63, 0x61, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x12, 0x16, 0x0a, 0x06,
	0x73, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x73, 0x69,
	0x67, 0x6e, 0x65, 0x64, 0x12, 0x1c, 0x0a, 0x09, 0x70, 0x72, 0x65, 0x63, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x09, 0x70, 0x72, 0x65, 0x63, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x63, 0x61, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0d, 0x52, 0x05, 0x73, 0x63, 0x61, 0x6c, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x70, 0x61, 0x72, 0x61,
	0x6d, 0x65, 0x74, 0x65, 0x72, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0d,
	0x52, 0x0d, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x1b, 0x0a, 0x09, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x08, 0x74, 0x79, 0x70, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1d, 0x0a, 0x0a,
	0x63, 0x6c, 0x61, 0x73, 0x73, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22,
	0xd1, 0x01, 0x0a, 0x0d, 0x43, 0x75, 0x72, 0x73, 0x6f, 0x72, 0x46, 0x61, 0x63, 0x74, 0x6f, 0x72,
	0x79, 0x12, 0x2a, 0x0a, 0x05, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x14, 0x2e, 0x43, 0x75, 0x72, 0x73, 0x6f, 0x72, 0x46, 0x61, 0x63, 0x74, 0x6f, 0x72, 0x79,
	0x2e, 0x53, 0x74, 0x79, 0x6c, 0x65, 0x52, 0x05, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x12, 0x1d, 0x0a,
	0x0a, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x09, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1f, 0x0a, 0x0b,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x0a, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x22, 0x54, 0x0a,
	0x05, 0x53, 0x74, 0x79, 0x6c, 0x65, 0x12, 0x0a, 0x0a, 0x06, 0x4f, 0x42, 0x4a, 0x45, 0x43, 0x54,
	0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x52, 0x45, 0x43, 0x4f, 0x52, 0x44, 0x10, 0x01, 0x12, 0x15,
	0x0a, 0x11, 0x52, 0x45, 0x43, 0x4f, 0x52, 0x44, 0x5f, 0x50, 0x52, 0x4f, 0x4a, 0x45, 0x43, 0x54,
	0x49, 0x4f, 0x4e, 0x10, 0x02, 0x12, 0x09, 0x0a, 0x05, 0x41, 0x52, 0x52, 0x41, 0x59, 0x10, 0x03,
	0x12, 0x08, 0x0a, 0x04, 0x4c, 0x49, 0x53, 0x54, 0x10, 0x04, 0x12, 0x07, 0x0a, 0x03, 0x4d, 0x41,
	0x50, 0x10, 0x05, 0x22, 0x4d, 0x0a, 0x05, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x12, 0x16, 0x0a, 0x06,
	0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x06, 0x6f, 0x66,
	0x66, 0x73, 0x65, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x64, 0x6f, 0x6e, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x04, 0x64, 0x6f, 0x6e, 0x65, 0x12, 0x18, 0x0a, 0x04, 0x72, 0x6f, 0x77, 0x73,
	0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x04, 0x2e, 0x52, 0x6f, 0x77, 0x52, 0x04, 0x72, 0x6f,
	0x77, 0x73, 0x22, 0x29, 0x0a, 0x03, 0x52, 0x6f, 0x77, 0x12, 0x22, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x0c, 0x2e, 0x43, 0x6f, 0x6c, 0x75, 0x6d,
	0x6e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x44, 0x0a,
	0x10, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74,
	0x79, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x09, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x22, 0x4a, 0x0a, 0x0b, 0x57, 0x69, 0x72, 0x65, 0x4d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x27, 0x0a, 0x0f, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65,
	0x64, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52,
	0x0e, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x64, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x22,
	0xb6, 0x01, 0x0a, 0x0b, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12,
	0x21, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x0b,
	0x2e, 0x54, 0x79, 0x70, 0x65, 0x64, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x12, 0x2c, 0x0a, 0x0b, 0x61, 0x72, 0x72, 0x61, 0x79, 0x5f, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x0b, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x64, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x0a, 0x61, 0x72, 0x72, 0x61, 0x79, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x12, 0x26, 0x0a, 0x0f, 0x68, 0x61, 0x73, 0x5f, 0x61, 0x72, 0x72, 0x61, 0x79, 0x5f, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0d, 0x68, 0x61, 0x73, 0x41, 0x72,
	0x72, 0x61, 0x79, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x2e, 0x0a, 0x0c, 0x73, 0x63, 0x61, 0x6c,
	0x61, 0x72, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0b,
	0x2e, 0x54, 0x79, 0x70, 0x65, 0x64, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0b, 0x73, 0x63, 0x61,
	0x6c, 0x61, 0x72, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x22, 0xe7, 0x02, 0x0a, 0x0a, 0x54, 0x79, 0x70,
	0x65, 0x64, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x18, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x04, 0x2e, 0x52, 0x65, 0x70, 0x52, 0x04, 0x74, 0x79, 0x70,
	0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x62, 0x6f, 0x6f, 0x6c, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x62, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x12, 0x21, 0x0a, 0x0c, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x5f, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x12, 0x52, 0x0b, 0x6e, 0x75, 0x6d, 0x62, 0x65,
	0x72, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x62, 0x79, 0x74, 0x65, 0x73, 0x5f,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0a, 0x62, 0x79, 0x74,
	0x65, 0x73, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x6f, 0x75, 0x62, 0x6c,
	0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x01, 0x52, 0x0b, 0x64,
	0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x75,
	0x6c, 0x6c, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x52, 0x04, 0x6e, 0x75, 0x6c, 0x6c, 0x12, 0x2c,
	0x0a, 0x0b, 0x61, 0x72, 0x72, 0x61, 0x79, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x08, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x0b, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x64, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x0a, 0x61, 0x72, 0x72, 0x61, 0x79, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x2b, 0x0a, 0x0e,
	0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x09,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x04, 0x2e, 0x52, 0x65, 0x70, 0x52, 0x0d, 0x63, 0x6f, 0x6d, 0x70,
	0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x27, 0x0a, 0x0f, 0x69, 0x6d, 0x70,
	0x6c, 0x69, 0x63, 0x69, 0x74, 0x6c, 0x79, 0x5f, 0x6e, 0x75, 0x6c, 0x6c, 0x18, 0x0a, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x0e, 0x69, 0x6d, 0x70, 0x6c, 0x69, 0x63, 0x69, 0x74, 0x6c, 0x79, 0x4e, 0x75,
	0x6c, 0x6c, 0x22, 0xf1, 0x02, 0x0a, 0x19, 0x4d, 0x65, 0x74, 0x61, 0x44, 0x61, 0x74, 0x61, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x72, 0x67, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x12, 0x21, 0x0a, 0x0c, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x62, 0x6f, 0x6f, 0x6c, 0x5f, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x62, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x69, 0x6e, 0x74, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x11, 0x52, 0x08, 0x69, 0x6e, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12,
	0x2e, 0x0a, 0x13, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x61, 0x72, 0x72, 0x61, 0x79, 0x5f,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x11, 0x73, 0x74,
	0x72, 0x69, 0x6e, 0x67, 0x41, 0x72, 0x72, 0x61, 0x79, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12,
	0x28, 0x0a, 0x10, 0x69, 0x6e, 0x74, 0x5f, 0x61, 0x72, 0x72, 0x61, 0x79, 0x5f, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x11, 0x52, 0x0e, 0x69, 0x6e, 0x74, 0x41, 0x72,
	0x72, 0x61, 0x79, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x3b, 0x0a, 0x04, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x27, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x44, 0x61,
	0x74, 0x61, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x72, 0x67, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x2e, 0x41, 0x72, 0x67, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65,
	0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x22, 0x5e, 0x0a, 0x0c, 0x41, 0x72, 0x67, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x54, 0x52, 0x49, 0x4e, 0x47,
	0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x42, 0x4f, 0x4f, 0x4c, 0x10, 0x01, 0x12, 0x07, 0x0a, 0x03,
	0x49, 0x4e, 0x54, 0x10, 0x02, 0x12, 0x13, 0x0a, 0x0f, 0x52, 0x45, 0x50, 0x45, 0x41, 0x54, 0x45,
	0x44, 0x5f, 0x53, 0x54, 0x52, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x10, 0x0a, 0x0c, 0x52, 0x45,
	0x50, 0x45, 0x41, 0x54, 0x45, 0x44, 0x5f, 0x49, 0x4e, 0x54, 0x10, 0x04, 0x12, 0x08, 0x0a, 0x04,
	0x4e, 0x55, 0x4c, 0x4c, 0x10, 0x05, 0x22, 0xdd, 0x01, 0x0a, 0x0a, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x1e, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x0a, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52,
	0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x73, 0x71, 0x6c, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x73, 0x71, 0x6c, 0x12, 0x22, 0x0a, 0x02, 0x6f, 0x70, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x12, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x44, 0x61, 0x74, 0x61, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x02, 0x6f, 0x70, 0x12, 0x2e, 0x0a, 0x04, 0x61,
	0x72, 0x67, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x4d, 0x65, 0x74, 0x61,
	0x44, 0x61, 0x74, 0x61, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x72, 0x67,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x04, 0x61, 0x72, 0x67, 0x73, 0x12, 0x19, 0x0a, 0x08, 0x68,
	0x61, 0x73, 0x5f, 0x61, 0x72, 0x67, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x68,
	0x61, 0x73, 0x41, 0x72, 0x67, 0x73, 0x12, 0x17, 0x0a, 0x07, 0x68, 0x61, 0x73, 0x5f, 0x73, 0x71,
	0x6c, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x68, 0x61, 0x73, 0x53, 0x71, 0x6c, 0x12,
	0x15, 0x0a, 0x06, 0x68, 0x61, 0x73, 0x5f, 0x6f, 0x70, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x05, 0x68, 0x61, 0x73, 0x4f, 0x70, 0x2a, 0x9f, 0x01, 0x0a, 0x0d, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x45, 0x4c, 0x45,
	0x43, 0x54, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x49, 0x4e, 0x53, 0x45, 0x52, 0x54, 0x10, 0x01,
	0x12, 0x0a, 0x0a, 0x06, 0x55, 0x50, 0x44, 0x41, 0x54, 0x45, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06,
	0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x10, 0x03, 0x12, 0x0a, 0x0a, 0x06, 0x55, 0x50, 0x53, 0x45,
	0x52, 0x54, 0x10, 0x04, 0x12, 0x09, 0x0a, 0x05, 0x4d, 0x45, 0x52, 0x47, 0x45, 0x10, 0x05, 0x12,
	0x0d, 0x0a, 0x09, 0x4f, 0x54, 0x48, 0x45, 0x52, 0x5f, 0x44, 0x4d, 0x4c, 0x10, 0x06, 0x12, 0x0a,
	0x0a, 0x06, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x10, 0x07, 0x12, 0x08, 0x0a, 0x04, 0x44, 0x52,
	0x4f, 0x50, 0x10, 0x08, 0x12, 0x09, 0x0a, 0x05, 0x41, 0x4c, 0x54, 0x45, 0x52, 0x10, 0x09, 0x12,
	0x0d, 0x0a, 0x09, 0x4f, 0x54, 0x48, 0x45, 0x52, 0x5f, 0x44, 0x44, 0x4c, 0x10, 0x0a, 0x12, 0x08,
	0x0a, 0x04, 0x43, 0x41, 0x4c, 0x4c, 0x10, 0x0b, 0x2a, 0xe2, 0x03, 0x0a, 0x03, 0x52, 0x65, 0x70,
	0x12, 0x15, 0x0a, 0x11, 0x50, 0x52, 0x49, 0x4d, 0x49, 0x54, 0x49, 0x56, 0x45, 0x5f, 0x42, 0x4f,
	0x4f, 0x4c, 0x45, 0x41, 0x4e, 0x10, 0x00, 0x12, 0x12, 0x0a, 0x0e, 0x50, 0x52, 0x49, 0x4d, 0x49,
	0x54, 0x49, 0x56, 0x45, 0x5f, 0x42, 0x59, 0x54, 0x45, 0x10, 0x01, 0x12, 0x12, 0x0a, 0x0e, 0x50,
	0x52, 0x49, 0x4d, 0x49, 0x54, 0x49, 0x56, 0x45, 0x5f, 0x43, 0x48, 0x41, 0x52, 0x10, 0x02, 0x12,
	0x13, 0x0a, 0x0f, 0x50, 0x52, 0x49, 0x4d, 0x49, 0x54, 0x49, 0x56, 0x45, 0x5f, 0x53, 0x48, 0x4f,
	0x52, 0x54, 0x10, 0x03, 0x12, 0x11, 0x0a, 0x0d, 0x50, 0x52, 0x49, 0x4d, 0x49, 0x54, 0x49, 0x56,
	0x45, 0x5f, 0x49, 0x4e, 0x54, 0x10, 0x04, 0x12, 0x12, 0x0a, 0x0e, 0x50, 0x52, 0x49, 0x4d, 0x49,
	0x54, 0x49, 0x56, 0x45, 0x5f, 0x4c, 0x4f, 0x4e, 0x47, 0x10, 0x05, 0x12, 0x13, 0x0a, 0x0f, 0x50,
	0x52, 0x49, 0x4d, 0x49, 0x54, 0x49, 0x56, 0x45, 0x5f, 0x46, 0x4c, 0x4f, 0x41, 0x54, 0x10, 0x06,
	0x12, 0x14, 0x0a, 0x10, 0x50, 0x52, 0x49, 0x4d, 0x49, 0x54, 0x49, 0x56, 0x45, 0x5f, 0x44, 0x4f,
	0x55, 0x42, 0x4c, 0x45, 0x10, 0x07, 0x12, 0x0b, 0x0a, 0x07, 0x42, 0x4f, 0x4f, 0x4c, 0x45, 0x41,
	0x4e, 0x10, 0x08, 0x12, 0x08, 0x0a, 0x04, 0x42, 0x59, 0x54, 0x45, 0x10, 0x09, 0x12, 0x0d, 0x0a,
	0x09, 0x43, 0x48, 0x41, 0x52, 0x41, 0x43, 0x54, 0x45, 0x52, 0x10, 0x0a, 0x12, 0x09, 0x0a, 0x05,
	0x53, 0x48, 0x4f, 0x52, 0x54, 0x10, 0x0b, 0x12, 0x0b, 0x0a, 0x07, 0x49, 0x4e, 0x54, 0x45, 0x47,
	0x45, 0x52, 0x10, 0x0c, 0x12, 0x08, 0x0a, 0x04, 0x4c, 0x4f, 0x4e, 0x47, 0x10, 0x0d, 0x12, 0x09,
	0x0a, 0x05, 0x46, 0x4c, 0x4f, 0x41, 0x54, 0x10, 0x0e, 0x12, 0x0a, 0x0a, 0x06, 0x44, 0x4f, 0x55,
	0x42, 0x4c, 0x45, 0x10, 0x0f, 0x12, 0x0f, 0x0a, 0x0b, 0x42, 0x49, 0x47, 0x5f, 0x49, 0x4e, 0x54,
	0x45, 0x47, 0x45, 0x52, 0x10, 0x19, 0x12, 0x0f, 0x0a, 0x0b, 0x42, 0x49, 0x47, 0x5f, 0x44, 0x45,
	0x43, 0x49, 0x4d, 0x41, 0x4c, 0x10, 0x1a, 0x12, 0x11, 0x0a, 0x0d, 0x4a, 0x41, 0x56, 0x41, 0x5f,
	0x53, 0x51, 0x4c, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x10, 0x10, 0x12, 0x16, 0x0a, 0x12, 0x4a, 0x41,
	0x56, 0x41, 0x5f, 0x53, 0x51, 0x4c, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x53, 0x54, 0x41, 0x4d, 0x50,
	0x10, 0x11, 0x12, 0x11, 0x0a, 0x0d, 0x4a, 0x41, 0x56, 0x41, 0x5f, 0x53, 0x51, 0x4c, 0x5f, 0x44,
	0x41, 0x54, 0x45, 0x10, 0x12, 0x12, 0x12, 0x0a, 0x0e, 0x4a, 0x41, 0x56, 0x41, 0x5f, 0x55, 0x54,
	0x49, 0x4c, 0x5f, 0x44, 0x41, 0x54, 0x45, 0x10, 0x13, 0x12, 0x0f, 0x0a, 0x0b, 0x42, 0x59, 0x54,
	0x45, 0x5f, 0x53, 0x54, 0x52, 0x49, 0x4e, 0x47, 0x10, 0x14, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x54,
	0x52, 0x49, 0x4e, 0x47, 0x10, 0x15, 0x12, 0x0a, 0x0a, 0x06, 0x4e, 0x55, 0x4d, 0x42, 0x45, 0x52,
	0x10, 0x16, 0x12, 0x0a, 0x0a, 0x06, 0x4f, 0x42, 0x4a, 0x45, 0x43, 0x54, 0x10, 0x17, 0x12, 0x08,
	0x0a, 0x04, 0x4e, 0x55, 0x4c, 0x4c, 0x10, 0x18, 0x12, 0x09, 0x0a, 0x05, 0x41, 0x52, 0x52, 0x41,
	0x59, 0x10, 0x1b, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x54, 0x52, 0x55, 0x43, 0x54, 0x10, 0x1c, 0x12,
	0x0c, 0x0a, 0x08, 0x4d, 0x55, 0x4c, 0x54, 0x49, 0x53, 0x45, 0x54, 0x10, 0x1d, 0x2a, 0x5e, 0x0a,
	0x08, 0x53, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x12, 0x14, 0x0a, 0x10, 0x55, 0x4e, 0x4b,
	0x4e, 0x4f, 0x57, 0x4e, 0x5f, 0x53, 0x45, 0x56, 0x45, 0x52, 0x49, 0x54, 0x59, 0x10, 0x00, 0x12,
	0x12, 0x0a, 0x0e, 0x46, 0x41, 0x54, 0x41, 0x4c, 0x5f, 0x53, 0x45, 0x56, 0x45, 0x52, 0x49, 0x54,
	0x59, 0x10, 0x01, 0x12, 0x12, 0x0a, 0x0e, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x5f, 0x53, 0x45, 0x56,
	0x45, 0x52, 0x49, 0x54, 0x59, 0x10, 0x02, 0x12, 0x14, 0x0a, 0x10, 0x57, 0x41, 0x52, 0x4e, 0x49,
	0x4e, 0x47, 0x5f, 0x53, 0x45, 0x56, 0x45, 0x52, 0x49, 0x54, 0x59, 0x10, 0x03, 0x2a, 0xd7, 0x04,
	0x0a, 0x11, 0x4d, 0x65, 0x74, 0x61, 0x44, 0x61, 0x74, 0x61, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x0e, 0x47, 0x45, 0x54, 0x5f, 0x41, 0x54, 0x54, 0x52, 0x49,
	0x42, 0x55, 0x54, 0x45, 0x53, 0x10, 0x00, 0x12, 0x1b, 0x0a, 0x17, 0x47, 0x45, 0x54, 0x5f, 0x42,
	0x45, 0x53, 0x54, 0x5f, 0x52, 0x4f, 0x57, 0x5f, 0x49, 0x44, 0x45, 0x4e, 0x54, 0x49, 0x46, 0x49,
	0x45, 0x52, 0x10, 0x01, 0x12, 0x10, 0x0a, 0x0c, 0x47, 0x45, 0x54, 0x5f, 0x43, 0x41, 0x54, 0x41,
	0x4c, 0x4f, 0x47, 0x53, 0x10, 0x02, 0x12, 0x1e, 0x0a, 0x1a, 0x47, 0x45, 0x54, 0x5f, 0x43, 0x4c,
	0x49, 0x45, 0x4e, 0x54, 0x5f, 0x49, 0x4e, 0x46, 0x4f, 0x5f, 0x50, 0x52, 0x4f, 0x50, 0x45, 0x52,
	0x54, 0x49, 0x45, 0x53, 0x10, 0x03, 0x12, 0x19, 0x0a, 0x15, 0x47, 0x45, 0x54, 0x5f, 0x43, 0x4f,
	0x4c, 0x55, 0x4d, 0x4e, 0x5f, 0x50, 0x52, 0x49, 0x56, 0x49, 0x4c, 0x45, 0x47, 0x45, 0x53, 0x10,
	0x04, 0x12, 0x0f, 0x0a, 0x0b, 0x47, 0x45, 0x54, 0x5f, 0x43, 0x4f, 0x4c, 0x55, 0x4d, 0x4e, 0x53,
	0x10, 0x05, 0x12, 0x17, 0x0a, 0x13, 0x47, 0x45, 0x54, 0x5f, 0x43, 0x52, 0x4f, 0x53, 0x53, 0x5f,
	0x52, 0x45, 0x46, 0x45, 0x52, 0x45, 0x4e, 0x43, 0x45, 0x10, 0x06, 0x12, 0x15, 0x0a, 0x11, 0x47,
	0x45, 0x54, 0x5f, 0x45, 0x58, 0x50, 0x4f, 0x52, 0x54, 0x45, 0x44, 0x5f, 0x4b, 0x45, 0x59, 0x53,
	0x10, 0x07, 0x12, 0x18, 0x0a, 0x14, 0x47, 0x45, 0x54, 0x5f, 0x46, 0x55, 0x4e, 0x43, 0x54, 0x49,
	0x4f, 0x4e, 0x5f, 0x43, 0x4f, 0x4c, 0x55, 0x4d, 0x4e, 0x53, 0x10, 0x08, 0x12, 0x11, 0x0a, 0x0d,
	0x47, 0x45, 0x54, 0x5f, 0x46, 0x55, 0x4e, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x53, 0x10, 0x09, 0x12,
	0x15, 0x0a, 0x11, 0x47, 0x45, 0x54, 0x5f, 0x49, 0x4d, 0x50, 0x4f, 0x52, 0x54, 0x45, 0x44, 0x5f,
	0x4b, 0x45, 0x59, 0x53, 0x10, 0x0a, 0x12, 0x12, 0x0a, 0x0e, 0x47, 0x45, 0x54, 0x5f, 0x49, 0x4e,
	0x44, 0x45, 0x58, 0x5f, 0x49, 0x4e, 0x46, 0x4f, 0x10, 0x0b, 0x12, 0x14, 0x0a, 0x10, 0x47, 0x45,
	0x54, 0x5f, 0x50, 0x52, 0x49, 0x4d, 0x41, 0x52, 0x59, 0x5f, 0x4b, 0x45, 0x59, 0x53, 0x10, 0x0c,
	0x12, 0x19, 0x0a, 0x15, 0x47, 0x45, 0x54, 0x5f, 0x50, 0x52, 0x4f, 0x43, 0x45, 0x44, 0x55, 0x52,
	0x45, 0x5f, 0x43, 0x4f, 0x4c, 0x55, 0x4d, 0x4e, 0x53, 0x10, 0x0d, 0x12, 0x12, 0x0a, 0x0e, 0x47,
	0x45, 0x54, 0x5f, 0x50, 0x52, 0x4f, 0x43, 0x45, 0x44, 0x55, 0x52, 0x45, 0x53, 0x10, 0x0e, 0x12,
	0x16, 0x0a, 0x12, 0x47, 0x45, 0x54, 0x5f, 0x50, 0x53, 0x45, 0x55, 0x44, 0x4f, 0x5f, 0x43, 0x4f,
	0x4c, 0x55, 0x4d, 0x4e, 0x53, 0x10, 0x0f, 0x12, 0x0f, 0x0a, 0x0b, 0x47, 0x45, 0x54, 0x5f, 0x53,
	0x43, 0x48, 0x45, 0x4d, 0x41, 0x53, 0x10, 0x10, 0x12, 0x19, 0x0a, 0x15, 0x47, 0x45, 0x54, 0x5f,
	0x53, 0x43, 0x48, 0x45, 0x4d, 0x41, 0x53, 0x5f, 0x57, 0x49, 0x54, 0x48, 0x5f, 0x41, 0x52, 0x47,
	0x53, 0x10, 0x11, 0x12, 0x14, 0x0a, 0x10, 0x47, 0x45, 0x54, 0x5f, 0x53, 0x55, 0x50, 0x45, 0x52,
	0x5f, 0x54, 0x41, 0x42, 0x4c, 0x45, 0x53, 0x10, 0x12, 0x12, 0x13, 0x0a, 0x0f, 0x47, 0x45, 0x54,
	0x5f, 0x53, 0x55, 0x50, 0x45, 0x52, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x53, 0x10, 0x13, 0x12, 0x18,
	0x0a, 0x14, 0x47, 0x45, 0x54, 0x5f, 0x54, 0x41, 0x42, 0x4c, 0x45, 0x5f, 0x50, 0x52, 0x49, 0x56,
	0x49, 0x4c, 0x45, 0x47, 0x45, 0x53, 0x10, 0x14, 0x12, 0x0e, 0x0a, 0x0a, 0x47, 0x45, 0x54, 0x5f,
	0x54, 0x41, 0x42, 0x4c, 0x45, 0x53, 0x10, 0x15, 0x12, 0x13, 0x0a, 0x0f, 0x47, 0x45, 0x54, 0x5f,
	0x54, 0x41, 0x42, 0x4c, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x53, 0x10, 0x16, 0x12, 0x11, 0x0a,
	0x0d, 0x47, 0x45, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x49, 0x4e, 0x46, 0x4f, 0x10, 0x17,
	0x12, 0x0c, 0x0a, 0x08, 0x47, 0x45, 0x54, 0x5f, 0x55, 0x44, 0x54, 0x53, 0x10, 0x18, 0x12, 0x17,
	0x0a, 0x13, 0x47, 0x45, 0x54, 0x5f, 0x56, 0x45, 0x52, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x43, 0x4f,
	0x4c, 0x55, 0x4d, 0x4e, 0x53, 0x10, 0x19, 0x2a, 0x22, 0x0a, 0x09, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x07, 0x0a, 0x03, 0x53, 0x51, 0x4c, 0x10, 0x00, 0x12, 0x0c, 0x0a,
	0x08, 0x4d, 0x45, 0x54, 0x41, 0x44, 0x41, 0x54, 0x41, 0x10, 0x01, 0x42, 0x22, 0x0a, 0x20, 0x6f,
	0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x63, 0x61, 0x6c, 0x63, 0x69, 0x74,
	0x65, 0x2e, 0x61, 0x76, 0x61, 0x74, 0x69, 0x63, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
})

var file_common_proto_enumTypes = make([]protoimpl.EnumInfo, 7)
var file_common_proto_msgTypes = make([]protoimpl.MessageInfo, 15)
var file_common_proto_goTypes = []any{
	(StatementType)(0),       // 0: StatementType
	(Rep)(0),                 // 1: Rep
	(Severity)(0),            // 2: Severity
	(MetaDataOperation)(0),   // 3: MetaDataOperation
	(StateType)(0),           // 4: StateType
	(CursorFactory_Style)(0), // 5: CursorFactory.Style
	(MetaDataOperationArgument_ArgumentType)(0), // 6: MetaDataOperationArgument.ArgumentType
	(*ConnectionProperties)(nil),                // 7: ConnectionProperties
	(*StatementHandle)(nil),                     // 8: StatementHandle
	(*Signature)(nil),                           // 9: Signature
	(*ColumnMetaData)(nil),                      // 10: ColumnMetaData
	(*AvaticaType)(nil),                         // 11: AvaticaType
	(*AvaticaParameter)(nil),                    // 12: AvaticaParameter
	(*CursorFactory)(nil),                       // 13: CursorFactory
	(*Frame)(nil),                               // 14: Frame
	(*Row)(nil),                                 // 15: Row
	(*DatabaseProperty)(nil),                    // 16: DatabaseProperty
	(*WireMessage)(nil),                         // 17: WireMessage
	(*ColumnValue)(nil),                         // 18: ColumnValue
	(*TypedValue)(nil),                          // 19: TypedValue
	(*MetaDataOperationArgument)(nil),           // 20: MetaDataOperationArgument
	(*QueryState)(nil),                          // 21: QueryState
}
var file_common_proto_depIdxs = []int32{
	9,  // 0: StatementHandle.signature:type_name -> Signature
	10, // 1: Signature.columns:type_name -> ColumnMetaData
	12, // 2: Signature.parameters:type_name -> AvaticaParameter
	13, // 3: Signature.cursor_factory:type_name -> CursorFactory
	0,  // 4: Signature.statementType:type_name -> StatementType
	11, // 5: ColumnMetaData.type:type_name -> AvaticaType
	1,  // 6: AvaticaType.rep:type_name -> Rep
	10, // 7: AvaticaType.columns:type_name -> ColumnMetaData
	11, // 8: AvaticaType.component:type_name -> AvaticaType
	5,  // 9: CursorFactory.style:type_name -> CursorFactory.Style
	15, // 10: Frame.rows:type_name -> Row
	18, // 11: Row.value:type_name -> ColumnValue
	19, // 12: ColumnValue.value:type_name -> TypedValue
	19, // 13: ColumnValue.array_value:type_name -> TypedValue
	19, // 14: ColumnValue.scalar_value:type_name -> TypedValue
	1,  // 15: TypedValue.type:type_name -> Rep
	19, // 16: TypedValue.array_value:type_name -> TypedValue
	1,  // 17: TypedValue.component_type:type_name -> Rep
	6,  // 18: MetaDataOperationArgument.type:type_name -> MetaDataOperationArgument.ArgumentType
	4,  // 19: QueryState.type:type_name -> StateType
	3,  // 20: QueryState.op:type_name -> MetaDataOperation
	20, // 21: QueryState.args:type_name -> MetaDataOperationArgument
	22, // [22:22] is the sub-list for method output_type
	22, // [22:22] is the sub-list for method input_type
	22, // [22:22] is the sub-list for extension type_name
	22, // [22:22] is the sub-list for extension extendee
	0,  // [0:22] is the sub-list for field type_name
}

func init() { file_common_proto_init() }
func file_common_proto_init() {
	if File_common_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_common_proto_rawDesc), len(file_common_proto_rawDesc)),
			NumEnums:      7,
			NumMessages:   15,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_common_proto_goTypes,
		DependencyIndexes: file_common_proto_depIdxs,
		EnumInfos:         file_common_proto_enumTypes,
		MessageInfos:      file_common_proto_msgTypes,
	}.Build()
	File_common_proto = out.File
	file_common_proto_goTypes = nil
	file_common_proto_depIdxs = nil
}
