/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool;

import com.google.common.collect.Iterables;
import io.airlift.command.Command;
import java.io.PrintStream;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.management.openmbean.TabularData;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.tools.NodeTool;
import org.apache.cassandra.tools.nodetool.formatter.TableBuilder;

@Command(name="compactionhistory", description="Print history of compaction")
public class CompactionHistory
extends NodeTool.NodeToolCmd {
    @Override
    public void execute(NodeProbe probe) {
        PrintStream out = probe.output().out;
        out.println("Compaction History: ");
        TabularData tabularData = probe.getCompactionHistory();
        if (tabularData.isEmpty()) {
            out.printf("There is no compaction history", new Object[0]);
            return;
        }
        TableBuilder table = new TableBuilder();
        List<String> indexNames = tabularData.getTabularType().getIndexNames();
        table.add((String[])Iterables.toArray(indexNames, String.class));
        Set<?> values = tabularData.keySet();
        ArrayList<CompactionHistoryRow> chr = new ArrayList<CompactionHistoryRow>();
        for (Object eachValue : values) {
            List value = (List)eachValue;
            CompactionHistoryRow chc = new CompactionHistoryRow((String)value.get(0), (String)value.get(1), (String)value.get(2), (Long)value.get(3), (Long)value.get(4), (Long)value.get(5), (String)value.get(6));
            chr.add(chc);
        }
        Collections.sort(chr);
        for (CompactionHistoryRow eachChc : chr) {
            table.add(eachChc.getAllAsArray());
        }
        table.printTo(out);
    }

    private static class CompactionHistoryRow
    implements Comparable<CompactionHistoryRow> {
        private final String id;
        private final String ksName;
        private final String cfName;
        private final long compactedAt;
        private final long bytesIn;
        private final long bytesOut;
        private final String rowMerged;

        CompactionHistoryRow(String id, String ksName, String cfName, long compactedAt, long bytesIn, long bytesOut, String rowMerged) {
            this.id = id;
            this.ksName = ksName;
            this.cfName = cfName;
            this.compactedAt = compactedAt;
            this.bytesIn = bytesIn;
            this.bytesOut = bytesOut;
            this.rowMerged = rowMerged;
        }

        @Override
        public int compareTo(CompactionHistoryRow chc) {
            return Long.signum(chc.compactedAt - this.compactedAt);
        }

        public String[] getAllAsArray() {
            String[] obj = new String[7];
            obj[0] = this.id;
            obj[1] = this.ksName;
            obj[2] = this.cfName;
            Instant instant = Instant.ofEpochMilli(this.compactedAt);
            LocalDateTime ldt = LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
            obj[3] = ldt.toString();
            obj[4] = Long.toString(this.bytesIn);
            obj[5] = Long.toString(this.bytesOut);
            obj[6] = this.rowMerged;
            return obj;
        }
    }
}

