/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.vint;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;

public class VIntCoding {
    protected static final ThreadLocal<byte[]> encodingBuffer = new ThreadLocal<byte[]>(){

        @Override
        public byte[] initialValue() {
            return new byte[9];
        }
    };

    public static long readUnsignedVInt(DataInput input) throws IOException {
        byte firstByte = input.readByte();
        if (firstByte >= 0) {
            return firstByte;
        }
        int size = VIntCoding.numberOfExtraBytesToRead(firstByte);
        long retval = firstByte & VIntCoding.firstByteValueMask(size);
        for (int ii = 0; ii < size; ++ii) {
            byte b = input.readByte();
            retval <<= 8;
            retval |= (long)(b & 0xFF);
        }
        return retval;
    }

    public static long getUnsignedVInt(ByteBuffer input, int readerIndex) {
        return VIntCoding.getUnsignedVInt(input, readerIndex, input.limit());
    }

    public static long getUnsignedVInt(ByteBuffer input, int readerIndex, int readerLimit) {
        byte firstByte;
        if (readerIndex >= readerLimit) {
            return -1L;
        }
        if ((firstByte = input.get(readerIndex++)) >= 0) {
            return firstByte;
        }
        int size = VIntCoding.numberOfExtraBytesToRead(firstByte);
        if (readerIndex + size > readerLimit) {
            return -1L;
        }
        long retval = firstByte & VIntCoding.firstByteValueMask(size);
        for (int ii = 0; ii < size; ++ii) {
            byte b = input.get(readerIndex++);
            retval <<= 8;
            retval |= (long)(b & 0xFF);
        }
        return retval;
    }

    public static long readVInt(DataInput input) throws IOException {
        return VIntCoding.decodeZigZag64(VIntCoding.readUnsignedVInt(input));
    }

    public static int firstByteValueMask(int extraBytesToRead) {
        return 255 >> extraBytesToRead;
    }

    public static int encodeExtraBytesToRead(int extraBytesToRead) {
        return ~VIntCoding.firstByteValueMask(extraBytesToRead);
    }

    public static int numberOfExtraBytesToRead(int firstByte) {
        return Integer.numberOfLeadingZeros(~firstByte) - 24;
    }

    public static void writeUnsignedVInt(long value, DataOutput output) throws IOException {
        int size = VIntCoding.computeUnsignedVIntSize(value);
        if (size == 1) {
            output.write((int)value);
            return;
        }
        output.write(VIntCoding.encodeVInt(value, size), 0, size);
    }

    public static byte[] encodeVInt(long value, int size) {
        int extraBytes;
        byte[] encodingSpace = encodingBuffer.get();
        for (int i = extraBytes = size - 1; i >= 0; --i) {
            encodingSpace[i] = (byte)value;
            value >>= 8;
        }
        encodingSpace[0] = (byte)(encodingSpace[0] | VIntCoding.encodeExtraBytesToRead(extraBytes));
        return encodingSpace;
    }

    public static void writeVInt(long value, DataOutput output) throws IOException {
        VIntCoding.writeUnsignedVInt(VIntCoding.encodeZigZag64(value), output);
    }

    public static long decodeZigZag64(long n) {
        return n >>> 1 ^ -(n & 1L);
    }

    public static long encodeZigZag64(long n) {
        return n << 1 ^ n >> 63;
    }

    public static int computeVIntSize(long param) {
        return VIntCoding.computeUnsignedVIntSize(VIntCoding.encodeZigZag64(param));
    }

    public static int computeUnsignedVIntSize(long value) {
        int magnitude = Long.numberOfLeadingZeros(value | 1L);
        return 9 - (magnitude - 1) / 7;
    }
}

