/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.settings;

import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.stress.settings.GroupedOptions;
import org.apache.cassandra.stress.settings.Option;
import org.apache.cassandra.stress.settings.OptionDistribution;
import org.apache.cassandra.stress.settings.OptionSimple;

public class SettingsTokenRange {
    public final boolean wrap;
    public final int splitFactor;

    public SettingsTokenRange(TokenRangeOptions options) {
        this.wrap = options.wrap.setByUser();
        this.splitFactor = Ints.checkedCast((long)OptionDistribution.parseLong(options.splitFactor.value()));
    }

    public static SettingsTokenRange get(Map<String, String[]> clArgs) {
        String[] params = clArgs.remove("-tokenrange");
        if (params == null) {
            return new SettingsTokenRange(new TokenRangeOptions());
        }
        TokenRangeOptions options = (TokenRangeOptions)GroupedOptions.select((String[])params, (GroupedOptions[])new TokenRangeOptions[]{new TokenRangeOptions()});
        if (options == null) {
            SettingsTokenRange.printHelp();
            System.out.println("Invalid -tokenrange options provided, see output for valid options");
            System.exit(1);
        }
        return new SettingsTokenRange(options);
    }

    public static void printHelp() {
        GroupedOptions.printOptions(System.out, "-tokenrange", new TokenRangeOptions());
    }

    public static Runnable helpPrinter() {
        return SettingsTokenRange::printHelp;
    }

    private static final class TokenRangeOptions
    extends GroupedOptions {
        final OptionSimple wrap = new OptionSimple("wrap", "", null, "Re-use token ranges in order to terminate stress iterations", false);
        final OptionSimple splitFactor = new OptionSimple("split-factor=", "[0-9]+[bmk]?", "1", "Split every token range by this factor", false);

        private TokenRangeOptions() {
        }

        @Override
        public List<? extends Option> options() {
            return ImmutableList.builder().add((Object[])new Option[]{this.wrap, this.splitFactor}).build();
        }
    }
}

