/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.hints;

import org.apache.cassandra.diag.DiagnosticEventService;
import org.apache.cassandra.hints.HintEvent;
import org.apache.cassandra.hints.HintsDispatcher;

final class HintDiagnostics {
    private static final DiagnosticEventService service = DiagnosticEventService.instance();

    private HintDiagnostics() {
    }

    static void dispatcherCreated(HintsDispatcher dispatcher) {
        if (HintDiagnostics.isEnabled(HintEvent.HintEventType.DISPATCHER_CREATED)) {
            service.publish(new HintEvent(HintEvent.HintEventType.DISPATCHER_CREATED, dispatcher, dispatcher.hostId, dispatcher.address, null, null, null, null));
        }
    }

    static void dispatcherClosed(HintsDispatcher dispatcher) {
        if (HintDiagnostics.isEnabled(HintEvent.HintEventType.DISPATCHER_CLOSED)) {
            service.publish(new HintEvent(HintEvent.HintEventType.DISPATCHER_CLOSED, dispatcher, dispatcher.hostId, dispatcher.address, null, null, null, null));
        }
    }

    static void dispatchPage(HintsDispatcher dispatcher) {
        if (HintDiagnostics.isEnabled(HintEvent.HintEventType.DISPATCHER_PAGE)) {
            service.publish(new HintEvent(HintEvent.HintEventType.DISPATCHER_PAGE, dispatcher, dispatcher.hostId, dispatcher.address, null, null, null, null));
        }
    }

    static void abortRequested(HintsDispatcher dispatcher) {
        if (HintDiagnostics.isEnabled(HintEvent.HintEventType.ABORT_REQUESTED)) {
            service.publish(new HintEvent(HintEvent.HintEventType.ABORT_REQUESTED, dispatcher, dispatcher.hostId, dispatcher.address, null, null, null, null));
        }
    }

    static void pageSuccessResult(HintsDispatcher dispatcher, long success, long failures, long timeouts) {
        if (HintDiagnostics.isEnabled(HintEvent.HintEventType.DISPATCHER_HINT_RESULT)) {
            service.publish(new HintEvent(HintEvent.HintEventType.DISPATCHER_HINT_RESULT, dispatcher, dispatcher.hostId, dispatcher.address, HintEvent.HintResult.PAGE_SUCCESS, success, failures, timeouts));
        }
    }

    static void pageFailureResult(HintsDispatcher dispatcher, long success, long failures, long timeouts) {
        if (HintDiagnostics.isEnabled(HintEvent.HintEventType.DISPATCHER_HINT_RESULT)) {
            service.publish(new HintEvent(HintEvent.HintEventType.DISPATCHER_HINT_RESULT, dispatcher, dispatcher.hostId, dispatcher.address, HintEvent.HintResult.PAGE_FAILURE, success, failures, timeouts));
        }
    }

    private static boolean isEnabled(HintEvent.HintEventType type) {
        return service.isEnabled(HintEvent.class, type);
    }
}

