/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.corretto.crypto.provider;

import com.amazon.corretto.crypto.provider.AmazonCorrettoCryptoProvider;
import com.amazon.corretto.crypto.provider.EvpKeyType;
import com.amazon.corretto.crypto.provider.EvpSignatureBase;
import com.amazon.corretto.crypto.provider.InputBuffer;
import com.amazon.corretto.crypto.provider.Loader;
import com.amazon.corretto.crypto.provider.Utils;
import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.PSSParameterSpec;

class EvpSignature
extends EvpSignatureBase {
    private byte[] oneByteArray_ = null;
    private InputBuffer<byte[], EvpSignatureBase.EvpContext, SignatureException> signingBuffer;
    private InputBuffer<Boolean, EvpSignatureBase.EvpContext, SignatureException> verifyingBuffer;

    private static native byte[] sign(long var0, long var2, int var4, long var5, int var7, byte[] var8, int var9, int var10) throws SignatureException;

    private static native boolean verify(long var0, long var2, int var4, long var5, int var7, byte[] var8, int var9, int var10, byte[] var11, int var12, int var13) throws SignatureException;

    private static native long signStart(long var0, long var2, int var4, long var5, int var7, byte[] var8, int var9, int var10);

    private static native long signStartBuffer(long var0, long var2, int var4, long var5, int var7, ByteBuffer var8);

    private static native long verifyStart(long var0, long var2, int var4, long var5, int var7, byte[] var8, int var9, int var10);

    private static native long verifyStartBuffer(long var0, long var2, int var4, long var5, int var7, ByteBuffer var8);

    private static native void signUpdate(long var0, byte[] var2, int var3, int var4);

    private static native void signUpdateBuffer(long var0, ByteBuffer var2);

    private static native void verifyUpdate(long var0, byte[] var2, int var3, int var4);

    private static native void verifyUpdateBuffer(long var0, ByteBuffer var2);

    private static native byte[] signFinish(long var0) throws SignatureException;

    private static native boolean verifyFinish(long var0, byte[] var2, int var3, int var4) throws SignatureException;

    private EvpSignature(AmazonCorrettoCryptoProvider amazonCorrettoCryptoProvider, EvpKeyType evpKeyType, int n, String string) {
        super(amazonCorrettoCryptoProvider, evpKeyType, n, Utils.getMdPtr(string));
        Loader.checkNativeLibraryAvailability();
        this.signingBuffer = this.getSigningBuffer();
        this.verifyingBuffer = this.getVerifyingBuffer();
    }

    private InputBuffer<byte[], EvpSignatureBase.EvpContext, SignatureException> getSigningBuffer() {
        return new InputBuffer(1024).withInitialUpdater((byArray, n, n2) -> new EvpSignatureBase.EvpContext(this.key_.use(l -> EvpSignature.signStart(l, this.digest_, this.paddingType_, this.pssMgfMd_, this.pssSaltLen_, byArray, n, n2)))).withInitialUpdater(byteBuffer -> new EvpSignatureBase.EvpContext(this.key_.use(l -> EvpSignature.signStartBuffer(l, this.digest_, this.paddingType_, this.pssMgfMd_, this.pssSaltLen_, byteBuffer)))).withUpdater((evpContext, byArray, n, n2) -> evpContext.useVoid(l -> EvpSignature.signUpdate(l, byArray, n, n2))).withUpdater((evpContext, byteBuffer) -> evpContext.useVoid(l -> EvpSignature.signUpdateBuffer(l, byteBuffer))).withDoFinal(evpContext -> EvpSignature.signFinish(evpContext.take())).withSinglePass((byArray, n, n2) -> this.key_.use(l -> EvpSignature.sign(l, this.digest_, this.paddingType_, this.pssMgfMd_, this.pssSaltLen_, byArray, n, n2)));
    }

    private InputBuffer<Boolean, EvpSignatureBase.EvpContext, SignatureException> getVerifyingBuffer() {
        return new InputBuffer(1024).withInitialUpdater((byArray, n, n2) -> new EvpSignatureBase.EvpContext(this.key_.use(l -> EvpSignature.verifyStart(l, this.digest_, this.paddingType_, this.pssMgfMd_, this.pssSaltLen_, byArray, n, n2)))).withInitialUpdater(byteBuffer -> new EvpSignatureBase.EvpContext(this.key_.use(l -> EvpSignature.verifyStartBuffer(l, this.digest_, this.paddingType_, this.pssMgfMd_, this.pssSaltLen_, byteBuffer)))).withUpdater((evpContext, byArray, n, n2) -> evpContext.useVoid(l -> EvpSignature.verifyUpdate(l, byArray, n, n2))).withUpdater((evpContext, byteBuffer) -> evpContext.useVoid(l -> EvpSignature.verifyUpdateBuffer(l, byteBuffer)));
    }

    @Override
    protected synchronized void engineReset() {
        this.signingBuffer.reset();
        this.verifyingBuffer.reset();
    }

    @Override
    protected synchronized void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        super.engineSetParameter(algorithmParameterSpec);
        if (algorithmParameterSpec instanceof PSSParameterSpec) {
            this.signingBuffer = this.getSigningBuffer();
            this.verifyingBuffer = this.getVerifyingBuffer();
        }
    }

    @Override
    protected boolean isBufferEmpty() {
        return this.signingBuffer.size() == 0 && this.verifyingBuffer.size() == 0;
    }

    @Override
    protected synchronized byte[] engineSign() throws SignatureException {
        this.ensureInitialized(true);
        try {
            byte[] byArray = this.maybeConvertSignatureToReturn(this.signingBuffer.doFinal());
            return byArray;
        }
        finally {
            this.engineReset();
        }
    }

    @Override
    protected synchronized void engineUpdate(byte by) throws SignatureException {
        this.ensureInitialized(null);
        if (this.signMode) {
            this.signingBuffer.update(by);
        } else {
            this.verifyingBuffer.update(by);
        }
    }

    @Override
    protected synchronized void engineUpdate(byte[] byArray, int n, int n2) throws SignatureException {
        this.ensureInitialized(null);
        if (this.signMode) {
            this.signingBuffer.update(byArray, n, n2);
        } else {
            this.verifyingBuffer.update(byArray, n, n2);
        }
    }

    @Override
    protected synchronized void engineUpdate(ByteBuffer byteBuffer) {
        if (this.signMode) {
            this.signingBuffer.update(byteBuffer);
        } else {
            this.verifyingBuffer.update(byteBuffer);
        }
    }

    @Override
    protected synchronized boolean engineVerify(byte[] byArray) throws SignatureException {
        return this.engineVerify(byArray, 0, byArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized boolean engineVerify(byte[] byArray, int n, int n2) throws SignatureException {
        int n5;
        int n6;
        byte[] byArray3;
        this.ensureInitialized(false);
        byte[] byArray4 = this.maybeConvertSignatureToVerify(byArray, n, n2);
        if (byArray4 != null) {
            byArray3 = byArray4;
            n6 = 0;
            n5 = byArray3.length;
        } else {
            byArray3 = byArray;
            n6 = n;
            n5 = n2;
        }
        try {
            boolean bl = this.verifyingBuffer.withDoFinal(evpContext -> EvpSignature.verifyFinish(evpContext.take(), byArray3, n6, n5)).withSinglePass((byArray2, n3, n4) -> this.key_.use(l -> EvpSignature.verify(l, this.digest_, this.paddingType_, this.pssMgfMd_, this.pssSaltLen_, byArray2, n3, n4, byArray3, n6, n5))).doFinal();
            return bl;
        }
        finally {
            this.verifyingBuffer.withDoFinal(null).withSinglePass(null);
            this.engineReset();
        }
    }

    static final class SHA512withECDSA
    extends EvpSignature {
        SHA512withECDSA(AmazonCorrettoCryptoProvider amazonCorrettoCryptoProvider) {
            super(amazonCorrettoCryptoProvider, EvpKeyType.EC, 0, "sha512");
        }
    }

    static final class SHA384withECDSA
    extends EvpSignature {
        SHA384withECDSA(AmazonCorrettoCryptoProvider amazonCorrettoCryptoProvider) {
            super(amazonCorrettoCryptoProvider, EvpKeyType.EC, 0, "sha384");
        }
    }

    static final class SHA256withECDSA
    extends EvpSignature {
        SHA256withECDSA(AmazonCorrettoCryptoProvider amazonCorrettoCryptoProvider) {
            super(amazonCorrettoCryptoProvider, EvpKeyType.EC, 0, "sha256");
        }
    }

    static final class SHA224withECDSA
    extends EvpSignature {
        SHA224withECDSA(AmazonCorrettoCryptoProvider amazonCorrettoCryptoProvider) {
            super(amazonCorrettoCryptoProvider, EvpKeyType.EC, 0, "sha224");
        }
    }

    static final class SHA1withECDSA
    extends EvpSignature {
        SHA1withECDSA(AmazonCorrettoCryptoProvider amazonCorrettoCryptoProvider) {
            super(amazonCorrettoCryptoProvider, EvpKeyType.EC, 0, "sha1");
        }
    }

    static final class RSASSA_PSS
    extends EvpSignature {
        RSASSA_PSS(AmazonCorrettoCryptoProvider amazonCorrettoCryptoProvider) {
            super(amazonCorrettoCryptoProvider, EvpKeyType.RSA, 6, null);
        }
    }

    static final class SHA512withRSA
    extends EvpSignature {
        SHA512withRSA(AmazonCorrettoCryptoProvider amazonCorrettoCryptoProvider) {
            super(amazonCorrettoCryptoProvider, EvpKeyType.RSA, 1, "sha512");
        }
    }

    static final class SHA384withRSA
    extends EvpSignature {
        SHA384withRSA(AmazonCorrettoCryptoProvider amazonCorrettoCryptoProvider) {
            super(amazonCorrettoCryptoProvider, EvpKeyType.RSA, 1, "sha384");
        }
    }

    static final class SHA256withRSA
    extends EvpSignature {
        SHA256withRSA(AmazonCorrettoCryptoProvider amazonCorrettoCryptoProvider) {
            super(amazonCorrettoCryptoProvider, EvpKeyType.RSA, 1, "sha256");
        }
    }

    static final class SHA224withRSA
    extends EvpSignature {
        SHA224withRSA(AmazonCorrettoCryptoProvider amazonCorrettoCryptoProvider) {
            super(amazonCorrettoCryptoProvider, EvpKeyType.RSA, 1, "sha224");
        }
    }

    static final class SHA1withRSA
    extends EvpSignature {
        SHA1withRSA(AmazonCorrettoCryptoProvider amazonCorrettoCryptoProvider) {
            super(amazonCorrettoCryptoProvider, EvpKeyType.RSA, 1, "sha1");
        }
    }
}

