/*
 * Decompiled with CFR 0.152.
 */
package org.github.jamm.strategies;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.github.jamm.strategies.ContendedUtils;
import org.github.jamm.strategies.ContentionGroupsCounter;
import org.github.jamm.strategies.MemoryLayoutBasedStrategy;
import org.github.jamm.utils.MathUtils;

class PreJava15SpecStrategy
extends MemoryLayoutBasedStrategy {
    PreJava15SpecStrategy() {
    }

    protected long alignFieldBlock(long sizeOfDeclaredFields) {
        return MathUtils.roundTo(sizeOfDeclaredFields, MEMORY_LAYOUT.getReferenceSize());
    }

    @Override
    public final long measureInstance(Object instance, Class<?> type) {
        long size = this.sizeOfFields(type, false);
        return MathUtils.roundTo(size, MEMORY_LAYOUT.getObjectAlignment());
    }

    private long sizeOfFields(Class<?> type, boolean useFieldBlockAlignment) {
        boolean isContendedEnabled = ContendedUtils.isContendedEnabled(type);
        if (type == Object.class) {
            return MEMORY_LAYOUT.getObjectHeaderSize();
        }
        long size = this.sizeOfFields(type.getSuperclass(), true);
        long sizeOfDeclaredField = 0L;
        long sizeTakenBy8BytesFields = 0L;
        ContentionGroupsCounter contentionGroupCounter = null;
        for (Field f : type.getDeclaredFields()) {
            if (Modifier.isStatic(f.getModifiers())) continue;
            int fieldSize = this.measureField(f.getType());
            sizeTakenBy8BytesFields += (long)(fieldSize & 8);
            sizeOfDeclaredField += (long)fieldSize;
            if (!isContendedEnabled) continue;
            contentionGroupCounter = ContendedUtils.countContentionGroup(contentionGroupCounter, f);
        }
        if (this.hasSuperClassGap(size, sizeOfDeclaredField, sizeTakenBy8BytesFields)) {
            size = MathUtils.roundTo(size, 8);
        }
        size += useFieldBlockAlignment ? this.alignFieldBlock(sizeOfDeclaredField) : sizeOfDeclaredField;
        if (isContendedEnabled && ContendedUtils.isClassAnnotatedWithContended(type)) {
            size += (long)(MEMORY_LAYOUT.getContendedPaddingWidth() << 1);
        }
        if (contentionGroupCounter != null) {
            size += (long)((contentionGroupCounter.count() + 1) * MEMORY_LAYOUT.getContendedPaddingWidth());
        }
        return size;
    }

    protected boolean hasSuperClassGap(long size, long sizeOfDeclaredField, long sizeTakenBy8BytesFields) {
        return this.hasGapSmallerThan8Bytes(size) && this.hasOnly8BytesFields(sizeOfDeclaredField, sizeTakenBy8BytesFields);
    }

    protected final boolean hasOnly8BytesFields(long sizeOfDeclaredField, long sizeTakenBy8BytesFields) {
        return sizeOfDeclaredField != 0L && sizeOfDeclaredField == sizeTakenBy8BytesFields;
    }

    protected final boolean hasGapSmallerThan8Bytes(long size) {
        return (size & 7L) > 0L;
    }
}

