/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.auth;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.apache.cassandra.auth.DataResource;
import org.apache.cassandra.auth.FunctionResource;
import org.apache.cassandra.auth.IResource;
import org.apache.cassandra.auth.JMXResource;
import org.apache.cassandra.auth.RoleResource;

public final class Resources {
    public static List<? extends IResource> chain(IResource resource) {
        return Resources.chain(resource, r -> true);
    }

    public static List<? extends IResource> chain(IResource resource, Predicate<IResource> filter) {
        ArrayList<IResource> chain = new ArrayList<IResource>(4);
        while (true) {
            if (filter.test(resource)) {
                chain.add(resource);
            }
            if (!resource.hasParent()) break;
            resource = resource.getParent();
        }
        return chain;
    }

    public static IResource fromName(String name) {
        if (name.startsWith(RoleResource.root().getName())) {
            return RoleResource.fromName(name);
        }
        if (name.startsWith(DataResource.root().getName())) {
            return DataResource.fromName(name);
        }
        if (name.startsWith(FunctionResource.root().getName())) {
            return FunctionResource.fromName(name);
        }
        if (name.startsWith(JMXResource.root().getName())) {
            return JMXResource.fromName(name);
        }
        throw new IllegalArgumentException(String.format("Name %s is not valid for any resource type", name));
    }
}

