/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.functions;

import java.nio.ByteBuffer;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.functions.Arguments;
import org.apache.cassandra.cql3.functions.FunctionArguments;
import org.apache.cassandra.cql3.functions.NativeFunction;
import org.apache.cassandra.cql3.functions.NativeFunctions;
import org.apache.cassandra.cql3.functions.NativeScalarFunction;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.utils.ByteBufferUtil;

public abstract class BytesConversionFcts {
    public static void addFunctionsTo(NativeFunctions functions) {
        for (CQL3Type.Native type : CQL3Type.Native.values()) {
            if (type == CQL3Type.Native.BLOB) continue;
            functions.add(new ToBlobFunction(type));
            functions.add(new FromBlobFunction(type));
        }
    }

    public static class FromBlobFunction
    extends BytesConversionFct {
        private final CQL3Type toType;

        public FromBlobFunction(CQL3Type toType) {
            this(toType, false);
        }

        private FromBlobFunction(CQL3Type toType, boolean useLegacyName) {
            super((useLegacyName ? "blobas" : "blob_as_") + toType, toType.getType().udfType(), BytesType.instance);
            this.toType = toType;
        }

        @Override
        public ByteBuffer execute(Arguments arguments) {
            ByteBuffer val = (ByteBuffer)arguments.get(0);
            if (val != null) {
                try {
                    this.toType.getType().validate(val);
                }
                catch (MarshalException e) {
                    throw new InvalidRequestException(String.format("In call to function %s, value 0x%s is not a valid binary representation for type %s", this.name, ByteBufferUtil.bytesToHex(val), this.toType));
                }
            }
            return val;
        }

        @Override
        public NativeFunction withLegacyName() {
            return new FromBlobFunction(this.toType, true);
        }
    }

    public static class ToBlobFunction
    extends BytesConversionFct {
        private final CQL3Type fromType;

        public ToBlobFunction(CQL3Type fromType) {
            this(fromType, false);
        }

        private ToBlobFunction(CQL3Type fromType, boolean useLegacyName) {
            super(fromType + (useLegacyName ? "asblob" : "_as_blob"), BytesType.instance, fromType.getType().udfType());
            this.fromType = fromType;
        }

        @Override
        public ByteBuffer execute(Arguments arguments) {
            return (ByteBuffer)arguments.get(0);
        }

        @Override
        public NativeFunction withLegacyName() {
            return new ToBlobFunction(this.fromType, true);
        }
    }

    private static abstract class BytesConversionFct
    extends NativeScalarFunction {
        public BytesConversionFct(String name, AbstractType<?> returnType, AbstractType<?> ... argsType) {
            super(name, returnType, argsType);
        }

        @Override
        public Arguments newArguments(ProtocolVersion version) {
            return FunctionArguments.newNoopInstance(version, 1);
        }
    }
}

