/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import org.apache.cassandra.audit.AuditLogContext;
import org.apache.cassandra.audit.AuditLogEntryType;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.cql3.statements.AuthenticationStatement;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.transport.messages.ResultMessage;

public class DropIdentityStatement
extends AuthenticationStatement {
    final String identity;
    final boolean ifExists;

    public DropIdentityStatement(String identity, boolean ifExists) {
        this.identity = identity;
        this.ifExists = ifExists;
    }

    @Override
    public void authorize(ClientState state) {
        this.checkPermission(state, Permission.DROP, state.getUser().getPrimaryRole());
    }

    @Override
    public void validate(ClientState state) {
        state.ensureNotAnonymous();
        if (!this.ifExists && !DatabaseDescriptor.getRoleManager().isExistingIdentity(this.identity)) {
            throw new InvalidRequestException(String.format("identity '%s' doesn't exist", this.identity));
        }
    }

    @Override
    public AuditLogContext getAuditLogContext() {
        return new AuditLogContext(AuditLogEntryType.DROP_IDENTITY);
    }

    @Override
    public ResultMessage execute(ClientState state) throws RequestExecutionException, RequestValidationException {
        if (!this.ifExists || DatabaseDescriptor.getRoleManager().isExistingIdentity(this.identity)) {
            DatabaseDescriptor.getRoleManager().dropIdentity(this.identity);
        }
        return null;
    }
}

