/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

public enum OperationType {
    P0("Cancel all operations", false, 0),
    CLEANUP("Cleanup", true, 1),
    SCRUB("Scrub", true, 1),
    UPGRADE_SSTABLES("Upgrade sstables", true, 1),
    VERIFY("Verify", false, 1),
    MAJOR_COMPACTION("Major compaction", true, 1),
    RELOCATE("Relocate sstables to correct disk", false, 1),
    GARBAGE_COLLECT("Remove deleted data", true, 1),
    FLUSH("Flush", true, 1),
    WRITE("Write", true, 1),
    ANTICOMPACTION("Anticompaction after repair", true, 2),
    VALIDATION("Validation", false, 3),
    INDEX_BUILD("Secondary index build", false, 4),
    VIEW_BUILD("View build", false, 4),
    COMPACTION("Compaction", true, 5),
    TOMBSTONE_COMPACTION("Tombstone Compaction", true, 5),
    UNKNOWN("Unknown compaction type", false, 5),
    STREAM("Stream", true, 6),
    KEY_CACHE_SAVE("Key cache save", false, 6),
    ROW_CACHE_SAVE("Row cache save", false, 6),
    COUNTER_CACHE_SAVE("Counter cache save", false, 6),
    INDEX_SUMMARY("Index summary redistribution", false, 6);

    public final String type;
    public final String fileName;
    public final boolean writesData;
    public final int priority;

    private OperationType(String type, boolean writesData, int priority) {
        this.type = type;
        this.fileName = type.toLowerCase().replace(" ", "");
        this.writesData = writesData;
        this.priority = priority;
    }

    public static OperationType fromFileName(String fileName) {
        for (OperationType opType : OperationType.values()) {
            if (!opType.fileName.equals(fileName)) continue;
            return opType;
        }
        throw new IllegalArgumentException("Invalid fileName for operation type: " + fileName);
    }

    public String toString() {
        return this.type;
    }
}

