/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.disk.v1;

import java.io.Closeable;
import java.io.IOException;
import java.util.function.Supplier;
import javax.annotation.concurrent.NotThreadSafe;

public interface LongArray
extends Closeable {
    public long get(long var1);

    public long length();

    public long indexOf(long var1);

    @Override
    default public void close() throws IOException {
    }

    public static interface Factory {
        public LongArray open();
    }

    @NotThreadSafe
    public static class DeferredLongArray
    implements LongArray {
        private final Supplier<LongArray> supplier;
        private LongArray longArray;
        private boolean opened = false;

        public DeferredLongArray(Supplier<LongArray> supplier) {
            this.supplier = supplier;
        }

        @Override
        public long get(long idx) {
            this.open();
            return this.longArray.get(idx);
        }

        @Override
        public long length() {
            this.open();
            return this.longArray.length();
        }

        @Override
        public long indexOf(long value) {
            this.open();
            return this.longArray.indexOf(value);
        }

        @Override
        public void close() throws IOException {
            if (this.opened) {
                this.longArray.close();
            }
        }

        private void open() {
            if (!this.opened) {
                this.longArray = this.supplier.get();
                this.opened = true;
            }
        }
    }
}

