/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import java.io.IOException;
import java.util.Collection;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.db.lifecycle.LifecycleTransaction;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.index.Index;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.RangeAwareSSTableWriter;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.SSTableMultiWriter;
import org.apache.cassandra.io.sstable.SimpleSSTableMultiWriter;
import org.apache.cassandra.io.sstable.format.SSTableFormat;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.schema.TableMetadataRef;
import org.apache.cassandra.utils.TimeUUID;
import org.apache.cassandra.utils.concurrent.Transactional;

public class SSTableTxnWriter
extends Transactional.AbstractTransactional
implements Transactional {
    private final LifecycleTransaction txn;
    private final SSTableMultiWriter writer;

    public SSTableTxnWriter(LifecycleTransaction txn, SSTableMultiWriter writer) {
        this.txn = txn;
        this.writer = writer;
    }

    public void append(UnfilteredRowIterator iterator) {
        this.writer.append(iterator);
    }

    public String getFilename() {
        return this.writer.getFilename();
    }

    public long getFilePointer() {
        return this.writer.getBytesWritten();
    }

    public long getOnDiskBytesWritten() {
        return this.writer.getOnDiskBytesWritten();
    }

    @Override
    protected Throwable doCommit(Throwable accumulate) {
        return this.writer.commit(this.txn.commit(accumulate));
    }

    @Override
    protected Throwable doAbort(Throwable accumulate) {
        return this.txn.abort(this.writer.abort(accumulate));
    }

    @Override
    protected void doPrepare() {
        this.writer.prepareToCommit();
        this.txn.prepareToCommit();
    }

    @Override
    protected Throwable doPostCleanup(Throwable accumulate) {
        this.txn.close();
        this.writer.close();
        return super.doPostCleanup(accumulate);
    }

    public Collection<SSTableReader> finish(boolean openResult) {
        this.writer.setOpenResult(openResult);
        this.finish();
        return this.writer.finished();
    }

    public static SSTableTxnWriter create(ColumnFamilyStore cfs, Descriptor descriptor, long keyCount, long repairedAt, TimeUUID pendingRepair, boolean isTransient, SerializationHeader header) {
        LifecycleTransaction txn = LifecycleTransaction.offline(OperationType.WRITE);
        SSTableMultiWriter writer = cfs.createSSTableMultiWriter(descriptor, keyCount, repairedAt, pendingRepair, isTransient, header, txn);
        return new SSTableTxnWriter(txn, writer);
    }

    public static SSTableTxnWriter createRangeAware(TableMetadataRef metadata, long keyCount, long repairedAt, TimeUUID pendingRepair, boolean isTransient, SSTableFormat<?, ?> type, SerializationHeader header) {
        RangeAwareSSTableWriter writer;
        ColumnFamilyStore cfs = Keyspace.open(metadata.keyspace).getColumnFamilyStore(metadata.name);
        LifecycleTransaction txn = LifecycleTransaction.offline(OperationType.WRITE);
        try {
            writer = new RangeAwareSSTableWriter(cfs, keyCount, repairedAt, pendingRepair, isTransient, type, 0, 0L, txn, header);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new SSTableTxnWriter(txn, writer);
    }

    public static SSTableTxnWriter create(TableMetadataRef metadata, Descriptor descriptor, long keyCount, long repairedAt, TimeUUID pendingRepair, boolean isTransient, SerializationHeader header, Collection<Index.Group> indexGroups, SSTable.Owner owner) {
        LifecycleTransaction txn = LifecycleTransaction.offline(OperationType.WRITE);
        SSTableMultiWriter writer = SimpleSSTableMultiWriter.create(descriptor, keyCount, repairedAt, pendingRepair, isTransient, metadata, null, 0, header, indexGroups, txn, owner);
        return new SSTableTxnWriter(txn, writer);
    }
}

