/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.format.big;

import java.io.IOException;
import java.nio.ByteBuffer;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.cassandra.io.sstable.KeyReader;
import org.apache.cassandra.io.sstable.format.big.RowIndexEntry;
import org.apache.cassandra.io.util.FileHandle;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.Throwables;

@NotThreadSafe
public class BigTableKeyReader
implements KeyReader {
    private final FileHandle indexFile;
    private final RandomAccessReader indexFileReader;
    private final RowIndexEntry.IndexSerializer rowIndexEntrySerializer;
    private final long initialPosition;
    private ByteBuffer key;
    private long dataPosition;
    private long keyPosition;

    private BigTableKeyReader(FileHandle indexFile, RandomAccessReader indexFileReader, RowIndexEntry.IndexSerializer rowIndexEntrySerializer) {
        this.indexFile = indexFile;
        this.indexFileReader = indexFileReader;
        this.rowIndexEntrySerializer = rowIndexEntrySerializer;
        this.initialPosition = indexFileReader.getFilePointer();
    }

    public static BigTableKeyReader create(RandomAccessReader indexFileReader, RowIndexEntry.IndexSerializer serializer) throws IOException {
        BigTableKeyReader iterator = new BigTableKeyReader(null, indexFileReader, serializer);
        try {
            iterator.advance();
            return iterator;
        }
        catch (IOException | RuntimeException ex) {
            iterator.close();
            throw ex;
        }
    }

    public static BigTableKeyReader create(FileHandle indexFile, RowIndexEntry.IndexSerializer serializer) throws IOException {
        FileHandle iFile = null;
        RandomAccessReader reader = null;
        BigTableKeyReader iterator = null;
        try {
            iFile = indexFile.sharedCopy();
            reader = iFile.createReader();
            iterator = new BigTableKeyReader(iFile, reader, serializer);
            iterator.advance();
            return iterator;
        }
        catch (IOException | RuntimeException ex) {
            if (iterator != null) {
                iterator.close();
            } else {
                Throwables.closeNonNullAndAddSuppressed(ex, reader, iFile);
            }
            throw ex;
        }
    }

    @Override
    public void close() {
        this.key = null;
        this.dataPosition = -1L;
        this.keyPosition = -1L;
        FileUtils.closeQuietly(this.indexFileReader);
        FileUtils.closeQuietly(this.indexFile);
    }

    @Override
    public boolean advance() throws IOException {
        if (!this.indexFileReader.isEOF()) {
            this.keyPosition = this.indexFileReader.getFilePointer();
            this.key = ByteBufferUtil.readWithShortLength(this.indexFileReader);
            this.dataPosition = this.rowIndexEntrySerializer.deserializePositionAndSkip(this.indexFileReader);
            return true;
        }
        this.keyPosition = -1L;
        this.dataPosition = -1L;
        this.key = null;
        return false;
    }

    @Override
    public boolean isExhausted() {
        return this.key == null && this.dataPosition < 0L;
    }

    @Override
    public ByteBuffer key() {
        return this.key;
    }

    @Override
    public long keyPositionForSecondaryIndex() {
        return this.keyPosition;
    }

    @Override
    public long dataPosition() {
        return this.dataPosition;
    }

    public long indexPosition() {
        return this.indexFileReader.getFilePointer();
    }

    public void indexPosition(long position) throws IOException {
        if (position > this.indexLength()) {
            throw new IndexOutOfBoundsException("The requested position exceeds the index length");
        }
        this.indexFileReader.seek(position);
        this.key = null;
        this.keyPosition = 0L;
        this.dataPosition = 0L;
        this.advance();
    }

    public long indexLength() {
        return this.indexFileReader.length();
    }

    @Override
    public void reset() throws IOException {
        this.indexFileReader.seek(this.initialPosition);
        this.key = null;
        this.keyPosition = 0L;
        this.dataPosition = 0L;
        this.advance();
    }

    public String toString() {
        return String.format("BigTable-PartitionIndexIterator(%s)", this.indexFile.path());
    }
}

