/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.format.big;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import org.apache.cassandra.db.ClusteringBound;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DataRange;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.db.Slices;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.rows.Rows;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.rows.UnfilteredRowIteratorWithLowerBound;
import org.apache.cassandra.db.rows.UnfilteredRowIterators;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.sstable.AbstractRowIndexEntry;
import org.apache.cassandra.io.sstable.CorruptSSTableException;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.ISSTableScanner;
import org.apache.cassandra.io.sstable.IVerifier;
import org.apache.cassandra.io.sstable.IndexInfo;
import org.apache.cassandra.io.sstable.KeyReader;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.SSTableReadsListener;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.format.SSTableReaderWithFilter;
import org.apache.cassandra.io.sstable.format.big.BigFormat;
import org.apache.cassandra.io.sstable.format.big.BigTableKeyReader;
import org.apache.cassandra.io.sstable.format.big.BigTableScanner;
import org.apache.cassandra.io.sstable.format.big.BigTableVerifier;
import org.apache.cassandra.io.sstable.format.big.IndexSummaryComponent;
import org.apache.cassandra.io.sstable.format.big.RowIndexEntry;
import org.apache.cassandra.io.sstable.format.big.SSTableIterator;
import org.apache.cassandra.io.sstable.format.big.SSTableReversedIterator;
import org.apache.cassandra.io.sstable.indexsummary.IndexSummary;
import org.apache.cassandra.io.sstable.indexsummary.IndexSummaryBuilder;
import org.apache.cassandra.io.sstable.indexsummary.IndexSummarySupport;
import org.apache.cassandra.io.sstable.keycache.KeyCache;
import org.apache.cassandra.io.sstable.keycache.KeyCacheSupport;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.FileDataInput;
import org.apache.cassandra.io.util.FileHandle;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.IFilter;
import org.apache.cassandra.utils.OutputHandler;
import org.apache.cassandra.utils.concurrent.SharedCloseable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigTableReader
extends SSTableReaderWithFilter
implements IndexSummarySupport<BigTableReader>,
KeyCacheSupport<BigTableReader> {
    private static final Logger logger = LoggerFactory.getLogger(BigTableReader.class);
    private final RowIndexEntry.IndexSerializer rowIndexEntrySerializer;
    private final IndexSummary indexSummary;
    private final FileHandle ifile;
    private final KeyCache keyCache;

    public BigTableReader(Builder builder, SSTable.Owner owner) {
        super(builder, owner);
        this.ifile = builder.getIndexFile();
        this.indexSummary = builder.getIndexSummary();
        this.rowIndexEntrySerializer = new RowIndexEntry.Serializer(this.descriptor.version, this.header, owner != null ? owner.getMetrics() : null);
        this.keyCache = Objects.requireNonNull(builder.getKeyCache());
    }

    @Override
    protected List<AutoCloseable> setupInstance(boolean trackHotness) {
        ArrayList closeables = Lists.newArrayList((Object[])new AutoCloseable[]{this.indexSummary, this.ifile});
        closeables.addAll(super.setupInstance(trackHotness));
        return closeables;
    }

    @Override
    public void releaseInMemoryComponents() {
        this.closeInternalComponent(this.indexSummary);
        assert (this.indexSummary.isCleanedUp());
    }

    @Override
    public IndexSummary getIndexSummary() {
        return this.indexSummary;
    }

    @Override
    public UnfilteredRowIterator rowIterator(DecoratedKey key, Slices slices, ColumnFilter selectedColumns, boolean reversed, SSTableReadsListener listener) {
        RowIndexEntry rie = this.getRowIndexEntry(key, SSTableReader.Operator.EQ, true, listener);
        return this.rowIterator(null, key, rie, slices, selectedColumns, reversed);
    }

    public UnfilteredRowIterator rowIterator(FileDataInput file, DecoratedKey key, RowIndexEntry indexEntry, Slices slices, ColumnFilter selectedColumns, boolean reversed) {
        if (indexEntry == null) {
            return UnfilteredRowIterators.noRowsIterator(this.metadata(), key, Rows.EMPTY_STATIC_ROW, DeletionTime.LIVE, reversed);
        }
        if (reversed) {
            return new SSTableReversedIterator((SSTableReader)this, file, key, indexEntry, slices, selectedColumns, this.ifile);
        }
        return new SSTableIterator((SSTableReader)this, file, key, indexEntry, slices, selectedColumns, this.ifile);
    }

    @Override
    public ISSTableScanner partitionIterator(ColumnFilter columns, DataRange dataRange, SSTableReadsListener listener) {
        return BigTableScanner.getScanner(this, columns, dataRange, listener);
    }

    @Override
    public KeyReader keyReader() throws IOException {
        return BigTableKeyReader.create(this.ifile, this.rowIndexEntrySerializer);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DecoratedKey firstKeyBeyond(PartitionPosition token) {
        if (token.compareTo(this.getFirst()) < 0) {
            return this.getFirst();
        }
        long sampledPosition = this.getIndexScanPosition(token);
        if (this.ifile == null) {
            return null;
        }
        String path = null;
        try (FileDataInput in = this.ifile.createReader(sampledPosition);){
            path = in.getPath();
            while (!in.isEOF()) {
                ByteBuffer indexKey = ByteBufferUtil.readWithShortLength(in);
                DecoratedKey indexDecoratedKey = this.decorateKey(indexKey);
                if (indexDecoratedKey.compareTo(token) > 0) {
                    DecoratedKey decoratedKey = indexDecoratedKey;
                    return decoratedKey;
                }
                RowIndexEntry.Serializer.skip(in, this.descriptor.version);
            }
            return null;
        }
        catch (IOException e) {
            this.markSuspect();
            throw new CorruptSSTableException((Throwable)e, path);
        }
    }

    public final RowIndexEntry getRowIndexEntry(PartitionPosition key, SSTableReader.Operator op) {
        return this.getRowIndexEntry(key, op, true, SSTableReadsListener.NOOP_LISTENER);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public RowIndexEntry getRowIndexEntry(PartitionPosition key, SSTableReader.Operator operator, boolean updateStats, SSTableReadsListener listener) {
        DecoratedKey decoratedKey;
        AbstractRowIndexEntry cachedPosition;
        if (this.ifile == null) {
            return null;
        }
        SSTableReader.Operator searchOp = operator;
        boolean skip = false;
        if (key.compareTo(this.getFirst()) < 0) {
            if (searchOp == SSTableReader.Operator.EQ) {
                skip = true;
            } else {
                key = this.getFirst();
                searchOp = SSTableReader.Operator.GE;
            }
        } else {
            int l = this.getLast().compareTo(key);
            boolean bl = skip = l < 0 || l == 0 && searchOp == SSTableReader.Operator.GT;
            if (l == 0) {
                searchOp = SSTableReader.Operator.GE;
            }
        }
        if (skip) {
            this.notifySkipped(SSTableReadsListener.SkippingReason.MIN_MAX_KEYS, listener, operator, updateStats);
            return null;
        }
        if (searchOp == SSTableReader.Operator.EQ) {
            assert (key instanceof DecoratedKey);
            if (!this.isPresentInFilter((IFilter.FilterKey)((Object)key))) {
                this.notifySkipped(SSTableReadsListener.SkippingReason.BLOOM_FILTER, listener, operator, updateStats);
                return null;
            }
        }
        if ((searchOp == SSTableReader.Operator.EQ || searchOp == SSTableReader.Operator.GE) && key instanceof DecoratedKey && (cachedPosition = this.getCachedPosition(decoratedKey = (DecoratedKey)key, updateStats)) != null && cachedPosition.getSSTableFormat() == this.descriptor.getFormat()) {
            this.notifySelected(SSTableReadsListener.SelectionReason.KEY_CACHE_HIT, listener, operator, updateStats, cachedPosition);
            return (RowIndexEntry)cachedPosition;
        }
        int binarySearchResult = this.indexSummary.binarySearch(key);
        long sampledPosition = this.indexSummary.getScanPositionFromBinarySearchResult(binarySearchResult);
        int sampledIndex = IndexSummary.getIndexFromBinarySearchResult(binarySearchResult);
        int effectiveInterval = this.indexSummary.getEffectiveIndexIntervalAfterIndex(sampledIndex);
        int i = 0;
        String path = null;
        try (FileDataInput in = this.ifile.createReader(sampledPosition);){
            path = in.getPath();
            while (!in.isEOF()) {
                boolean opSatisfied;
                boolean exactMatch;
                ByteBuffer indexKey = ByteBufferUtil.readWithShortLength(in);
                if (searchOp == SSTableReader.Operator.EQ && ++i <= effectiveInterval) {
                    opSatisfied = exactMatch = indexKey.equals(((DecoratedKey)key).getKey());
                } else {
                    DecoratedKey indexDecoratedKey = this.decorateKey(indexKey);
                    int comparison = indexDecoratedKey.compareTo(key);
                    int v = searchOp.apply(comparison);
                    opSatisfied = v == 0;
                    boolean bl = exactMatch = comparison == 0;
                    if (v < 0) {
                        this.notifySkipped(SSTableReadsListener.SkippingReason.PARTITION_INDEX_LOOKUP, listener, operator, updateStats);
                        RowIndexEntry rowIndexEntry = null;
                        return rowIndexEntry;
                    }
                }
                if (opSatisfied) {
                    RowIndexEntry indexEntry = this.rowIndexEntrySerializer.deserialize(in);
                    if (exactMatch && updateStats) {
                        assert (key instanceof DecoratedKey);
                        DecoratedKey decoratedKey2 = (DecoratedKey)key;
                        if (logger.isTraceEnabled()) {
                            try (FileDataInput fdi = this.dfile.createReader(indexEntry.position);){
                                DecoratedKey keyInDisk = this.decorateKey(ByteBufferUtil.readWithShortLength(fdi));
                                if (!keyInDisk.equals(key)) {
                                    throw new AssertionError((Object)String.format("%s != %s in %s", keyInDisk, key, fdi.getPath()));
                                }
                            }
                        }
                        this.cacheKey(decoratedKey2, indexEntry);
                    }
                    this.notifySelected(SSTableReadsListener.SelectionReason.INDEX_ENTRY_FOUND, listener, operator, updateStats, indexEntry);
                    RowIndexEntry rowIndexEntry = indexEntry;
                    return rowIndexEntry;
                }
                RowIndexEntry.Serializer.skip(in, this.descriptor.version);
            }
        }
        catch (IOException e) {
            this.markSuspect();
            throw new CorruptSSTableException((Throwable)e, path);
        }
        this.notifySkipped(SSTableReadsListener.SkippingReason.INDEX_ENTRY_NOT_FOUND, listener, operator, updateStats);
        return null;
    }

    @Override
    protected long getPosition(PartitionPosition key, SSTableReader.Operator op, boolean updateCacheAndStats, SSTableReadsListener listener) {
        RowIndexEntry rowIndexEntry = this.getRowIndexEntry(key, op, updateCacheAndStats, listener);
        return rowIndexEntry != null ? rowIndexEntry.position : -1L;
    }

    @Override
    public DecoratedKey keyAtPositionFromSecondaryIndex(long keyPositionFromSecondaryIndex) throws IOException {
        DecoratedKey key;
        try (FileDataInput in = this.ifile.createReader(keyPositionFromSecondaryIndex);){
            if (in.isEOF()) {
                DecoratedKey decoratedKey = null;
                return decoratedKey;
            }
            key = this.decorateKey(ByteBufferUtil.readWithShortLength(in));
            this.cacheKey(key, this.rowIndexEntrySerializer.deserialize(in));
        }
        return key;
    }

    @Override
    public RowIndexEntry deserializeKeyCacheValue(DataInputPlus input) throws IOException {
        return this.rowIndexEntrySerializer.deserializeForCache(input);
    }

    @Override
    public ClusteringBound<?> getLowerBoundPrefixFromCache(DecoratedKey partitionKey, boolean isReversed) {
        ClusteringBound<?> clusteringBound;
        block10: {
            AbstractRowIndexEntry rie = this.getCachedPosition(partitionKey, false);
            if (!(rie instanceof RowIndexEntry)) {
                return null;
            }
            RowIndexEntry rowIndexEntry = (RowIndexEntry)rie;
            if (!rowIndexEntry.indexOnHeap()) {
                return null;
            }
            RowIndexEntry.IndexInfoRetriever onHeapRetriever = rowIndexEntry.openWithIndex(null);
            try {
                IndexInfo columns = onHeapRetriever.columnsIndex(isReversed ? rowIndexEntry.blockCount() - 1 : 0);
                ClusteringBound<?> bound = isReversed ? columns.lastName.asEndBound() : columns.firstName.asStartBound();
                UnfilteredRowIteratorWithLowerBound.assertBoundSize(bound, this);
                clusteringBound = bound.artificialLowerBound(isReversed);
                if (onHeapRetriever == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (onHeapRetriever != null) {
                        try {
                            onHeapRetriever.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("should never occur", e);
                }
            }
            onHeapRetriever.close();
        }
        return clusteringBound;
    }

    @Override
    public long estimatedKeys() {
        return this.indexSummary.getEstimatedKeyCount();
    }

    @Override
    public long estimatedKeysForRanges(Collection<Range<Token>> ranges) {
        long sampleKeyCount = 0L;
        List<SSTableReader.IndexesBounds> sampleIndexes = this.indexSummary.getSampleIndexesForRanges(ranges);
        for (SSTableReader.IndexesBounds sampleIndexRange : sampleIndexes) {
            sampleKeyCount += (long)(sampleIndexRange.upperPosition - sampleIndexRange.lowerPosition + 1);
        }
        long estimatedKeys = sampleKeyCount * (128L * (long)this.indexSummary.getMinIndexInterval()) / (long)this.indexSummary.getSamplingLevel();
        return Math.max(1L, estimatedKeys);
    }

    @Override
    public boolean isEstimationInformative() {
        return this.indexSummary.size() > 2;
    }

    @Override
    public Iterable<DecoratedKey> getKeySamples(Range<Token> range) {
        return Iterables.transform(this.indexSummary.getKeySamples(range), bytes -> this.decorateKey(ByteBuffer.wrap(bytes)));
    }

    public RandomAccessReader openIndexReader() {
        if (this.ifile != null) {
            return this.ifile.createReader();
        }
        return null;
    }

    public FileHandle getIndexFile() {
        return this.ifile;
    }

    @Override
    public IVerifier getVerifier(ColumnFamilyStore cfs, OutputHandler outputHandler, boolean isOffline, IVerifier.Options options) {
        Preconditions.checkArgument((boolean)cfs.metadata().equals(this.metadata()));
        return new BigTableVerifier(cfs, this, outputHandler, isOffline, options);
    }

    long getIndexScanPosition(PartitionPosition key) {
        if (this.openReason == SSTableReader.OpenReason.MOVED_START && key.compareTo(this.getFirst()) < 0) {
            key = this.getFirst();
        }
        return this.indexSummary.getScanPosition(key);
    }

    protected final Builder unbuildTo(Builder builder, boolean sharedCopy) {
        Builder b = super.unbuildTo(builder, sharedCopy);
        if (builder.getIndexFile() == null) {
            b.setIndexFile(sharedCopy ? SharedCloseable.sharedCopyOrNull(this.ifile) : this.ifile);
        }
        if (builder.getIndexSummary() == null) {
            b.setIndexSummary(sharedCopy ? SharedCloseable.sharedCopyOrNull(this.indexSummary) : this.indexSummary);
        }
        b.setKeyCache(this.keyCache);
        return b;
    }

    @Override
    @VisibleForTesting
    public SSTableReaderWithFilter cloneAndReplace(IFilter filter) {
        return (SSTableReaderWithFilter)this.unbuildTo((Builder)new Builder(this.descriptor).setFilter(filter), true).build(this.owner().orElse(null), true, true);
    }

    private SSTableReader cloneAndReplace(DecoratedKey newFirst, SSTableReader.OpenReason reason) {
        return ((Builder)((Builder)this.unbuildTo(new Builder(this.descriptor), true).setFirst(newFirst)).setOpenReason(reason)).build(this.owner().orElse(null), true, true);
    }

    private BigTableReader cloneAndReplace(DecoratedKey newFirst, SSTableReader.OpenReason reason, IndexSummary newSummary) {
        return (BigTableReader)((Builder)((Builder)this.unbuildTo(new Builder(this.descriptor).setIndexSummary(newSummary), true).setIndexSummary(newSummary).setFirst(newFirst)).setOpenReason(reason)).build(this.owner().orElse(null), true, true);
    }

    @Override
    public SSTableReader cloneWithRestoredStart(DecoratedKey restoredStart) {
        return this.runWithLock(ignored -> this.cloneAndReplace(restoredStart, SSTableReader.OpenReason.NORMAL));
    }

    @Override
    public SSTableReader cloneWithNewStart(DecoratedKey newStart) {
        return this.runWithLock(ignored -> {
            assert (this.openReason != SSTableReader.OpenReason.EARLY);
            if (newStart.compareTo(this.getFirst()) > 0) {
                LinkedHashMap<FileHandle, Long> handleAndPositions = new LinkedHashMap<FileHandle, Long>(2);
                if (this.dfile != null) {
                    handleAndPositions.put(this.dfile, this.getPosition(newStart, SSTableReader.Operator.EQ));
                }
                if (this.ifile != null) {
                    handleAndPositions.put(this.ifile, this.getIndexScanPosition(newStart));
                }
                this.runOnClose(() -> handleAndPositions.forEach(FileHandle::dropPageCache));
            }
            return this.cloneAndReplace(newStart, SSTableReader.OpenReason.MOVED_START);
        });
    }

    @Override
    public BigTableReader cloneWithNewSummarySamplingLevel(ColumnFamilyStore parent, int samplingLevel) throws IOException {
        IndexSummary newSummary;
        assert (this.openReason != SSTableReader.OpenReason.EARLY);
        int minIndexInterval = this.metadata().params.minIndexInterval;
        int maxIndexInterval = this.metadata().params.maxIndexInterval;
        double effectiveInterval = this.indexSummary.getEffectiveIndexInterval();
        if (samplingLevel > this.indexSummary.getSamplingLevel() || this.indexSummary.getMinIndexInterval() != minIndexInterval || effectiveInterval > (double)maxIndexInterval) {
            newSummary = this.buildSummaryAtLevel(samplingLevel);
        } else if (samplingLevel < this.indexSummary.getSamplingLevel()) {
            newSummary = IndexSummaryBuilder.downsample(this.indexSummary, samplingLevel, minIndexInterval, this.getPartitioner());
        } else {
            throw new AssertionError((Object)"Attempted to clone SSTableReader with the same index summary sampling level and no adjustments to min/max_index_interval");
        }
        return this.runWithLock(ignored -> {
            new IndexSummaryComponent(newSummary, this.getFirst(), this.getLast()).save(this.descriptor.fileFor(BigFormat.Components.SUMMARY), true);
            return this.cloneAndReplace(this.getFirst(), SSTableReader.OpenReason.METADATA_CHANGE, newSummary);
        });
    }

    private IndexSummary buildSummaryAtLevel(int newSamplingLevel) throws IOException {
        RandomAccessReader primaryIndex = RandomAccessReader.open(this.descriptor.fileFor(BigFormat.Components.PRIMARY_INDEX));
        try {
            long indexSize = primaryIndex.length();
            IndexSummaryBuilder summaryBuilder = new IndexSummaryBuilder(this.estimatedKeys(), this.metadata().params.minIndexInterval, newSamplingLevel);
            try {
                long indexPosition;
                while ((indexPosition = primaryIndex.getFilePointer()) != indexSize) {
                    summaryBuilder.maybeAddEntry(this.decorateKey(ByteBufferUtil.readWithShortLength(primaryIndex)), indexPosition);
                    RowIndexEntry.Serializer.skip(primaryIndex, this.descriptor.version);
                }
                IndexSummary indexSummary = summaryBuilder.build(this.getPartitioner());
                summaryBuilder.close();
                return indexSummary;
            }
            catch (Throwable throwable) {
                try {
                    summaryBuilder.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            FileUtils.closeQuietly(primaryIndex);
        }
    }

    @Override
    public KeyCache getKeyCache() {
        return this.keyCache;
    }

    public static class Builder
    extends SSTableReaderWithFilter.Builder<BigTableReader, Builder> {
        private static final Logger logger = LoggerFactory.getLogger(Builder.class);
        private IndexSummary indexSummary;
        private FileHandle indexFile;
        private KeyCache keyCache = KeyCache.NO_CACHE;

        public Builder(Descriptor descriptor) {
            super(descriptor);
        }

        public Builder setIndexFile(FileHandle indexFile) {
            this.indexFile = indexFile;
            return this;
        }

        public Builder setIndexSummary(IndexSummary indexSummary) {
            this.indexSummary = indexSummary;
            return this;
        }

        public Builder setKeyCache(KeyCache keyCache) {
            this.keyCache = keyCache;
            return this;
        }

        public IndexSummary getIndexSummary() {
            return this.indexSummary;
        }

        public FileHandle getIndexFile() {
            return this.indexFile;
        }

        public KeyCache getKeyCache() {
            return this.keyCache;
        }

        @Override
        protected BigTableReader buildInternal(SSTable.Owner owner) {
            return new BigTableReader(this, owner);
        }
    }
}

