/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair.state;

import java.util.EnumMap;
import org.apache.cassandra.repair.state.AbstractCompletable;
import org.apache.cassandra.repair.state.Completable;
import org.apache.cassandra.repair.state.State;
import org.apache.cassandra.utils.Clock;

public abstract class AbstractState<T extends Enum<T>, I>
extends AbstractCompletable<I>
implements State<T, I> {
    public static final int INIT = -1;
    public static final int COMPLETE = -2;
    private final Class<T> klass;
    protected final long[] stateTimesNanos;
    protected int currentState = -1;

    public AbstractState(Clock clock, I id, Class<T> klass) {
        super(clock, id);
        this.klass = klass;
        this.stateTimesNanos = new long[((Enum[])klass.getEnumConstants()).length];
    }

    @Override
    public boolean isAccepted() {
        return this.currentState != -1;
    }

    @Override
    public T getStatus() {
        int current = this.currentState;
        if (current < 0) {
            return null;
        }
        return (T)((Enum[])this.klass.getEnumConstants())[current];
    }

    public String status() {
        T state = this.getStatus();
        Completable.Result result = this.getResult();
        if (result != null) {
            return result.kind.name();
        }
        if (state == null) {
            return "init";
        }
        return ((Enum)state).name();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{id=" + this.id + ", status=" + this.status() + ", lastUpdatedAtNs=" + this.lastUpdatedAtNs + "}";
    }

    public int getCurrentState() {
        return this.currentState;
    }

    @Override
    public EnumMap<T, Long> getStateTimesMillis() {
        long[] millis = this.getStateTimesMillisArray();
        EnumMap<T, Long> map = new EnumMap<T, Long>(this.klass);
        for (int i = 0; i < millis.length; ++i) {
            long ms = millis[i];
            if (ms == 0L) continue;
            map.put(((Enum[])this.klass.getEnumConstants())[i], ms);
        }
        return map;
    }

    @Override
    protected void onComplete() {
        this.currentState = -2;
    }

    private long[] getStateTimesMillisArray() {
        long[] millis = new long[this.stateTimesNanos.length];
        for (int i = 0; i < millis.length; ++i) {
            long value = this.stateTimesNanos[i];
            if (value == 0L) continue;
            millis[i] = this.nanosToMillis(value);
        }
        return millis;
    }

    protected void updateState(T state) {
        if (this.maybeUpdateState(state).isRejected()) {
            throw new IllegalStateException("State went backwards; current=" + ((Enum[])this.klass.getEnumConstants())[this.currentState] + ", desired=" + state);
        }
    }

    protected UpdateType maybeUpdateState(T state) {
        int currentState = this.currentState;
        if (currentState == -2) {
            return UpdateType.ALREADY_COMPLETED;
        }
        if (currentState == ((Enum)state).ordinal()) {
            return UpdateType.NO_CHANGE;
        }
        if (currentState > ((Enum)state).ordinal()) {
            return UpdateType.LARGER_STATE_SEEN;
        }
        long now = this.clock.nanoTime();
        this.currentState = ((Enum)state).ordinal();
        this.stateTimesNanos[this.currentState] = now;
        this.lastUpdatedAtNs = now;
        return UpdateType.ACCEPTED;
    }

    protected static enum UpdateType {
        NO_CHANGE,
        ACCEPTED,
        LARGER_STATE_SEEN,
        ALREADY_COMPLETED;


        protected boolean isRejected() {
            switch (this) {
                case NO_CHANGE: 
                case ACCEPTED: {
                    return false;
                }
                case LARGER_STATE_SEEN: 
                case ALREADY_COMPLETED: {
                    return true;
                }
            }
            throw new IllegalStateException("Unknown type: " + this);
        }
    }
}

