/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.schema;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.cassandra.auth.AuthKeyspace;
import org.apache.cassandra.db.Digest;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.schema.SchemaKeyspaceTables;
import org.apache.cassandra.schema.SystemDistributedKeyspace;
import org.apache.cassandra.tracing.TraceKeyspace;

public final class SchemaConstants {
    public static final Pattern PATTERN_WORD_CHARS = Pattern.compile("\\w+");
    public static final Pattern PATTERN_NON_WORD_CHAR = Pattern.compile("\\W");
    public static final String SYSTEM_KEYSPACE_NAME = "system";
    public static final String SCHEMA_KEYSPACE_NAME = "system_schema";
    public static final String TRACE_KEYSPACE_NAME = "system_traces";
    public static final String AUTH_KEYSPACE_NAME = "system_auth";
    public static final String DISTRIBUTED_KEYSPACE_NAME = "system_distributed";
    public static final String VIRTUAL_SCHEMA = "system_virtual_schema";
    public static final String VIRTUAL_VIEWS = "system_views";
    public static final String DUMMY_KEYSPACE_OR_TABLE_NAME = "--dummy--";
    public static final Set<String> LOCAL_SYSTEM_KEYSPACE_NAMES = ImmutableSet.of((Object)"system", (Object)"system_schema");
    public static final Set<String> VIRTUAL_SYSTEM_KEYSPACE_NAMES = ImmutableSet.of((Object)"system_views", (Object)"system_virtual_schema");
    public static final Set<String> REPLICATED_SYSTEM_KEYSPACE_NAMES = ImmutableSet.of((Object)"system_traces", (Object)"system_auth", (Object)"system_distributed");
    public static final int NAME_LENGTH = 48;
    public static final int FILENAME_LENGTH = 255;
    public static final int TABLE_UUID_AS_HEX_LENGTH = 32;
    public static final int TABLE_NAME_LENGTH = 223 - "-".length();
    public static final UUID emptyVersion;
    public static final List<String> LEGACY_AUTH_TABLES;

    public static boolean isValidCharsName(String name) {
        return name != null && !name.isEmpty() && PATTERN_WORD_CHARS.matcher(name).matches();
    }

    public static boolean isLocalSystemKeyspace(String keyspaceName) {
        return LOCAL_SYSTEM_KEYSPACE_NAMES.contains(keyspaceName.toLowerCase()) || SchemaConstants.isVirtualSystemKeyspace(keyspaceName);
    }

    public static boolean isReplicatedSystemKeyspace(String keyspaceName) {
        return REPLICATED_SYSTEM_KEYSPACE_NAMES.contains(keyspaceName.toLowerCase());
    }

    public static boolean isVirtualSystemKeyspace(String keyspaceName) {
        return VIRTUAL_SYSTEM_KEYSPACE_NAMES.contains(keyspaceName.toLowerCase());
    }

    public static boolean isSystemKeyspace(String keyspaceName) {
        return SchemaConstants.isLocalSystemKeyspace(keyspaceName) || SchemaConstants.isReplicatedSystemKeyspace(keyspaceName);
    }

    public static boolean isNonVirtualSystemKeyspace(String keyspaceName) {
        String lowercaseKeyspaceName = keyspaceName.toLowerCase();
        return LOCAL_SYSTEM_KEYSPACE_NAMES.contains(lowercaseKeyspaceName) || REPLICATED_SYSTEM_KEYSPACE_NAMES.contains(lowercaseKeyspaceName);
    }

    public static Set<String> getSystemKeyspaces() {
        return Sets.union((Set)Sets.union(LOCAL_SYSTEM_KEYSPACE_NAMES, REPLICATED_SYSTEM_KEYSPACE_NAMES), VIRTUAL_SYSTEM_KEYSPACE_NAMES);
    }

    public static Set<String> getLocalAndReplicatedSystemKeyspaceNames() {
        return Sets.union(LOCAL_SYSTEM_KEYSPACE_NAMES, REPLICATED_SYSTEM_KEYSPACE_NAMES);
    }

    public static Set<String> getLocalAndReplicatedSystemTableNames() {
        return ImmutableSet.builder().addAll(SystemKeyspace.TABLE_NAMES).addAll(SchemaKeyspaceTables.ALL).addAll(TraceKeyspace.TABLE_NAMES).addAll(AuthKeyspace.TABLE_NAMES).addAll(SystemDistributedKeyspace.TABLE_NAMES).build();
    }

    static {
        LEGACY_AUTH_TABLES = Arrays.asList("credentials", "users", "permissions");
        emptyVersion = UUID.nameUUIDFromBytes(Digest.forSchema().digest());
    }
}

