/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.serializers;

import com.google.common.collect.Range;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.ByteBufferAccessor;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.utils.ByteBufferUtil;

public abstract class CollectionSerializer<T>
extends TypeSerializer<T> {
    protected abstract List<ByteBuffer> serializeValues(T var1);

    protected abstract int getElementCount(T var1);

    @Override
    public ByteBuffer serialize(T input) {
        List<ByteBuffer> values = this.serializeValues(input);
        return CollectionSerializer.pack(values, ByteBufferAccessor.instance, this.getElementCount(input));
    }

    public static ByteBuffer pack(Collection<ByteBuffer> values, int elements) {
        return CollectionSerializer.pack(values, ByteBufferAccessor.instance, elements);
    }

    public static <V> V pack(Collection<V> values, ValueAccessor<V> accessor, int elements) {
        int size = 0;
        for (V value : values) {
            size += CollectionSerializer.sizeOfValue(value, accessor);
        }
        ByteBuffer result = ByteBuffer.allocate(CollectionSerializer.sizeOfCollectionSize() + size);
        CollectionSerializer.writeCollectionSize(result, elements);
        for (V value : values) {
            CollectionSerializer.writeValue(result, value, accessor);
        }
        return accessor.valueOf(result.flip());
    }

    protected static void writeCollectionSize(ByteBuffer output, int elements) {
        output.putInt(elements);
    }

    public static <V> int readCollectionSize(V value, ValueAccessor<V> accessor) {
        return accessor.toInt(value);
    }

    public static int sizeOfCollectionSize() {
        return 4;
    }

    public static <V> void writeValue(ByteBuffer output, V value, ValueAccessor<V> accessor) {
        if (value == null) {
            output.putInt(-1);
            return;
        }
        output.putInt(accessor.size(value));
        accessor.write(value, output);
    }

    public static <V> V readValue(V input, ValueAccessor<V> accessor, int offset) {
        int size = accessor.getInt(input, offset);
        if (size < 0) {
            return null;
        }
        return accessor.slice(input, offset + 4, size);
    }

    public static <V> V readNonNullValue(V input, ValueAccessor<V> accessor, int offset) {
        V value = CollectionSerializer.readValue(input, accessor, offset);
        if (value == null) {
            throw new MarshalException("Null value read when not allowed");
        }
        return value;
    }

    protected static void skipValue(ByteBuffer input) {
        int size = input.getInt();
        input.position(input.position() + size);
    }

    public static <V> int skipValue(V input, ValueAccessor<V> accessor, int offset) {
        int size = accessor.getInt(input, offset);
        return TypeSizes.sizeof(size) + size;
    }

    public static <V> int sizeOfValue(V value, ValueAccessor<V> accessor) {
        return value == null ? 4 : 4 + accessor.size(value);
    }

    public abstract ByteBuffer getSerializedValue(ByteBuffer var1, ByteBuffer var2, AbstractType<?> var3);

    public abstract ByteBuffer getSliceFromSerialized(ByteBuffer var1, ByteBuffer var2, ByteBuffer var3, AbstractType<?> var4, boolean var5);

    public abstract int getIndexFromSerialized(ByteBuffer var1, ByteBuffer var2, AbstractType<?> var3);

    public abstract Range<Integer> getIndexesRangeFromSerialized(ByteBuffer var1, ByteBuffer var2, ByteBuffer var3, AbstractType<?> var4);

    protected ByteBuffer copyAsNewCollection(ByteBuffer input, int count, int startPos, int endPos) {
        int sizeLen = CollectionSerializer.sizeOfCollectionSize();
        if (count == 0) {
            return ByteBuffer.allocate(sizeLen);
        }
        int bodyLen = endPos - startPos;
        ByteBuffer output = ByteBuffer.allocate(sizeLen + bodyLen);
        CollectionSerializer.writeCollectionSize(output, count);
        output.position(0);
        ByteBufferUtil.copyBytes(input, startPos, output, sizeLen, bodyLen);
        return output;
    }

    public void forEach(ByteBuffer input, Consumer<ByteBuffer> action) {
        try {
            int collectionSize = CollectionSerializer.readCollectionSize(input, ByteBufferAccessor.instance);
            int offset = CollectionSerializer.sizeOfCollectionSize();
            for (int i = 0; i < collectionSize; ++i) {
                ByteBuffer value = CollectionSerializer.readValue(input, ByteBufferAccessor.instance, offset);
                offset += CollectionSerializer.sizeOfValue(value, ByteBufferAccessor.instance);
                action.accept(value);
            }
        }
        catch (IndexOutOfBoundsException | BufferUnderflowException e) {
            throw new MarshalException("Not enough bytes to read a set");
        }
    }
}

