/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.concurrent;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.apache.cassandra.utils.concurrent.Condition;
import org.apache.cassandra.utils.concurrent.WaitQueue;

public class OpOrder {
    private static final int FINISHED = -1;
    private volatile Group current = new Group();

    public Group start() {
        Group current;
        while (!(current = this.current).register()) {
        }
        return current;
    }

    public Barrier newBarrier() {
        return new Barrier();
    }

    public Group getCurrent() {
        return this.current;
    }

    public void awaitNewBarrier() {
        Barrier barrier = this.newBarrier();
        barrier.issue();
        barrier.await();
    }

    public final class Barrier {
        private volatile Group orderOnOrBefore;

        public boolean isAfter(Group group) {
            if (this.orderOnOrBefore == null) {
                return true;
            }
            return this.orderOnOrBefore.id - group.id >= 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void issue() {
            Group current;
            if (this.orderOnOrBefore != null) {
                throw new IllegalStateException("Can only call issue() once on each Barrier");
            }
            OpOrder opOrder = OpOrder.this;
            synchronized (opOrder) {
                this.orderOnOrBefore = current = OpOrder.this.current;
                OpOrder.this.current = current.next = new Group(current);
            }
            current.expire();
        }

        public void markBlocking() {
            Group current = this.orderOnOrBefore;
            while (current != null) {
                current.markBlocking();
                current = current.prev;
            }
        }

        public void await() {
            Group current = this.orderOnOrBefore;
            if (current == null) {
                throw new IllegalStateException("This barrier needs to have issue() called on it before prior operations can complete");
            }
            current.await();
        }

        public Group getSyncPoint() {
            return this.orderOnOrBefore;
        }
    }

    public static final class Group
    implements Comparable<Group>,
    AutoCloseable {
        private volatile Group prev;
        private volatile Group next;
        private final long id;
        private volatile int running = 0;
        private volatile boolean isBlocking;
        private volatile ConcurrentLinkedQueue<WaitQueue.Signal> blocking;
        private final WaitQueue waiting = WaitQueue.newWaitQueue();
        static final AtomicIntegerFieldUpdater<Group> runningUpdater = AtomicIntegerFieldUpdater.newUpdater(Group.class, "running");
        static final AtomicReferenceFieldUpdater<Group, ConcurrentLinkedQueue> blockingUpdater = AtomicReferenceFieldUpdater.newUpdater(Group.class, ConcurrentLinkedQueue.class, "blocking");

        private Group() {
            this.id = 0L;
        }

        private Group(Group prev) {
            this.id = prev.id + 1L;
            this.prev = prev;
        }

        private void expire() {
            int current;
            do {
                if ((current = this.running) >= 0) continue;
                throw new IllegalStateException();
            } while (!runningUpdater.compareAndSet(this, current, -1 - current));
            if (current == 0) {
                this.unlink();
            }
        }

        private boolean register() {
            int current;
            do {
                if ((current = this.running) >= 0) continue;
                return false;
            } while (!runningUpdater.compareAndSet(this, current, current + 1));
            return true;
        }

        @Override
        public void close() {
            while (true) {
                int current;
                if ((current = this.running) < 0) {
                    if (!runningUpdater.compareAndSet(this, current, current + 1)) continue;
                    if (current + 1 == -1) {
                        this.unlink();
                    }
                    return;
                }
                if (runningUpdater.compareAndSet(this, current, current - 1)) break;
            }
        }

        public boolean isFinished() {
            return this.next.prev == null;
        }

        public boolean isOldestLiveGroup() {
            return this.prev == null;
        }

        public void await() {
            while (!this.isFinished()) {
                WaitQueue.Signal signal = this.waiting.register();
                if (this.isFinished()) {
                    signal.cancel();
                    return;
                }
                signal.awaitUninterruptibly();
            }
            assert (this.running == -1);
        }

        public Group prev() {
            return this.prev;
        }

        private void unlink() {
            Group prev;
            Group start = this;
            while ((prev = start.prev) != null) {
                if (prev.running != -1) {
                    return;
                }
                start = prev;
            }
            Group end = this.next;
            while (end.running == -1) {
                end = end.next;
            }
            while (start != end) {
                Group next = start.next;
                next.prev = null;
                start.waiting.signalAll();
                start = next;
            }
        }

        public boolean isBlocking() {
            return this.isBlocking;
        }

        public void notifyIfBlocking(WaitQueue.Signal signal) {
            if (this.blocking == null) {
                blockingUpdater.compareAndSet(this, null, new ConcurrentLinkedQueue());
            }
            this.blocking.add(signal);
            if (this.isBlocking() && this.blocking.remove(signal)) {
                signal.signal();
            }
        }

        private void markBlocking() {
            this.isBlocking = true;
            ConcurrentLinkedQueue<WaitQueue.Signal> blocking = this.blocking;
            if (blocking != null) {
                blocking.forEach(Condition::signal);
            }
        }

        @Override
        public int compareTo(Group that) {
            long c = this.id - that.id;
            if (c > 0L) {
                return 1;
            }
            if (c < 0L) {
                return -1;
            }
            return 0;
        }
    }
}

