/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.streamhist;

import java.io.IOException;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.io.ISerializer;
import org.apache.cassandra.io.sstable.format.Version;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.utils.streamhist.HistogramDataConsumer;
import org.apache.cassandra.utils.streamhist.StreamingTombstoneHistogramBuilder;

public class TombstoneHistogram {
    private final StreamingTombstoneHistogramBuilder.DataHolder bin;

    TombstoneHistogram(StreamingTombstoneHistogramBuilder.DataHolder holder) {
        this.bin = new StreamingTombstoneHistogramBuilder.DataHolder(holder);
    }

    public static TombstoneHistogram createDefault() {
        return new TombstoneHistogram(new StreamingTombstoneHistogramBuilder.DataHolder(0, 1));
    }

    public double sum(double b) {
        return this.bin.sum((int)b);
    }

    public int size() {
        return this.bin.size();
    }

    public <E extends Exception> void forEach(HistogramDataConsumer<E> histogramDataConsumer) throws E {
        this.bin.forEach(histogramDataConsumer);
    }

    public static HistogramSerializer getSerializer(Version version) {
        return version.hasUIntDeletionTime() ? HistogramSerializer.instance : LegacyHistogramSerializer.instance;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TombstoneHistogram)) {
            return false;
        }
        TombstoneHistogram that = (TombstoneHistogram)o;
        return this.bin.equals(that.bin);
    }

    public int hashCode() {
        return this.bin.hashCode();
    }

    public static class LegacyHistogramSerializer
    extends HistogramSerializer {
        public static final LegacyHistogramSerializer instance = new LegacyHistogramSerializer();

        @Override
        public void serialize(TombstoneHistogram histogram, DataOutputPlus out) throws IOException {
            int size;
            int maxBinSize = size = histogram.size();
            out.writeInt(maxBinSize);
            out.writeInt(size);
            histogram.forEach((point, value) -> {
                out.writeDouble(point);
                out.writeLong(value);
            });
        }

        @Override
        public TombstoneHistogram deserialize(DataInputPlus in) throws IOException {
            in.readInt();
            int size = in.readInt();
            StreamingTombstoneHistogramBuilder.DataHolder dataHolder = new StreamingTombstoneHistogramBuilder.DataHolder(size, 1);
            for (int i = 0; i < size; ++i) {
                int localDeletionTime = LegacyHistogramSerializer.saturatingCastToLegacyMaxDeletionTime((long)in.readDouble());
                int count = StreamingTombstoneHistogramBuilder.saturatingCastToInt(in.readLong());
                dataHolder.addValue(localDeletionTime, count);
            }
            return new TombstoneHistogram(dataHolder);
        }

        @Override
        public long serializedSize(TombstoneHistogram histogram) {
            int maxBinSize = 0;
            long size = TypeSizes.sizeof(maxBinSize);
            int histSize = histogram.size();
            size += (long)TypeSizes.sizeof(histSize);
            return size += (long)histSize * 16L;
        }

        private static int saturatingCastToLegacyMaxDeletionTime(long value) {
            return value < 0L || value > 0x7FFFFFFEL ? 0x7FFFFFFE : (int)value;
        }
    }

    public static class HistogramSerializer
    implements ISerializer<TombstoneHistogram> {
        public static final HistogramSerializer instance = new HistogramSerializer();

        @Override
        public void serialize(TombstoneHistogram histogram, DataOutputPlus out) throws IOException {
            int size;
            int maxBinSize = size = histogram.size();
            out.writeInt(maxBinSize);
            out.writeInt(size);
            histogram.forEach((point, value) -> {
                out.writeLong(point);
                out.writeInt(value);
            });
        }

        @Override
        public TombstoneHistogram deserialize(DataInputPlus in) throws IOException {
            in.readInt();
            int size = in.readInt();
            StreamingTombstoneHistogramBuilder.DataHolder dataHolder = new StreamingTombstoneHistogramBuilder.DataHolder(size, 1);
            for (int i = 0; i < size; ++i) {
                long localDeletionTime = StreamingTombstoneHistogramBuilder.saturatingCastToMaxDeletionTime(in.readLong());
                int count = StreamingTombstoneHistogramBuilder.saturatingCastToInt(in.readInt());
                dataHolder.addValue(localDeletionTime, count);
            }
            return new TombstoneHistogram(dataHolder);
        }

        @Override
        public long serializedSize(TombstoneHistogram histogram) {
            int maxBinSize = 0;
            long size = TypeSizes.sizeof(maxBinSize);
            int histSize = histogram.size();
            size += (long)TypeSizes.sizeof(histSize);
            return size += (long)histSize * 16L;
        }
    }
}

