/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.io.ByteStreams;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.cassandra.stress.report.StressMetrics;
import org.apache.cassandra.stress.settings.StressSettings;
import org.apache.cassandra.utils.JsonUtils;
import org.apache.commons.lang3.StringUtils;

public class StressGraph {
    private StressSettings stressSettings;
    private String[] stressArguments;

    public StressGraph(StressSettings stressSetttings, String[] stressArguments) {
        this.stressSettings = stressSetttings;
        this.stressArguments = stressArguments;
    }

    public void generateGraph() {
        ObjectNode stats;
        File htmlFile = new File(this.stressSettings.graph.file);
        if (htmlFile.isFile()) {
            try {
                String html = new String(Files.readAllBytes(Paths.get(htmlFile.toURI())), StandardCharsets.UTF_8);
                stats = this.parseExistingStats(html);
            }
            catch (IOException e) {
                throw new RuntimeException("Couldn't load existing stats html.");
            }
            stats = this.createJSONStats(stats);
        } else {
            stats = this.createJSONStats(null);
        }
        try {
            PrintWriter out = new PrintWriter(htmlFile);
            String statsBlock = "/* stats start */\nstats = " + JsonUtils.writeAsJsonString((Object)stats) + ";\n/* stats end */\n";
            String html = this.getGraphHTML().replaceFirst("/\\* stats start \\*/\n\n/\\* stats end \\*/\n", statsBlock);
            out.write(html);
            out.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't write stats html.");
        }
    }

    private ObjectNode parseExistingStats(String html) {
        Pattern pattern = Pattern.compile("(?s).*/\\* stats start \\*/\\nstats = (.*);\\n/\\* stats end \\*/.*");
        Matcher matcher = pattern.matcher(html);
        matcher.matches();
        try {
            return (ObjectNode)JsonUtils.JSON_OBJECT_MAPPER.readTree(matcher.group(1));
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't parser stats json: " + e.getMessage(), e);
        }
    }

    private String getGraphHTML() {
        String string;
        block8: {
            InputStream graphHTMLRes = StressGraph.class.getClassLoader().getResourceAsStream("org/apache/cassandra/stress/graph/graph.html");
            try {
                string = new String(ByteStreams.toByteArray((InputStream)graphHTMLRes));
                if (graphHTMLRes == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (graphHTMLRes != null) {
                        try {
                            graphHTMLRes.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            graphHTMLRes.close();
        }
        return string;
    }

    private ArrayNode parseLogStats(InputStream log, ArrayNode stats) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(log));
        ObjectNode json = JsonUtils.JSON_OBJECT_MAPPER.createObjectNode();
        ArrayNode intervals = JsonUtils.JSON_OBJECT_MAPPER.createArrayNode();
        boolean runningMultipleThreadCounts = false;
        String currentThreadCount = null;
        Pattern threadCountMessage = Pattern.compile("Running ([A-Z]+) with ([0-9]+) threads .*");
        ReadingMode mode = ReadingMode.START;
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                ArrayNode metrics;
                Matcher tc;
                if (line.startsWith("Thread count was not specified")) {
                    runningMultipleThreadCounts = true;
                }
                if (runningMultipleThreadCounts && (tc = threadCountMessage.matcher(line)).matches()) {
                    currentThreadCount = tc.group(2);
                }
                if (line.equals(StressMetrics.HEAD)) {
                    mode = ReadingMode.METRICS;
                    continue;
                }
                if (line.equals("Results:")) {
                    mode = ReadingMode.AGGREGATES;
                    continue;
                }
                if (mode == ReadingMode.AGGREGATES && line.equals("")) {
                    mode = ReadingMode.NEXTITERATION;
                } else if (line.equals("END") || line.equals("FAILURE")) break;
                if (mode == ReadingMode.METRICS) {
                    metrics = JsonUtils.JSON_OBJECT_MAPPER.createArrayNode();
                    String[] parts = line.split(",");
                    if (parts.length != StressMetrics.HEADMETRICS.length) continue;
                    String[] stringArray = parts;
                    int n = stringArray.length;
                    for (int i = 0; i < n; ++i) {
                        String m = stringArray[i];
                        try {
                            metrics.add(new BigDecimal(m.trim()));
                            continue;
                        }
                        catch (NumberFormatException e) {
                            metrics.addNull();
                        }
                    }
                    intervals.add((JsonNode)metrics);
                    continue;
                }
                if (mode == ReadingMode.AGGREGATES) {
                    String[] parts = line.split(":", 2);
                    if (parts.length != 2) continue;
                    json.put(parts[0].trim().toLowerCase(), parts[1].trim());
                    continue;
                }
                if (mode != ReadingMode.NEXTITERATION) continue;
                metrics = json.putArray("metrics");
                for (String metric : StressMetrics.HEADMETRICS) {
                    metrics.add(metric);
                }
                json.put("test", this.stressSettings.graph.operation);
                if (currentThreadCount == null) {
                    json.put("revision", this.stressSettings.graph.revision);
                } else {
                    json.put("revision", String.format("%s - %s threads", this.stressSettings.graph.revision, currentThreadCount));
                }
                String command = StringUtils.join((Object[])this.stressArguments, (String)" ").replaceAll("password=.*? ", "password=******* ");
                json.put("command", command);
                json.set("intervals", (JsonNode)intervals);
                stats.add((JsonNode)json);
                json = JsonUtils.JSON_OBJECT_MAPPER.createObjectNode();
                intervals = JsonUtils.JSON_OBJECT_MAPPER.createArrayNode();
                mode = ReadingMode.START;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't read from temporary stress log file");
        }
        if (json.size() != 0) {
            stats.add((JsonNode)json);
        }
        return stats;
    }

    private ObjectNode createJSONStats(ObjectNode json) {
        ObjectNode objectNode;
        block10: {
            InputStream logStream = Files.newInputStream(this.stressSettings.graph.temporaryLogFile.toPath(), new OpenOption[0]);
            try {
                ArrayNode stats;
                if (json == null) {
                    json = JsonUtils.JSON_OBJECT_MAPPER.createObjectNode();
                    stats = JsonUtils.JSON_OBJECT_MAPPER.createArrayNode();
                } else {
                    stats = (ArrayNode)json.get("stats");
                }
                stats = this.parseLogStats(logStream, stats);
                json.put("title", this.stressSettings.graph.title);
                json.set("stats", (JsonNode)stats);
                objectNode = json;
                if (logStream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (logStream != null) {
                        try {
                            logStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            logStream.close();
        }
        return objectNode;
    }

    private static enum ReadingMode {
        START,
        METRICS,
        AGGREGATES,
        NEXTITERATION;

    }
}

