/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.threads.internal;

import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.threads.CoreEventLoop;
import net.openhft.chronicle.threads.ThreadHolder;

public class EventLoopThreadHolder
implements ThreadHolder {
    private final CoreEventLoop eventLoop;
    private final long monitorIntervalNS;
    private long intervalToAddNS;
    private long printBlockTimeNS;

    public EventLoopThreadHolder(long monitorIntervalNS, CoreEventLoop eventLoop) {
        this.intervalToAddNS = this.printBlockTimeNS = monitorIntervalNS;
        this.monitorIntervalNS = this.printBlockTimeNS;
        this.eventLoop = eventLoop;
    }

    @Override
    public boolean isAlive() {
        return this.eventLoop.isAlive();
    }

    @Override
    public void reportFinished() {
        Jvm.warn().on(this.getClass(), "Monitoring a task which has finished " + this.eventLoop);
    }

    @Override
    public long startedNS() {
        return this.eventLoop.loopStartNS();
    }

    @Override
    public void resetTimers() {
        this.intervalToAddNS = this.printBlockTimeNS = this.monitorIntervalNS;
    }

    @Override
    public boolean shouldLog(long nowNS) {
        long blockingTimeNS = nowNS - this.startedNS();
        return blockingTimeNS >= this.printBlockTimeNS;
    }

    @Override
    public void dumpThread(long startedNS, long nowNS) {
        long blockingTimeNS = nowNS - startedNS;
        this.eventLoop.dumpRunningState(this.eventLoop.name() + " thread has blocked for " + (double)(blockingTimeNS / 100000L) / 10.0 + " ms.", () -> this.eventLoop.loopStartNS() == startedNS);
        this.printBlockTimeNS += this.intervalToAddNS;
        this.intervalToAddNS = (long)Math.min(1.41 * (double)this.intervalToAddNS, 20.0 * (double)this.monitorIntervalNS);
    }

    @Override
    public long timingTolerance() {
        return this.monitorIntervalNS + this.timingError();
    }

    protected long timingError() {
        return TIMING_ERROR;
    }

    @Override
    public String getName() {
        return this.eventLoop.name();
    }

    @Override
    public void monitorThreadDelayed(long actionCallDelayNS) {
    }
}

