/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.auth;

import com.google.common.annotations.VisibleForTesting;
import java.io.InputStream;
import java.net.InetAddress;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.cassandra.auth.AuthConfig;
import org.apache.cassandra.auth.IInternodeAuthenticator;
import org.apache.cassandra.auth.MutualTlsCertificateValidator;
import org.apache.cassandra.config.Config;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.EncryptionOptions;
import org.apache.cassandra.config.ParameterizedClass;
import org.apache.cassandra.exceptions.AuthenticationException;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.utils.NoSpamLogger;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MutualTlsInternodeAuthenticator
implements IInternodeAuthenticator {
    private static final String VALIDATOR_CLASS_NAME = "validator_class_name";
    private static final String TRUSTED_PEER_IDENTITIES = "trusted_peer_identities";
    private static final String NODE_IDENTITY = "node_identity";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final NoSpamLogger noSpamLogger = NoSpamLogger.getLogger(this.logger, 30L, TimeUnit.SECONDS);
    private final MutualTlsCertificateValidator certificateValidator;
    private final List<String> trustedIdentities;

    public MutualTlsInternodeAuthenticator(Map<String, String> parameters) {
        String certificateValidatorClassName = parameters.get(VALIDATOR_CLASS_NAME);
        if (StringUtils.isEmpty((CharSequence)certificateValidatorClassName)) {
            String message = "internode_authenticator.parameters.validator_class_name is not set";
            this.logger.error(message);
            throw new ConfigurationException(message);
        }
        this.certificateValidator = (MutualTlsCertificateValidator)ParameterizedClass.newInstance(new ParameterizedClass(certificateValidatorClassName), Arrays.asList("", AuthConfig.class.getPackage().getName()));
        Config config = DatabaseDescriptor.getRawConfig();
        this.checkInternodeMtlsConfigurationIsValid(config);
        if (parameters.containsKey(TRUSTED_PEER_IDENTITIES)) {
            this.trustedIdentities = Arrays.stream(parameters.get(TRUSTED_PEER_IDENTITIES).split(",")).collect(Collectors.toList());
        } else {
            this.trustedIdentities = this.getIdentitiesFromKeyStore(config.server_encryption_options.outbound_keystore, config.server_encryption_options.outbound_keystore_password, config.server_encryption_options.store_type);
            if (parameters.containsKey(NODE_IDENTITY)) {
                String nodeIdentity = parameters.get(NODE_IDENTITY);
                if (!this.trustedIdentities.contains(nodeIdentity)) {
                    throw new ConfigurationException("Configured node identity is not matching identity extractedfrom the keystore");
                }
                this.trustedIdentities.retainAll(Collections.singleton(nodeIdentity));
            }
        }
        if (this.trustedIdentities.isEmpty()) {
            String message = String.format("No identity was extracted from the outbound keystore '%s'", config.server_encryption_options.outbound_keystore);
            this.logger.info(message);
            throw new ConfigurationException(message);
        }
        this.logger.info("Initializing internode authenticator with identities {}", this.trustedIdentities);
    }

    @Override
    public boolean authenticate(InetAddress remoteAddress, int remotePort) {
        throw new UnsupportedOperationException("mTLS Authenticator only supports certificate based authenticate method");
    }

    @Override
    public boolean authenticate(InetAddress remoteAddress, int remotePort, Certificate[] certificates, IInternodeAuthenticator.InternodeConnectionDirection connectionType) {
        return this.authenticateInternodeWithMtls(remoteAddress, remotePort, certificates, connectionType);
    }

    @Override
    public void validateConfiguration() throws ConfigurationException {
    }

    protected boolean authenticateInternodeWithMtls(InetAddress remoteAddress, int remotePort, Certificate[] certificates, IInternodeAuthenticator.InternodeConnectionDirection connectionType) {
        if (connectionType == IInternodeAuthenticator.InternodeConnectionDirection.INBOUND) {
            String identity = this.certificateValidator.identity(certificates);
            if (!this.certificateValidator.isValidCertificate(certificates)) {
                this.noSpamLogger.error("Not a valid certificate from {}:{} with identity '{}'", remoteAddress, remotePort, identity);
                return false;
            }
            if (!this.trustedIdentities.contains(identity)) {
                this.noSpamLogger.error("Unable to authenticate user {}", identity);
                return false;
            }
            return true;
        }
        return true;
    }

    @VisibleForTesting
    List<String> getIdentitiesFromKeyStore(String outboundKeyStorePath, String outboundKeyStorePassword, String storeType) {
        ArrayList<String> allUsers = new ArrayList<String>();
        try (InputStream ksf = Files.newInputStream(Paths.get(outboundKeyStorePath, new String[0]), new OpenOption[0]);){
            KeyStore ks = KeyStore.getInstance(storeType);
            ks.load(ksf, outboundKeyStorePassword.toCharArray());
            Enumeration<String> enumeration = ks.aliases();
            while (enumeration.hasMoreElements()) {
                String alias = enumeration.nextElement();
                Certificate[] chain = ks.getCertificateChain(alias);
                if (chain == null) {
                    this.logger.warn("Full chain/private key is not present in the keystore for certificate {}", (Object)alias);
                    continue;
                }
                try {
                    allUsers.add(this.certificateValidator.identity(chain));
                }
                catch (AuthenticationException authenticationException) {}
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to get identities from outbound_keystore {}", (Object)outboundKeyStorePath, (Object)e);
        }
        return allUsers;
    }

    private void checkInternodeMtlsConfigurationIsValid(Config config) {
        if (config.server_encryption_options.internode_encryption == EncryptionOptions.ServerEncryptionOptions.InternodeEncryption.none || !config.server_encryption_options.require_client_auth) {
            String msg = "MutualTlsInternodeAuthenticator requires server_encryption_options.internode_encryption to be enabled & server_encryption_options.require_client_auth to be true";
            this.logger.error(msg);
            throw new ConfigurationException(msg);
        }
    }
}

