/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.selection;

import com.google.common.collect.BoundType;
import com.google.common.collect.Range;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.UserType;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.serializers.CollectionSerializer;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.utils.ByteBufferUtil;

abstract class ColumnTimestamps {
    protected final TimestampsType type;
    static final ColumnTimestamps NO_TIMESTAMP = new ColumnTimestamps(null){

        @Override
        public ColumnTimestamps get(int index) {
            return this;
        }

        @Override
        public ColumnTimestamps max() {
            return this;
        }

        @Override
        public ColumnTimestamps slice(Range<Integer> range) {
            return this;
        }

        @Override
        public ByteBuffer toByteBuffer(ProtocolVersion protocolVersion) {
            return null;
        }

        @Override
        public void addNoTimestamp() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addTimestampFrom(Cell<?> cell, long nowInSecond) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return "no timestamp";
        }
    };

    protected ColumnTimestamps(TimestampsType type) {
        this.type = type;
    }

    public TimestampsType type() {
        return this.type;
    }

    public abstract ColumnTimestamps get(int var1);

    public abstract ColumnTimestamps max();

    public abstract ColumnTimestamps slice(Range<Integer> var1);

    public abstract ByteBuffer toByteBuffer(ProtocolVersion var1);

    public abstract void addNoTimestamp();

    public abstract void addTimestampFrom(Cell<?> var1, long var2);

    static ColumnTimestamps newTimestamps(TimestampsType timestampType, AbstractType<?> columnType) {
        if (!columnType.isMultiCell()) {
            return new SingleTimestamps(timestampType);
        }
        if (columnType instanceof UserType) {
            return new MultipleTimestamps(timestampType, ((UserType)columnType).size());
        }
        return new MultipleTimestamps(timestampType, 0);
    }

    private static final class MultipleTimestamps
    extends ColumnTimestamps {
        private final List<Long> timestamps;

        public MultipleTimestamps(TimestampsType type, int initialCapacity) {
            this(type, new ArrayList<Long>(initialCapacity));
        }

        public MultipleTimestamps(TimestampsType type, List<Long> timestamps) {
            super(type);
            this.timestamps = timestamps;
        }

        @Override
        public void addNoTimestamp() {
            this.timestamps.add(this.type.defaultValue());
        }

        @Override
        public void addTimestampFrom(Cell<?> cell, long nowInSecond) {
            this.timestamps.add(this.type.getTimestamp(cell, nowInSecond));
        }

        @Override
        public ColumnTimestamps get(int index) {
            return this.timestamps.isEmpty() ? NO_TIMESTAMP : new SingleTimestamps(this.type, this.timestamps.get(index));
        }

        @Override
        public ColumnTimestamps max() {
            return this.timestamps.isEmpty() ? NO_TIMESTAMP : new SingleTimestamps(this.type, Collections.max(this.timestamps));
        }

        @Override
        public ColumnTimestamps slice(Range<Integer> range) {
            if (range.isEmpty()) {
                return NO_TIMESTAMP;
            }
            int from = 0;
            if (range.hasLowerBound()) {
                from = range.lowerBoundType() == BoundType.CLOSED ? (Integer)range.lowerEndpoint() : (Integer)range.lowerEndpoint() + 1;
            }
            int to = this.timestamps.size();
            if (range.hasUpperBound()) {
                to = range.upperBoundType() == BoundType.CLOSED ? (Integer)range.upperEndpoint() + 1 : (Integer)range.upperEndpoint();
            }
            return new MultipleTimestamps(this.type, this.timestamps.subList(from, to));
        }

        @Override
        public ByteBuffer toByteBuffer(ProtocolVersion protocolVersion) {
            if (this.timestamps.isEmpty()) {
                return null;
            }
            ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>(this.timestamps.size());
            this.timestamps.forEach(timestamp -> buffers.add(this.type.toByteBuffer((long)timestamp)));
            return CollectionSerializer.pack(buffers, this.timestamps.size());
        }

        public String toString() {
            return this.type + ": " + this.timestamps;
        }
    }

    private static class SingleTimestamps
    extends ColumnTimestamps {
        protected long timestamp;

        public SingleTimestamps(TimestampsType type) {
            this(type, type.defaultValue());
        }

        public SingleTimestamps(TimestampsType type, long timestamp) {
            super(type);
            this.timestamp = timestamp;
        }

        @Override
        public void addNoTimestamp() {
            this.timestamp = this.type.defaultValue();
        }

        @Override
        public void addTimestampFrom(Cell<?> cell, long nowInSecond) {
            this.timestamp = this.type.getTimestamp(cell, nowInSecond);
        }

        @Override
        public ColumnTimestamps get(int index) {
            return this;
        }

        @Override
        public ColumnTimestamps max() {
            return this;
        }

        @Override
        public ColumnTimestamps slice(Range<Integer> range) {
            return range.isEmpty() ? NO_TIMESTAMP : this;
        }

        @Override
        public ByteBuffer toByteBuffer(ProtocolVersion protocolVersion) {
            return this.timestamp == this.type.defaultValue() ? null : this.type.toByteBuffer(this.timestamp);
        }

        public String toString() {
            return this.type + ": " + this.timestamp;
        }
    }

    public static enum TimestampsType {
        WRITETIMES{

            @Override
            long getTimestamp(Cell<?> cell, long nowInSecond) {
                return cell.timestamp();
            }

            @Override
            long defaultValue() {
                return Long.MIN_VALUE;
            }

            @Override
            ByteBuffer toByteBuffer(long timestamp) {
                return timestamp == this.defaultValue() ? null : ByteBufferUtil.bytes(timestamp);
            }
        }
        ,
        TTLS{

            @Override
            long getTimestamp(Cell<?> cell, long nowInSecond) {
                if (!cell.isExpiring()) {
                    return this.defaultValue();
                }
                long remaining = cell.localDeletionTime() - nowInSecond;
                return remaining >= 0L ? remaining : this.defaultValue();
            }

            @Override
            long defaultValue() {
                return -1L;
            }

            @Override
            ByteBuffer toByteBuffer(long timestamp) {
                return timestamp == this.defaultValue() ? null : ByteBufferUtil.bytes((int)timestamp);
            }
        };


        abstract long getTimestamp(Cell<?> var1, long var2);

        abstract long defaultValue();

        abstract ByteBuffer toByteBuffer(long var1);
    }
}

