/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.tries;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.Function;
import org.agrona.concurrent.UnsafeBuffer;
import org.apache.cassandra.db.tries.Trie;
import org.apache.cassandra.db.tries.TrieDumper;
import org.apache.cassandra.utils.bytecomparable.ByteComparable;
import org.apache.cassandra.utils.bytecomparable.ByteSource;

public class InMemoryReadTrie<T>
extends Trie<T> {
    static final int BLOCK_SIZE = 32;
    static final int LAST_POINTER_OFFSET = 28;
    static final int SPLIT_OFFSET = 28;
    static final int SPARSE_OFFSET = 30;
    static final int CHAIN_MIN_OFFSET = 0;
    static final int CHAIN_MAX_OFFSET = 27;
    static final int PREFIX_OFFSET = 31;
    static final int SPLIT_START_LEVEL_LIMIT = 4;
    static final int SPLIT_OTHER_LEVEL_LIMIT = 8;
    static final int SPLIT_LEVEL_SHIFT = 3;
    static final int SPARSE_CHILD_COUNT = 6;
    static final int SPARSE_CHILDREN_OFFSET = -30;
    static final int SPARSE_BYTES_OFFSET = -6;
    static final int SPARSE_ORDER_OFFSET = 0;
    static final int PREFIX_FLAGS_OFFSET = -27;
    static final int PREFIX_CONTENT_OFFSET = -31;
    static final int PREFIX_POINTER_OFFSET = -3;
    static final int NONE = 0;
    volatile int root;
    static final int BUF_START_SHIFT = 8;
    static final int BUF_START_SIZE = 256;
    static final int CONTENTS_START_SHIFT = 4;
    static final int CONTENTS_START_SIZE = 16;
    final UnsafeBuffer[] buffers;
    final AtomicReferenceArray<T>[] contentArrays;

    InMemoryReadTrie(UnsafeBuffer[] buffers, AtomicReferenceArray<T>[] contentArrays, int root) {
        this.buffers = buffers;
        this.contentArrays = contentArrays;
        this.root = root;
    }

    int getChunkIdx(int pos, int minChunkShift, int minChunkSize) {
        return 31 - minChunkShift - Integer.numberOfLeadingZeros(pos + minChunkSize);
    }

    int inChunkPointer(int pos, int chunkIndex, int minChunkSize) {
        return pos + minChunkSize - (minChunkSize << chunkIndex);
    }

    UnsafeBuffer getChunk(int pos) {
        int leadBit = this.getChunkIdx(pos, 8, 256);
        return this.buffers[leadBit];
    }

    int inChunkPointer(int pos) {
        int leadBit = this.getChunkIdx(pos, 8, 256);
        return this.inChunkPointer(pos, leadBit, 256);
    }

    int offset(int pos) {
        return pos & 0x1F;
    }

    final int getUnsignedByte(int pos) {
        return this.getChunk(pos).getByte(this.inChunkPointer(pos)) & 0xFF;
    }

    final int getUnsignedShort(int pos) {
        return this.getChunk(pos).getShort(this.inChunkPointer(pos)) & 0xFFFF;
    }

    final int getInt(int pos) {
        return this.getChunk(pos).getInt(this.inChunkPointer(pos));
    }

    T getContent(int index) {
        int leadBit = this.getChunkIdx(index, 4, 16);
        int ofs = this.inChunkPointer(index, leadBit, 16);
        AtomicReferenceArray<T> array = this.contentArrays[leadBit];
        return array.get(ofs);
    }

    boolean isNull(int node) {
        return node == 0;
    }

    boolean isLeaf(int node) {
        return node < 0;
    }

    boolean isNullOrLeaf(int node) {
        return node <= 0;
    }

    private int chainBlockLength(int node) {
        return 28 - this.offset(node);
    }

    int getChild(int node, int trans) {
        if (this.isNullOrLeaf(node)) {
            return 0;
        }
        node = this.followContentTransition(node);
        switch (this.offset(node)) {
            case 30: {
                return this.getSparseChild(node, trans);
            }
            case 28: {
                return this.getSplitChild(node, trans);
            }
            case 27: {
                if (trans != this.getUnsignedByte(node)) {
                    return 0;
                }
                return this.getInt(node + 1);
            }
        }
        if (trans != this.getUnsignedByte(node)) {
            return 0;
        }
        return node + 1;
    }

    protected int followContentTransition(int node) {
        if (this.isNullOrLeaf(node)) {
            return 0;
        }
        if (this.offset(node) == 31) {
            int b = this.getUnsignedByte(node + -27);
            node = b < 32 ? node - 31 + b : this.getInt(node + -3);
            assert (node >= 0 && this.offset(node) != 31);
        }
        return node;
    }

    int advance(int node, int first, ByteSource rest) {
        if (this.isNullOrLeaf(node)) {
            return 0;
        }
        node = this.followContentTransition(node);
        switch (this.offset(node)) {
            case 30: {
                return this.getSparseChild(node, first);
            }
            case 28: {
                return this.getSplitChild(node, first);
            }
        }
        if (this.getUnsignedByte(node++) != first) {
            return 0;
        }
        for (int length = this.chainBlockLength(node); length > 0; --length) {
            first = rest.next();
            if (this.getUnsignedByte(node++) == first) continue;
            return 0;
        }
        return this.getInt(node);
    }

    int getSparseChild(int node, int trans) {
        for (int i = 0; i < 6; ++i) {
            int child;
            if (this.getUnsignedByte(node + -6 + i) != trans || (child = this.getInt(node + -30 + i * 4)) == 0 || this.getUnsignedByte(node + -6 + i) != trans) continue;
            return child;
        }
        return 0;
    }

    int splitNodeMidIndex(int trans) {
        return trans >> 6 & 3;
    }

    int splitNodeTailIndex(int trans) {
        return trans >> 3 & 7;
    }

    int splitNodeChildIndex(int trans) {
        return trans & 7;
    }

    int getSplitChild(int node, int trans) {
        int mid = this.getSplitBlockPointer(node, this.splitNodeMidIndex(trans), 4);
        if (this.isNull(mid)) {
            return 0;
        }
        int tail = this.getSplitBlockPointer(mid, this.splitNodeTailIndex(trans), 8);
        if (this.isNull(tail)) {
            return 0;
        }
        return this.getSplitBlockPointer(tail, this.splitNodeChildIndex(trans), 8);
    }

    T getNodeContent(int node) {
        if (this.isLeaf(node)) {
            return this.getContent(~node);
        }
        if (this.offset(node) != 31) {
            return null;
        }
        int index = this.getInt(node + -31);
        return index >= 0 ? (T)this.getContent(index) : null;
    }

    int splitBlockPointerAddress(int node, int childIndex, int subLevelLimit) {
        return node - 28 + (8 - subLevelLimit + childIndex) * 4;
    }

    int getSplitBlockPointer(int node, int childIndex, int subLevelLimit) {
        return this.getInt(this.splitBlockPointerAddress(node, childIndex, subLevelLimit));
    }

    private boolean isChainNode(int node) {
        return !this.isNullOrLeaf(node) && this.offset(node) <= 27;
    }

    public MemtableCursor cursor() {
        return new MemtableCursor();
    }

    public T get(ByteComparable path) {
        int n = this.root;
        ByteSource source = path.asComparableBytes(BYTE_COMPARABLE_VERSION);
        while (!this.isNull(n)) {
            int c = source.next();
            if (c == -1) {
                return this.getNodeContent(n);
            }
            n = this.advance(n, c, source);
        }
        return null;
    }

    public boolean isEmpty() {
        return this.isNull(this.root);
    }

    @Override
    public String dump(final Function<T, String> contentToString) {
        final MemtableCursor source = this.cursor();
        class TypedNodesCursor
        implements Trie.Cursor<String> {
            TypedNodesCursor() {
            }

            @Override
            public int advance() {
                return source.advance();
            }

            @Override
            public int advanceMultiple(Trie.TransitionsReceiver receiver) {
                return source.advanceMultiple(receiver);
            }

            @Override
            public int skipChildren() {
                return source.skipChildren();
            }

            @Override
            public int depth() {
                return source.depth();
            }

            @Override
            public int incomingTransition() {
                return source.incomingTransition();
            }

            @Override
            public String content() {
                Object content;
                String type = null;
                int node = source.currentNode;
                if (!InMemoryReadTrie.this.isNullOrLeaf(node)) {
                    switch (InMemoryReadTrie.this.offset(node)) {
                        case 30: {
                            type = "[SPARSE]";
                            break;
                        }
                        case 28: {
                            type = "[SPLIT]";
                            break;
                        }
                        case 31: {
                            throw new AssertionError((Object)"Unexpected prefix as cursor currentNode.");
                        }
                        default: {
                            type = "[CHAIN]";
                        }
                    }
                }
                if ((content = source.content()) != null) {
                    if (type != null) {
                        return (String)contentToString.apply(content) + " -> " + type;
                    }
                    return (String)contentToString.apply(content);
                }
                return type;
            }
        }
        return (String)InMemoryReadTrie.process(new TrieDumper(Function.identity()), new TypedNodesCursor());
    }

    class MemtableCursor
    extends CursorBacktrackingState
    implements Trie.Cursor<T> {
        private int currentNode;
        private int incomingTransition;
        private T content;
        private int depth = -1;

        MemtableCursor() {
            this.descendInto(InMemoryReadTrie.this.root, -1);
        }

        @Override
        public int advance() {
            if (InMemoryReadTrie.this.isNullOrLeaf(this.currentNode)) {
                return this.backtrack();
            }
            return this.advanceToFirstChild(this.currentNode);
        }

        @Override
        public int advanceMultiple(Trie.TransitionsReceiver receiver) {
            int node = this.currentNode;
            if (!InMemoryReadTrie.this.isChainNode(node)) {
                return this.advance();
            }
            UnsafeBuffer chunk = InMemoryReadTrie.this.getChunk(node);
            int inChunkNode = InMemoryReadTrie.this.inChunkPointer(node);
            int bytesJumped = InMemoryReadTrie.this.chainBlockLength(node) - 1;
            if (receiver != null && bytesJumped > 0) {
                receiver.addPathBytes(chunk, inChunkNode, bytesJumped);
            }
            this.depth += bytesJumped;
            inChunkNode += bytesJumped;
            int transition = chunk.getByte(inChunkNode++) & 0xFF;
            int child = chunk.getInt(inChunkNode);
            return this.descendInto(child, transition);
        }

        @Override
        public int skipChildren() {
            return this.backtrack();
        }

        @Override
        public int depth() {
            return this.depth;
        }

        @Override
        public T content() {
            return this.content;
        }

        @Override
        public int incomingTransition() {
            return this.incomingTransition;
        }

        private int backtrack() {
            if (--this.backtrackDepth < 0) {
                this.depth = -1;
                return -1;
            }
            this.depth = this.depth(this.backtrackDepth);
            return this.advanceToNextChild(this.node(this.backtrackDepth), this.data(this.backtrackDepth));
        }

        private int advanceToFirstChild(int node) {
            assert (!InMemoryReadTrie.this.isNullOrLeaf(node));
            switch (InMemoryReadTrie.this.offset(node)) {
                case 28: {
                    return this.descendInSplitSublevel(node, 4, 0, 6);
                }
                case 30: {
                    return this.nextValidSparseTransition(node, InMemoryReadTrie.this.getUnsignedShort(node + 0));
                }
            }
            return this.getChainTransition(node);
        }

        private int advanceToNextChild(int node, int data) {
            assert (!InMemoryReadTrie.this.isNullOrLeaf(node));
            switch (InMemoryReadTrie.this.offset(node)) {
                case 28: {
                    return this.nextValidSplitTransition(node, data);
                }
                case 30: {
                    return this.nextValidSparseTransition(node, data);
                }
            }
            throw new AssertionError((Object)"Unexpected node type in backtrack state.");
        }

        private int descendInSplitSublevel(int node, int limit, int collected, int shift) {
            while (true) {
                int childIndex;
                assert (InMemoryReadTrie.this.offset(node) == 28);
                int child = 0;
                for (childIndex = 0; childIndex < limit && InMemoryReadTrie.this.isNull(child = InMemoryReadTrie.this.getSplitBlockPointer(node, childIndex, limit)); ++childIndex) {
                }
                assert (childIndex < limit && child != 0);
                this.maybeAddSplitBacktrack(node, childIndex, limit, collected, shift);
                collected |= childIndex << shift;
                if (shift == 0) {
                    return this.descendInto(child, collected);
                }
                node = child;
                limit = 8;
                shift -= 3;
            }
        }

        private int nextValidSplitTransition(int node, int trans) {
            assert (trans >= 0 && trans <= 255);
            int childIndex = InMemoryReadTrie.this.splitNodeChildIndex(trans);
            if (childIndex > 0) {
                this.maybeAddSplitBacktrack(node, childIndex, 8, trans & 0xFFFFFFF8, 0);
                int child = InMemoryReadTrie.this.getSplitBlockPointer(node, childIndex, 8);
                return this.descendInto(child, trans);
            }
            int tailIndex = InMemoryReadTrie.this.splitNodeTailIndex(trans);
            if (tailIndex > 0) {
                this.maybeAddSplitBacktrack(node, tailIndex, 8, trans & 0xFFFFFFC0, 3);
                int tail = InMemoryReadTrie.this.getSplitBlockPointer(node, tailIndex, 8);
                return this.descendInSplitSublevel(tail, 8, trans, 0);
            }
            int midIndex = InMemoryReadTrie.this.splitNodeMidIndex(trans);
            assert (midIndex > 0);
            this.maybeAddSplitBacktrack(node, midIndex, 4, 0, 6);
            int mid = InMemoryReadTrie.this.getSplitBlockPointer(node, midIndex, 4);
            return this.descendInSplitSublevel(mid, 8, trans, 3);
        }

        private void maybeAddSplitBacktrack(int node, int startAfter, int limit, int collected, int shift) {
            int nextChildIndex;
            for (nextChildIndex = startAfter + 1; nextChildIndex < limit && InMemoryReadTrie.this.isNull(InMemoryReadTrie.this.getSplitBlockPointer(node, nextChildIndex, limit)); ++nextChildIndex) {
            }
            if (nextChildIndex < limit) {
                this.addBacktrack(node, collected | nextChildIndex << shift, this.depth);
            }
        }

        private int nextValidSparseTransition(int node, int data) {
            UnsafeBuffer chunk = InMemoryReadTrie.this.getChunk(node);
            int inChunkNode = InMemoryReadTrie.this.inChunkPointer(node);
            int index = data % 6;
            if ((data /= 6) > 0) {
                this.addBacktrack(node, data, this.depth);
            }
            int child = chunk.getInt(inChunkNode + -30 + index * 4);
            int transition = chunk.getByte(inChunkNode + -6 + index) & 0xFF;
            return this.descendInto(child, transition);
        }

        private int getChainTransition(int node) {
            UnsafeBuffer chunk = InMemoryReadTrie.this.getChunk(node);
            int inChunkNode = InMemoryReadTrie.this.inChunkPointer(node);
            int transition = chunk.getByte(inChunkNode) & 0xFF;
            int next = node + 1;
            if (InMemoryReadTrie.this.offset(next) <= 27) {
                return this.descendIntoChain(next, transition);
            }
            return this.descendInto(chunk.getInt(inChunkNode + 1), transition);
        }

        private int descendInto(int child, int transition) {
            ++this.depth;
            this.incomingTransition = transition;
            this.content = InMemoryReadTrie.this.getNodeContent(child);
            this.currentNode = InMemoryReadTrie.this.followContentTransition(child);
            return this.depth;
        }

        private int descendIntoChain(int child, int transition) {
            ++this.depth;
            this.incomingTransition = transition;
            this.content = null;
            this.currentNode = child;
            return this.depth;
        }
    }

    private static class CursorBacktrackingState {
        static final int BACKTRACK_INTS_PER_ENTRY = 3;
        static final int BACKTRACK_INITIAL_SIZE = 16;
        private int[] backtrack = new int[48];
        int backtrackDepth = 0;

        private CursorBacktrackingState() {
        }

        void addBacktrack(int node, int data, int depth) {
            if (this.backtrackDepth * 3 >= this.backtrack.length) {
                this.backtrack = Arrays.copyOf(this.backtrack, this.backtrack.length * 2);
            }
            this.backtrack[this.backtrackDepth * 3 + 0] = node;
            this.backtrack[this.backtrackDepth * 3 + 1] = data;
            this.backtrack[this.backtrackDepth * 3 + 2] = depth;
            ++this.backtrackDepth;
        }

        int node(int backtrackDepth) {
            return this.backtrack[backtrackDepth * 3 + 0];
        }

        int data(int backtrackDepth) {
            return this.backtrack[backtrackDepth * 3 + 1];
        }

        int depth(int backtrackDepth) {
            return this.backtrack[backtrackDepth * 3 + 2];
        }
    }
}

