/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.format;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.io.IOError;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.cassandra.db.ClusteringComparator;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.LivenessInfo;
import org.apache.cassandra.db.compaction.CompactionInfo;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.db.lifecycle.LifecycleTransaction;
import org.apache.cassandra.db.partitions.ImmutableBTreePartition;
import org.apache.cassandra.db.partitions.Partition;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.ColumnData;
import org.apache.cassandra.db.rows.ComplexColumnData;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.Rows;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.rows.UnfilteredRowIterators;
import org.apache.cassandra.db.rows.WrappingUnfilteredRowIterator;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.IScrubber;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.SSTableIdentityIterator;
import org.apache.cassandra.io.sstable.SSTableRewriter;
import org.apache.cassandra.io.sstable.format.SSTableFormat;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.format.SSTableReaderWithFilter;
import org.apache.cassandra.io.sstable.format.SSTableWriter;
import org.apache.cassandra.io.sstable.format.Version;
import org.apache.cassandra.io.sstable.metadata.StatsMetadata;
import org.apache.cassandra.io.util.File;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.utils.AbstractIterator;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.OutputHandler;
import org.apache.cassandra.utils.TimeUUID;
import org.apache.cassandra.utils.concurrent.Refs;
import org.apache.cassandra.utils.memory.HeapCloner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public abstract class SortedTableScrubber<R extends SSTableReaderWithFilter>
implements IScrubber {
    private static final Logger logger = LoggerFactory.getLogger(SortedTableScrubber.class);
    protected final ColumnFamilyStore cfs;
    protected final LifecycleTransaction transaction;
    protected final File destination;
    protected final IScrubber.Options options;
    protected final R sstable;
    protected final OutputHandler outputHandler;
    protected final boolean isCommutative;
    protected final long expectedBloomFilterSize;
    protected final ReadWriteLock fileAccessLock = new ReentrantReadWriteLock();
    protected final RandomAccessReader dataFile;
    protected final ScrubInfo scrubInfo;
    protected final NegativeLocalDeletionInfoMetrics negativeLocalDeletionInfoMetrics = new NegativeLocalDeletionInfoMetrics();
    private static final Comparator<Partition> partitionComparator = Comparator.comparing(Partition::partitionKey);
    protected final SortedSet<Partition> outOfOrder = new TreeSet<Partition>(partitionComparator);
    protected int goodPartitions;
    protected int badPartitions;
    protected int emptyPartitions;

    protected SortedTableScrubber(ColumnFamilyStore cfs, LifecycleTransaction transaction, OutputHandler outputHandler, IScrubber.Options options) {
        long approximateKeyCount;
        this.sstable = (SSTableReaderWithFilter)transaction.onlyOne();
        Preconditions.checkNotNull(((SSTable)this.sstable).metadata());
        assert (((SSTable)this.sstable).metadata().keyspace.equals(cfs.getKeyspaceName()));
        if (!((SSTableReaderWithFilter)this.sstable).descriptor.cfname.equals(cfs.metadata().name)) {
            logger.warn("Descriptor points to a different table {} than metadata {}", (Object)((SSTableReaderWithFilter)this.sstable).descriptor.cfname, (Object)cfs.metadata().name);
        }
        try {
            ((SSTable)this.sstable).metadata().validateCompatibility(cfs.metadata());
        }
        catch (ConfigurationException ex) {
            logger.warn("Descriptor points to a different table {} than metadata {}", (Object)((SSTableReaderWithFilter)this.sstable).descriptor.cfname, (Object)cfs.metadata().name);
        }
        this.cfs = cfs;
        this.transaction = transaction;
        this.outputHandler = outputHandler;
        this.options = options;
        this.destination = cfs.getDirectories().getLocationForDisk(cfs.getDiskBoundaries().getCorrectDiskForSSTable((SSTableReader)this.sstable));
        this.isCommutative = cfs.metadata().isCounter();
        List<SSTableReader> toScrub = Collections.singletonList(this.sstable);
        try {
            approximateKeyCount = SSTableReader.getApproximateKeyCount(toScrub);
        }
        catch (RuntimeException ex) {
            approximateKeyCount = 0L;
        }
        this.expectedBloomFilterSize = Math.max((long)cfs.metadata().params.minIndexInterval, approximateKeyCount);
        this.dataFile = transaction.isOffline() ? ((SSTableReader)this.sstable).openDataReader() : ((SSTableReader)this.sstable).openDataReader(CompactionManager.instance.getRateLimiter());
        this.scrubInfo = new ScrubInfo(this.dataFile, (SSTableReader)this.sstable, this.fileAccessLock.readLock());
        if (options.reinsertOverflowedTTLRows) {
            outputHandler.output("Starting scrub with reinsert overflowed TTL option");
        }
    }

    public static void deleteOrphanedComponents(Descriptor descriptor, Set<Component> components) {
        File dataFile = descriptor.fileFor(SSTableFormat.Components.DATA);
        if (components.contains(SSTableFormat.Components.DATA) && dataFile.length() > 0L) {
            return;
        }
        logger.warn("Removing orphans for {}: {}", (Object)descriptor, components);
        for (Component component : components) {
            File file = descriptor.fileFor(component);
            if (!file.exists()) continue;
            descriptor.fileFor(component).delete();
        }
    }

    @Override
    public void scrub() {
        ArrayList<SSTableReader> finished = new ArrayList<SSTableReader>();
        this.outputHandler.output("Scrubbing %s (%s)", this.sstable, FBUtilities.prettyPrintMemory(this.dataFile.length()));
        try (SSTableRewriter writer = SSTableRewriter.construct(this.cfs, this.transaction, false, ((SSTableReaderWithFilter)this.sstable).maxDataAge);
             Refs<R> refs = Refs.ref(Collections.singleton(this.sstable));){
            StatsMetadata metadata = ((SSTableReader)this.sstable).getSSTableMetadata();
            writer.switchWriter(CompactionManager.createWriter(this.cfs, this.destination, this.expectedBloomFilterSize, metadata.repairedAt, metadata.pendingRepair, metadata.isTransient, this.sstable, this.transaction));
            this.scrubInternal(writer);
            if (!this.outOfOrder.isEmpty()) {
                finished.add(this.writeOutOfOrderPartitions(metadata));
            }
            this.transaction.obsoleteOriginals();
            finished.addAll((Collection<SSTableReader>)writer.setRepairedAt(this.badPartitions > 0 ? 0L : ((SSTableReader)this.sstable).getSSTableMetadata().repairedAt).finish());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (this.transaction.isOffline()) {
                finished.forEach(sstable -> sstable.selfRef().release());
            }
        }
        this.outputSummary(finished);
    }

    protected abstract void scrubInternal(SSTableRewriter var1) throws IOException;

    private void outputSummary(List<SSTableReader> finished) {
        if (!finished.isEmpty()) {
            this.outputHandler.output("Scrub of %s complete: %d partitions in new sstable and %d empty (tombstoned) partitions dropped", this.sstable, this.goodPartitions, this.emptyPartitions);
            if (this.negativeLocalDeletionInfoMetrics.fixedRows > 0) {
                this.outputHandler.output("Fixed %d rows with overflowed local deletion time.", this.negativeLocalDeletionInfoMetrics.fixedRows);
            }
            if (this.badPartitions > 0) {
                this.outputHandler.warn("Unable to recover %d partitions that were skipped.  You can attempt manual recovery from the pre-scrub snapshot.  You can also run nodetool repair to transfer the data from a healthy replica, if any", this.badPartitions);
            }
        } else if (this.badPartitions > 0) {
            this.outputHandler.warn("No valid partitions found while scrubbing %s; it is marked for deletion now. If you want to attempt manual recovery, you can find a copy in the pre-scrub snapshot", this.sstable);
        } else {
            this.outputHandler.output("Scrub of %s complete; looks like all %d partitions were tombstoned", this.sstable, this.emptyPartitions);
        }
    }

    private SSTableReader writeOutOfOrderPartitions(StatsMetadata metadata) {
        SSTableReader newInOrderSstable;
        long repairedAt = this.badPartitions > 0 ? 0L : ((SSTableReader)this.sstable).getSSTableMetadata().repairedAt;
        try (SSTableWriter inOrderWriter = CompactionManager.createWriter(this.cfs, this.destination, this.expectedBloomFilterSize, repairedAt, metadata.pendingRepair, metadata.isTransient, this.sstable, this.transaction);){
            for (Partition partition : this.outOfOrder) {
                inOrderWriter.append(partition.unfilteredIterator());
            }
            inOrderWriter.setRepairedAt(-1L);
            inOrderWriter.setMaxDataAge(((SSTableReaderWithFilter)this.sstable).maxDataAge);
            newInOrderSstable = inOrderWriter.finish(true);
        }
        this.transaction.update(newInOrderSstable, false);
        this.outputHandler.warn("%d out of order partition (or partitions without of order rows) found while scrubbing %s; Those have been written (in order) to a new sstable (%s)", this.outOfOrder.size(), this.sstable, newInOrderSstable);
        return newInOrderSstable;
    }

    protected abstract UnfilteredRowIterator withValidation(UnfilteredRowIterator var1, String var2);

    @Override
    @VisibleForTesting
    public IScrubber.ScrubResult scrubWithResult() {
        this.scrub();
        return new IScrubber.ScrubResult(this.goodPartitions, this.badPartitions, this.emptyPartitions);
    }

    @Override
    public CompactionInfo.Holder getScrubInfo() {
        return this.scrubInfo;
    }

    protected String keyString(DecoratedKey key) {
        if (key == null) {
            return "(unknown)";
        }
        try {
            return this.cfs.metadata().partitionKeyType.getString(key.getKey());
        }
        catch (Exception e) {
            return String.format("(corrupted; hex value: %s)", ByteBufferUtil.bytesToHex(key.getKey()));
        }
    }

    protected boolean tryAppend(DecoratedKey prevKey, DecoratedKey key, SSTableRewriter writer) {
        try (OrderCheckerIterator sstableIterator = new OrderCheckerIterator(this.getIterator(key), this.cfs.metadata().comparator);
             UnfilteredRowIterator iterator = this.withValidation(sstableIterator, this.dataFile.getPath());){
            if (prevKey != null && prevKey.compareTo(key) > 0) {
                this.saveOutOfOrderPartition(prevKey, key, iterator);
                boolean bl = false;
                return bl;
            }
            if (writer.tryAppend(iterator) == null) {
                ++this.emptyPartitions;
            } else {
                ++this.goodPartitions;
            }
            if (sstableIterator.hasRowsOutOfOrder()) {
                this.outputHandler.warn("Out of order rows found in partition: %s", this.keyString(key));
                this.outOfOrder.add(sstableIterator.getRowsOutOfOrder());
            }
        }
        return true;
    }

    private UnfilteredRowIterator getIterator(DecoratedKey key) {
        RowMergingSSTableIterator rowMergingIterator = new RowMergingSSTableIterator(SSTableIdentityIterator.create(this.sstable, this.dataFile, key), this.outputHandler, ((SSTableReaderWithFilter)this.sstable).descriptor.version, this.options.reinsertOverflowedTTLRows);
        if (this.options.reinsertOverflowedTTLRows) {
            return new FixNegativeLocalDeletionTimeIterator(rowMergingIterator, this.outputHandler, this.negativeLocalDeletionInfoMetrics);
        }
        return rowMergingIterator;
    }

    private void saveOutOfOrderPartition(DecoratedKey prevKey, DecoratedKey key, UnfilteredRowIterator iterator) {
        this.outputHandler.warn("Out of order partition detected (%s found after %s)", this.keyString(key), this.keyString(prevKey));
        this.outOfOrder.add(ImmutableBTreePartition.create(iterator));
    }

    protected static void throwIfFatal(Throwable th) {
        if (th instanceof Error && !(th instanceof AssertionError) && !(th instanceof IOError)) {
            throw (Error)th;
        }
    }

    protected void throwIfCannotContinue(DecoratedKey key, Throwable th) {
        if (this.isCommutative && !this.options.skipCorrupted) {
            this.outputHandler.warn("An error occurred while scrubbing the partition with key '%s'.  Skipping corrupt data in counter tables will result in undercounts for the affected counters (see CASSANDRA-2759 for more details), so by default the scrub will stop at this point.  If you would like to skip the row anyway and continue scrubbing, re-run the scrub with the --skip-corrupted option.", this.keyString(key));
            throw new IOError(th);
        }
    }

    private static class NegativeLocalDeletionInfoMetrics {
        public volatile int fixedRows = 0;

        private NegativeLocalDeletionInfoMetrics() {
        }
    }

    private static final class FixNegativeLocalDeletionTimeIterator
    extends AbstractIterator<Unfiltered>
    implements WrappingUnfilteredRowIterator {
        private final UnfilteredRowIterator iterator;
        private final OutputHandler outputHandler;
        private final NegativeLocalDeletionInfoMetrics negativeLocalExpirationTimeMetrics;

        public FixNegativeLocalDeletionTimeIterator(UnfilteredRowIterator iterator, OutputHandler outputHandler, NegativeLocalDeletionInfoMetrics negativeLocalDeletionInfoMetrics) {
            this.iterator = iterator;
            this.outputHandler = outputHandler;
            this.negativeLocalExpirationTimeMetrics = negativeLocalDeletionInfoMetrics;
        }

        @Override
        public UnfilteredRowIterator wrapped() {
            return this.iterator;
        }

        @Override
        protected Unfiltered computeNext() {
            if (!this.iterator.hasNext()) {
                return (Unfiltered)this.endOfData();
            }
            Unfiltered next = (Unfiltered)this.iterator.next();
            if (!next.isRow()) {
                return next;
            }
            if (this.hasNegativeLocalExpirationTime((Row)next)) {
                this.outputHandler.debug("Found row with negative local expiration time: %s", next.toString(this.metadata(), false));
                ++this.negativeLocalExpirationTimeMetrics.fixedRows;
                return this.fixNegativeLocalExpirationTime((Row)next);
            }
            return next;
        }

        private boolean hasNegativeLocalExpirationTime(Row next) {
            Row row = next;
            if (row.primaryKeyLivenessInfo().isExpiring() && row.primaryKeyLivenessInfo().localExpirationTime() == Cell.INVALID_DELETION_TIME) {
                return true;
            }
            for (ColumnData cd2 : row) {
                if (cd2.column().isSimple()) {
                    Cell cell = (Cell)cd2;
                    if (!cell.isExpiring() || cell.localDeletionTime() != Cell.INVALID_DELETION_TIME) continue;
                    return true;
                }
                ComplexColumnData complexData = (ComplexColumnData)cd2;
                for (Cell<?> cell : complexData) {
                    if (!cell.isExpiring() || cell.localDeletionTime() != Cell.INVALID_DELETION_TIME) continue;
                    return true;
                }
            }
            return false;
        }

        private Unfiltered fixNegativeLocalExpirationTime(Row row) {
            LivenessInfo livenessInfo = row.primaryKeyLivenessInfo();
            if (livenessInfo.isExpiring() && livenessInfo.localExpirationTime() == Cell.INVALID_DELETION_TIME) {
                livenessInfo = livenessInfo.withUpdatedTimestampAndLocalDeletionTime(livenessInfo.timestamp() + 1L, 0x7FFFFFFEL);
            }
            return row.transformAndFilter(livenessInfo, row.deletion(), cd2 -> {
                if (cd2.column().isSimple()) {
                    Cell<?> cell2 = (Cell<?>)cd2;
                    return cell2.isExpiring() && cell2.localDeletionTime() == Cell.INVALID_DELETION_TIME ? cell2.withUpdatedTimestampAndLocalDeletionTime(cell2.timestamp() + 1L, 0x7FFFFFFEL) : cell2;
                }
                ComplexColumnData complexData = (ComplexColumnData)cd2;
                return complexData.transformAndFilter(cell -> cell.isExpiring() && cell.localDeletionTime() == Cell.INVALID_DELETION_TIME ? cell.withUpdatedTimestampAndLocalDeletionTime(cell.timestamp() + 1L, 0x7FFFFFFEL) : cell);
            }).clone(HeapCloner.instance);
        }
    }

    private static class RowMergingSSTableIterator
    implements WrappingUnfilteredRowIterator {
        Unfiltered nextToOffer = null;
        private final OutputHandler output;
        private final UnfilteredRowIterator wrapped;
        private final Version sstableVersion;
        private final boolean reinsertOverflowedTTLRows;

        RowMergingSSTableIterator(UnfilteredRowIterator source, OutputHandler output, Version sstableVersion, boolean reinsertOverflowedTTLRows) {
            this.wrapped = source;
            this.output = output;
            this.sstableVersion = sstableVersion;
            this.reinsertOverflowedTTLRows = reinsertOverflowedTTLRows;
        }

        @Override
        public UnfilteredRowIterator wrapped() {
            return this.wrapped;
        }

        @Override
        public boolean hasNext() {
            return this.nextToOffer != null || this.wrapped.hasNext();
        }

        @Override
        public Unfiltered next() {
            Unfiltered next;
            Unfiltered unfiltered = next = this.nextToOffer != null ? this.nextToOffer : (Unfiltered)this.wrapped.next();
            if (next.isRow()) {
                boolean logged = false;
                while (this.wrapped.hasNext()) {
                    Unfiltered peek = (Unfiltered)this.wrapped.next();
                    if (!peek.isRow() || !next.clustering().equals(peek.clustering())) {
                        this.nextToOffer = peek;
                        return this.computeFinalRow((Row)next);
                    }
                    next = Rows.merge((Row)next, (Row)peek);
                    if (logged) continue;
                    String partitionKey = this.metadata().partitionKeyType.getString(this.partitionKey().getKey());
                    this.output.warn("Duplicate row detected in %s.%s: %s %s", this.metadata().keyspace, this.metadata().name, partitionKey, next.clustering().toString(this.metadata()));
                    logged = true;
                }
            }
            this.nextToOffer = null;
            return this.computeFinalRow((Row)next);
        }

        private Row computeFinalRow(Row next) {
            if (this.hasOverflowedLocalExpirationTimeRow(next) && !this.reinsertOverflowedTTLRows) {
                return null;
            }
            if (this.reinsertOverflowedTTLRows) {
                return this.rebuildTimestamptsForOverflowedRows(next);
            }
            return next;
        }

        private Row rebuildTimestamptsForOverflowedRows(Row row) {
            if (this.sstableVersion.hasUIntDeletionTime()) {
                return row;
            }
            LivenessInfo livenessInfo = row.primaryKeyLivenessInfo();
            if (livenessInfo.isExpiring() && livenessInfo.localExpirationTime() >= 0L) {
                livenessInfo = livenessInfo.withUpdatedTimestampAndLocalDeletionTime(livenessInfo.timestamp(), livenessInfo.localExpirationTime(), false);
            }
            return row.transformAndFilter(livenessInfo, row.deletion(), cd2 -> {
                if (cd2.column().isSimple()) {
                    Cell<?> cell2 = (Cell<?>)cd2;
                    return cell2.isExpiring() && cell2.localDeletionTime() >= 0L ? cell2.withUpdatedTimestampAndLocalDeletionTime(cell2.timestamp(), cell2.localDeletionTime()) : cell2;
                }
                ComplexColumnData complexData = (ComplexColumnData)cd2;
                return complexData.transformAndFilter(cell -> cell.isExpiring() && cell.localDeletionTime() >= 0L ? cell.withUpdatedTimestampAndLocalDeletionTime(cell.timestamp(), cell.localDeletionTime()) : cell);
            }).clone(HeapCloner.instance);
        }

        private boolean hasOverflowedLocalExpirationTimeRow(Row next) {
            if (this.sstableVersion.hasUIntDeletionTime()) {
                return false;
            }
            if (next.primaryKeyLivenessInfo().isExpiring() && next.primaryKeyLivenessInfo().localExpirationTime() >= 0L) {
                return true;
            }
            for (ColumnData cd2 : next) {
                if (cd2.column().isSimple()) {
                    Cell cell = (Cell)cd2;
                    if (!cell.isExpiring() || cell.localDeletionTime() < 0L) continue;
                    return true;
                }
                ComplexColumnData complexData = (ComplexColumnData)cd2;
                for (Cell<?> cell : complexData) {
                    if (!cell.isExpiring() || cell.localDeletionTime() < 0L) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private static final class OrderCheckerIterator
    extends AbstractIterator<Unfiltered>
    implements WrappingUnfilteredRowIterator {
        private final UnfilteredRowIterator iterator;
        private final ClusteringComparator comparator;
        private Unfiltered previous;
        private Partition rowsOutOfOrder;

        public OrderCheckerIterator(UnfilteredRowIterator iterator, ClusteringComparator comparator) {
            this.iterator = iterator;
            this.comparator = comparator;
        }

        @Override
        public UnfilteredRowIterator wrapped() {
            return this.iterator;
        }

        public boolean hasRowsOutOfOrder() {
            return this.rowsOutOfOrder != null;
        }

        public Partition getRowsOutOfOrder() {
            return this.rowsOutOfOrder;
        }

        @Override
        protected Unfiltered computeNext() {
            if (!this.iterator.hasNext()) {
                return (Unfiltered)this.endOfData();
            }
            Unfiltered next = (Unfiltered)this.iterator.next();
            if (this.previous != null && this.comparator.compare(next, this.previous) < 0) {
                this.rowsOutOfOrder = ImmutableBTreePartition.create(UnfilteredRowIterators.concat(next, this.iterator), false);
                return (Unfiltered)this.endOfData();
            }
            this.previous = next;
            return next;
        }
    }

    public static class ScrubInfo
    extends CompactionInfo.Holder {
        private final RandomAccessReader dataFile;
        private final SSTableReader sstable;
        private final TimeUUID scrubCompactionId;
        private final Lock fileReadLock;

        public ScrubInfo(RandomAccessReader dataFile, SSTableReader sstable, Lock fileReadLock) {
            this.dataFile = dataFile;
            this.sstable = sstable;
            this.fileReadLock = fileReadLock;
            this.scrubCompactionId = TimeUUID.Generator.nextTimeUUID();
        }

        @Override
        public CompactionInfo getCompactionInfo() {
            this.fileReadLock.lock();
            try {
                CompactionInfo compactionInfo = new CompactionInfo(this.sstable.metadata(), OperationType.SCRUB, this.dataFile.getFilePointer(), this.dataFile.length(), this.scrubCompactionId, ImmutableSet.of(this.sstable), File.getPath(this.sstable.getFilename(), new String[0]).getParent().toString());
                return compactionInfo;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                this.fileReadLock.unlock();
            }
        }

        @Override
        public boolean isGlobal() {
            return false;
        }
    }
}

