/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.format.bti;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.io.tries.SerializationNode;
import org.apache.cassandra.io.tries.TrieNode;
import org.apache.cassandra.io.tries.TrieSerializer;
import org.apache.cassandra.io.tries.ValueIterator;
import org.apache.cassandra.io.tries.Walker;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.io.util.File;
import org.apache.cassandra.io.util.FileDataInput;
import org.apache.cassandra.io.util.FileHandle;
import org.apache.cassandra.io.util.Rebufferer;
import org.apache.cassandra.io.util.SizedInts;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.concurrent.Ref;
import org.apache.cassandra.utils.concurrent.SharedCloseable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@VisibleForTesting
public class PartitionIndex
implements SharedCloseable {
    private static final Logger logger = LoggerFactory.getLogger(PartitionIndex.class);
    private final FileHandle fh;
    private final long keyCount;
    private final DecoratedKey first;
    private final DecoratedKey last;
    private final long root;
    public static final long NOT_FOUND = Long.MIN_VALUE;
    public static final int FOOTER_LENGTH = 24;
    private static final int FLAG_HAS_HASH_BYTE = 8;
    static final PartitionIndexSerializer TRIE_SERIALIZER = new PartitionIndexSerializer();

    @VisibleForTesting
    public PartitionIndex(FileHandle fh, long trieRoot, long keyCount, DecoratedKey first, DecoratedKey last) {
        this.keyCount = keyCount;
        this.fh = fh.sharedCopy();
        this.first = first;
        this.last = last;
        this.root = trieRoot;
    }

    private PartitionIndex(PartitionIndex src) {
        this(src.fh, src.root, src.keyCount, src.first, src.last);
    }

    public long size() {
        return this.keyCount;
    }

    public DecoratedKey firstKey() {
        return this.first;
    }

    public DecoratedKey lastKey() {
        return this.last;
    }

    @Override
    public PartitionIndex sharedCopy() {
        return new PartitionIndex(this);
    }

    @Override
    public void addTo(Ref.IdentityCollection identities) {
        this.fh.addTo(identities);
    }

    public static PartitionIndex load(FileHandle.Builder fhBuilder, IPartitioner partitioner, boolean preload) throws IOException {
        try (FileHandle fh = fhBuilder.complete();){
            PartitionIndex partitionIndex = PartitionIndex.load(fh, partitioner, preload);
            return partitionIndex;
        }
    }

    public static Pair<DecoratedKey, DecoratedKey> readFirstAndLastKey(File file, IPartitioner partitioner) throws IOException {
        try (PartitionIndex index = PartitionIndex.load(new FileHandle.Builder(file), partitioner, false);){
            Pair<DecoratedKey, DecoratedKey> pair = Pair.create(index.firstKey(), index.lastKey());
            return pair;
        }
    }

    public static PartitionIndex load(FileHandle fh, IPartitioner partitioner, boolean preload) throws IOException {
        try (FileDataInput rdr = fh.createReader(fh.dataLength() - 24L);){
            DecoratedKey last;
            long firstPos = rdr.readLong();
            long keyCount = rdr.readLong();
            long root = rdr.readLong();
            rdr.seek(firstPos);
            DecoratedKey first = partitioner != null ? partitioner.decorateKey(ByteBufferUtil.readWithShortLength(rdr)) : null;
            DecoratedKey decoratedKey = last = partitioner != null ? partitioner.decorateKey(ByteBufferUtil.readWithShortLength(rdr)) : null;
            if (preload) {
                int csum = 0;
                for (long pos = 0L; pos < fh.dataLength(); pos += 4096L) {
                    rdr.seek(pos);
                    csum += rdr.readByte();
                }
                logger.trace("Checksum {}", (Object)csum);
            }
            PartitionIndex partitionIndex = new PartitionIndex(fh, root, keyCount, first, last);
            return partitionIndex;
        }
    }

    @Override
    public void close() {
        this.fh.close();
    }

    @Override
    public Throwable close(Throwable accumulate) {
        return this.fh.close(accumulate);
    }

    public Reader openReader() {
        return new Reader(this);
    }

    protected IndexPosIterator allKeysIterator() {
        return new IndexPosIterator(this);
    }

    protected Rebufferer instantiateRebufferer() {
        return this.fh.instantiateRebufferer(null);
    }

    FileHandle getFileHandle() {
        return this.fh;
    }

    private static long getIndexPos(ByteBuffer contents, int payloadPos, int bytes) {
        if (bytes >= 8) {
            ++payloadPos;
            bytes -= 7;
        }
        if (bytes == 0) {
            return Long.MIN_VALUE;
        }
        return SizedInts.read(contents, payloadPos, bytes);
    }

    @VisibleForTesting
    public void dumpTrie(String fileName) {
        try (PrintStream ps = new PrintStream(fileName);){
            this.dumpTrie(ps);
        }
        catch (Throwable t2) {
            logger.warn("Failed to dump trie to {} due to exception {}", (Object)fileName, (Object)t2);
        }
    }

    private void dumpTrie(PrintStream out) throws IOException {
        try (Reader rdr = this.openReader();){
            rdr.dumpTrie(out, (buf, ppos, pbits, version) -> Long.toString(PartitionIndex.getIndexPos(buf, ppos, pbits)), null);
        }
    }

    public static class IndexPosIterator
    extends ValueIterator<IndexPosIterator> {
        static final long INVALID = -1L;
        long pos = -1L;

        public IndexPosIterator(PartitionIndex index) {
            super(index.instantiateRebufferer(), index.root);
        }

        IndexPosIterator(PartitionIndex index, PartitionPosition start, PartitionPosition end) {
            super(index.instantiateRebufferer(), index.root, start, end, true);
        }

        protected long nextIndexPos() {
            if (this.pos == -1L) {
                this.pos = this.nextPayloadedNode();
                if (this.pos == -1L) {
                    return Long.MIN_VALUE;
                }
            }
            this.go(this.pos);
            this.pos = -1L;
            return PartitionIndex.getIndexPos(this.buf, this.payloadPosition(), this.payloadFlags());
        }
    }

    public static class Reader
    extends Walker<Reader> {
        protected Reader(PartitionIndex index) {
            super(index.instantiateRebufferer(), index.root);
        }

        public long exactCandidate(DecoratedKey key) {
            int b = this.follow(key);
            if (b != -1 && this.hasChildren()) {
                return Long.MIN_VALUE;
            }
            if (!this.checkHashBits(key.filterHashLowerBits())) {
                return Long.MIN_VALUE;
            }
            return this.getCurrentIndexPos();
        }

        final boolean checkHashBits(short hashBits) {
            int bytes = this.payloadFlags();
            if (bytes < 8) {
                return bytes > 0;
            }
            return this.buf.get(this.payloadPosition()) == (byte)hashBits;
        }

        public <ResultType> ResultType ceiling(PartitionPosition key, Acceptor<PartitionPosition, ResultType> acceptor) throws IOException {
            ResultType res;
            long indexPos;
            int b = this.followWithGreater(key);
            if (!(this.hasChildren() && b != -1 || (indexPos = this.getCurrentIndexPos()) == Long.MIN_VALUE || (res = acceptor.accept(indexPos, false, key)) == null)) {
                return res;
            }
            if (this.greaterBranch == (long)NONE) {
                return null;
            }
            this.goMin(this.greaterBranch);
            indexPos = this.getCurrentIndexPos();
            if (indexPos == Long.MIN_VALUE) {
                return null;
            }
            return acceptor.accept(indexPos, true, key);
        }

        public <ResultType> ResultType floor(PartitionPosition key, Acceptor<PartitionPosition, ResultType> acceptor) throws IOException {
            ResultType res;
            Long indexPos = this.prefixAndNeighbours(key, Reader::getSpecificIndexPos);
            if (indexPos != null && indexPos != Long.MIN_VALUE && (res = acceptor.accept(indexPos, false, key)) != null) {
                return res;
            }
            if (this.lesserBranch == (long)NONE) {
                return null;
            }
            this.goMax(this.lesserBranch);
            indexPos = this.getCurrentIndexPos();
            if (indexPos == Long.MIN_VALUE) {
                return null;
            }
            return acceptor.accept(indexPos, true, key);
        }

        public Long getSpecificIndexPos(int pos, int bits) {
            return PartitionIndex.getIndexPos(this.buf, pos, bits);
        }

        public long getCurrentIndexPos() {
            return PartitionIndex.getIndexPos(this.buf, this.payloadPosition(), this.payloadFlags());
        }

        public long getLastIndexPosition() {
            this.goMax(this.root);
            return this.getCurrentIndexPos();
        }

        protected int payloadSize() {
            int bytes = this.payloadFlags();
            return bytes > 7 ? bytes - 6 : bytes;
        }
    }

    public static interface Acceptor<ArgType, ResultType> {
        public ResultType accept(long var1, boolean var3, ArgType var4) throws IOException;
    }

    private static class PartitionIndexSerializer
    implements TrieSerializer<Payload, DataOutputPlus> {
        private PartitionIndexSerializer() {
        }

        @Override
        public int sizeofNode(SerializationNode<Payload> node, long nodePosition) {
            return TrieNode.typeFor(node, nodePosition).sizeofNode(node) + (node.payload() != null ? 1 + SizedInts.nonZeroSize(node.payload().position) : 0);
        }

        @Override
        public void write(DataOutputPlus dest, SerializationNode<Payload> node, long nodePosition) throws IOException {
            this.write(dest, TrieNode.typeFor(node, nodePosition), node, nodePosition);
        }

        private void write(DataOutputPlus dest, TrieNode type, SerializationNode<Payload> node, long nodePosition) throws IOException {
            Payload payload = node.payload();
            if (payload != null) {
                int size = SizedInts.nonZeroSize(payload.position);
                int payloadBits = 8 + (size - 1);
                type.serialize(dest, node, payloadBits, nodePosition);
                dest.writeByte(payload.hashBits);
                SizedInts.write(dest, payload.position, size);
            } else {
                type.serialize(dest, node, 0, nodePosition);
            }
        }
    }

    static class Payload {
        final long position;
        final short hashBits;

        public Payload(long position, short hashBits) {
            this.position = position;
            assert (this.position != Long.MIN_VALUE) : "Partition position -9223372036854775808 is not valid.";
            this.hashBits = hashBits;
        }
    }
}

