/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.utils.FastByteOperations;
import org.apache.cassandra.utils.vint.VIntCoding;

public abstract class RebufferingInputStream
extends DataInputPlus.DataInputStreamPlus
implements DataInputPlus,
Closeable {
    protected ByteBuffer buffer;

    protected RebufferingInputStream(ByteBuffer buffer) {
        Preconditions.checkArgument(buffer == null || buffer.order() == ByteOrder.BIG_ENDIAN, "Buffer must have BIG ENDIAN byte ordering");
        this.buffer = buffer;
    }

    protected abstract void reBuffer() throws IOException;

    @Override
    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        int read = this.read(b, off, len);
        if (read < len) {
            throw new EOFException("EOF after " + read + " bytes out of " + len);
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int copied;
        int toCopy;
        if (off < 0 || off > b.length || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        for (copied = 0; copied < len; copied += toCopy) {
            int position = this.buffer.position();
            int remaining = this.buffer.limit() - position;
            if (remaining == 0) {
                this.reBuffer();
                position = this.buffer.position();
                remaining = this.buffer.limit() - position;
                if (remaining == 0) {
                    return copied == 0 ? -1 : copied;
                }
            }
            toCopy = Math.min(len - copied, remaining);
            FastByteOperations.copy(this.buffer, position, b, off + copied, toCopy);
            this.buffer.position(position + toCopy);
        }
        return copied;
    }

    public void readFully(ByteBuffer dst) throws IOException {
        int toCopy;
        int offset = dst.position();
        int len = dst.limit() - offset;
        for (int copied = 0; copied < len; copied += toCopy) {
            int position = this.buffer.position();
            int remaining = this.buffer.limit() - position;
            if (remaining == 0) {
                this.reBuffer();
                position = this.buffer.position();
                remaining = this.buffer.limit() - position;
                if (remaining == 0) {
                    throw new EOFException("EOF after " + copied + " bytes out of " + len);
                }
            }
            toCopy = Math.min(len - copied, remaining);
            FastByteOperations.copy(this.buffer, position, dst, offset + copied, toCopy);
            this.buffer.position(position + toCopy);
        }
    }

    protected long readPrimitiveSlowly(int bytes) throws IOException {
        long result = 0L;
        for (int i = 0; i < bytes; ++i) {
            result = result << 8 | (long)this.readByte() & 0xFFL;
        }
        return result;
    }

    @Override
    public int skipBytes(int n) throws IOException {
        int remaining;
        if (n <= 0) {
            return 0;
        }
        int requested = n;
        int position = this.buffer.position();
        int limit = this.buffer.limit();
        while ((remaining = limit - position) < n) {
            n -= remaining;
            this.buffer.position(limit);
            this.reBuffer();
            position = this.buffer.position();
            if (position != (limit = this.buffer.limit())) continue;
            return requested - n;
        }
        this.buffer.position(position + n);
        return requested;
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.readByte() != 0;
    }

    @Override
    public byte readByte() throws IOException {
        if (!this.buffer.hasRemaining()) {
            this.reBuffer();
            if (!this.buffer.hasRemaining()) {
                throw new EOFException();
            }
        }
        return this.buffer.get();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.readByte() & 0xFF;
    }

    @Override
    public short readShort() throws IOException {
        if (this.buffer.remaining() >= 2) {
            return this.buffer.getShort();
        }
        return (short)this.readPrimitiveSlowly(2);
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.readShort() & 0xFFFF;
    }

    @Override
    public char readChar() throws IOException {
        if (this.buffer.remaining() >= 2) {
            return this.buffer.getChar();
        }
        return (char)this.readPrimitiveSlowly(2);
    }

    @Override
    public int readInt() throws IOException {
        if (this.buffer.remaining() >= 4) {
            return this.buffer.getInt();
        }
        return (int)this.readPrimitiveSlowly(4);
    }

    @Override
    public long readLong() throws IOException {
        if (this.buffer.remaining() >= 8) {
            return this.buffer.getLong();
        }
        return this.readPrimitiveSlowly(8);
    }

    @Override
    public long readVInt() throws IOException {
        return VIntCoding.decodeZigZag64(this.readUnsignedVInt());
    }

    @Override
    public int readVInt32() throws IOException {
        return VIntCoding.checkedCast(VIntCoding.decodeZigZag64(this.readUnsignedVInt()));
    }

    @Override
    public long readUnsignedVInt() throws IOException {
        if (this.buffer.remaining() < 9) {
            return VIntCoding.readUnsignedVInt(this);
        }
        byte firstByte = this.buffer.get();
        if (firstByte >= 0) {
            return firstByte;
        }
        int extraBytes = VIntCoding.numberOfExtraBytesToRead(firstByte);
        int position = this.buffer.position();
        int extraBits = extraBytes * 8;
        long retval = this.buffer.getLong(position);
        if (this.buffer.order() == ByteOrder.LITTLE_ENDIAN) {
            retval = Long.reverseBytes(retval);
        }
        this.buffer.position(position + extraBytes);
        retval >>>= 64 - extraBits;
        firstByte = (byte)(firstByte & VIntCoding.firstByteValueMask(extraBytes));
        return retval |= (long)firstByte << extraBits;
    }

    @Override
    public int readUnsignedVInt32() throws IOException {
        return VIntCoding.checkedCast(this.readUnsignedVInt());
    }

    @Override
    public float readFloat() throws IOException {
        if (this.buffer.remaining() >= 4) {
            return this.buffer.getFloat();
        }
        return Float.intBitsToFloat((int)this.readPrimitiveSlowly(4));
    }

    @Override
    public double readDouble() throws IOException {
        if (this.buffer.remaining() >= 8) {
            return this.buffer.getDouble();
        }
        return Double.longBitsToDouble(this.readPrimitiveSlowly(8));
    }

    @Override
    public String readLine() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    @Override
    public int read() throws IOException {
        try {
            return this.readUnsignedByte();
        }
        catch (EOFException ex) {
            return -1;
        }
    }
}

