/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.schema;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Iterables;
import java.nio.ByteBuffer;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.functions.FunctionName;
import org.apache.cassandra.cql3.functions.UDAggregate;
import org.apache.cassandra.cql3.functions.UDFunction;
import org.apache.cassandra.cql3.functions.UserFunction;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.UserType;
import org.apache.cassandra.schema.Diff;
import org.apache.cassandra.schema.Difference;

public final class UserFunctions
implements Iterable<UserFunction> {
    private final ImmutableMultimap<FunctionName, UserFunction> functions;

    private UserFunctions(Builder builder) {
        this.functions = builder.functions.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static UserFunctions none() {
        return UserFunctions.builder().build();
    }

    @Override
    public Iterator<UserFunction> iterator() {
        return ((ImmutableCollection)this.functions.values()).iterator();
    }

    public Stream<UserFunction> stream() {
        return this.functions.values().stream();
    }

    public int size() {
        return this.functions.size();
    }

    public Stream<UDFunction> udfs() {
        return this.stream().filter(Filter.UDF).map(f -> (UDFunction)f);
    }

    public Stream<UDAggregate> udas() {
        return this.stream().filter(Filter.UDA).map(f -> (UDAggregate)f);
    }

    public Iterable<UserFunction> referencingUserType(ByteBuffer name) {
        return Iterables.filter(this, f -> f.referencesUserType(name));
    }

    public UserFunctions withUpdatedUserType(UserType udt) {
        if (!Iterables.any(this, f -> f.referencesUserType(udt.name))) {
            return this;
        }
        Collection udfs = this.udfs().map(f -> f.withUpdatedUserType(udt)).collect(Collectors.toList());
        Collection udas = this.udas().map(f -> f.withUpdatedUserType(udfs, udt)).collect(Collectors.toList());
        return UserFunctions.builder().add(udfs).add(udas).build();
    }

    public Stream<UDAggregate> aggregatesUsingFunction(Function function) {
        return this.udas().filter((? super T uda) -> uda.hasReferenceTo(function));
    }

    public Collection<UserFunction> get(FunctionName name) {
        return this.functions.get((Object)name);
    }

    public Collection<UDFunction> getUdfs(FunctionName name) {
        return this.functions.get((Object)name).stream().filter(Filter.UDF).map(f -> (UDFunction)f).collect(Collectors.toList());
    }

    public Collection<UDAggregate> getUdas(FunctionName name) {
        return this.functions.get((Object)name).stream().filter(Filter.UDA).map(f -> (UDAggregate)f).collect(Collectors.toList());
    }

    public Optional<UserFunction> find(FunctionName name, List<AbstractType<?>> argTypes) {
        return this.find(name, argTypes, Filter.ALL);
    }

    public Optional<UserFunction> find(FunctionName name, List<AbstractType<?>> argTypes, Filter filter) {
        return this.get(name).stream().filter(filter.and(fun -> fun.typesMatch(argTypes))).findAny();
    }

    public boolean isEmpty() {
        return this.functions.isEmpty();
    }

    public static int typeHashCode(AbstractType<?> t2) {
        return t2.asCQL3Type().toString().hashCode();
    }

    public static int typeHashCode(List<AbstractType<?>> types) {
        int h2 = 0;
        for (AbstractType<?> type : types) {
            h2 = h2 * 31 + UserFunctions.typeHashCode(type);
        }
        return h2;
    }

    public UserFunctions filter(Predicate<UserFunction> predicate) {
        Builder builder = UserFunctions.builder();
        this.stream().filter(predicate).forEach(builder::add);
        return builder.build();
    }

    public UserFunctions with(UserFunction fun) {
        if (this.find(fun.name(), fun.argTypes()).isPresent()) {
            throw new IllegalStateException(String.format("Function %s already exists", fun.name()));
        }
        return UserFunctions.builder().add(this).add(fun).build();
    }

    public UserFunctions without(FunctionName name, List<AbstractType<?>> argTypes) {
        Function fun = this.find(name, argTypes).orElseThrow(() -> new IllegalStateException(String.format("Function %s doesn't exists", name)));
        return this.without(fun);
    }

    public UserFunctions without(Function function) {
        return UserFunctions.builder().add(Iterables.filter(this, f -> f != function)).build();
    }

    public UserFunctions withAddedOrUpdated(UserFunction function) {
        return UserFunctions.builder().add(Iterables.filter(this, f -> !f.name().equals(function.name()) || !f.typesMatch(function.argTypes()))).add(function).build();
    }

    public boolean equals(Object o) {
        return this == o || o instanceof UserFunctions && this.functions.equals(((UserFunctions)o).functions);
    }

    public int hashCode() {
        return this.functions.hashCode();
    }

    public String toString() {
        return ((AbstractCollection)this.functions.values()).toString();
    }

    static FunctionsDiff<UDFunction> udfsDiff(UserFunctions before, UserFunctions after) {
        return FunctionsDiff.diff(before, after, Filter.UDF);
    }

    static FunctionsDiff<UDAggregate> udasDiff(UserFunctions before, UserFunctions after) {
        return FunctionsDiff.diff(before, after, Filter.UDA);
    }

    public static final class FunctionsDiff<T extends Function>
    extends Diff<UserFunctions, T> {
        static final FunctionsDiff NONE = new FunctionsDiff(UserFunctions.none(), UserFunctions.none(), ImmutableList.of());

        private FunctionsDiff(UserFunctions created, UserFunctions dropped, ImmutableCollection<Diff.Altered<T>> altered) {
            super(created, dropped, altered);
        }

        private static FunctionsDiff diff(UserFunctions before, UserFunctions after, Filter filter) {
            if (before == after) {
                return NONE;
            }
            UserFunctions created = after.filter(filter.and(k -> !before.find(k.name(), k.argTypes(), filter).isPresent()));
            UserFunctions dropped = before.filter(filter.and(k -> !after.find(k.name(), k.argTypes(), filter).isPresent()));
            ImmutableList.Builder altered = ImmutableList.builder();
            before.stream().filter(filter).forEach(functionBefore -> after.find(functionBefore.name(), functionBefore.argTypes(), filter).ifPresent(functionAfter -> functionBefore.compare((Function)functionAfter).ifPresent(kind -> altered.add(new Diff.Altered<UserFunction>((UserFunction)functionBefore, (UserFunction)functionAfter, (Difference)((Object)((Object)((Object)kind))))))));
            return new FunctionsDiff(created, dropped, altered.build());
        }
    }

    public static final class Builder {
        final ImmutableMultimap.Builder<FunctionName, UserFunction> functions = new ImmutableMultimap.Builder();

        private Builder() {
            this.functions.orderValuesBy(Comparator.comparingInt(Object::hashCode));
        }

        public UserFunctions build() {
            return new UserFunctions(this);
        }

        public Builder add(UserFunction fun) {
            this.functions.put(fun.name(), fun);
            return this;
        }

        public Builder add(UserFunction ... funs) {
            for (UserFunction fun : funs) {
                this.add(fun);
            }
            return this;
        }

        public Builder add(Iterable<? extends UserFunction> funs) {
            funs.forEach(this::add);
            return this;
        }
    }

    public static enum Filter implements Predicate<UserFunction>
    {
        ALL,
        UDF,
        UDA;


        @Override
        public boolean test(UserFunction function) {
            switch (this) {
                case UDF: {
                    return function instanceof UDFunction;
                }
                case UDA: {
                    return function instanceof UDAggregate;
                }
            }
            return true;
        }
    }
}

