/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.serializers;

import java.nio.ByteBuffer;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.utils.ByteBufferUtil;

public class BooleanSerializer
extends TypeSerializer<Boolean> {
    public static final ByteBuffer TRUE = ByteBuffer.wrap(new byte[]{1});
    public static final ByteBuffer FALSE = ByteBuffer.wrap(new byte[]{0});
    public static final BooleanSerializer instance = new BooleanSerializer();

    @Override
    public <V> Boolean deserialize(V value, ValueAccessor<V> accessor) {
        if (value == null || accessor.isEmpty(value)) {
            return null;
        }
        return accessor.getByte(value, 0) != 0;
    }

    @Override
    public ByteBuffer serialize(Boolean value) {
        return value == null ? ByteBufferUtil.EMPTY_BYTE_BUFFER : (value != false ? TRUE : FALSE);
    }

    @Override
    public <V> void validate(V value, ValueAccessor<V> accessor) throws MarshalException {
        if (accessor.size(value) > 1) {
            throw new MarshalException(String.format("Expected 1 or 0 byte value (%d)", accessor.size(value)));
        }
    }

    @Override
    public String toString(Boolean value) {
        return value == null ? "" : value.toString();
    }

    @Override
    public Class<Boolean> getType() {
        return Boolean.class;
    }
}

