/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.win32;

import java.util.List;
import java.util.Vector;
import org.hyperic.sigar.win32.Win32;
import org.hyperic.sigar.win32.Win32Exception;

public class RegistryKey
extends Win32 {
    private static final int HKEY_CLASSES_ROOT = Integer.MIN_VALUE;
    private static final int HKEY_CURRENT_USER = -2147483647;
    private static final int HKEY_LOCAL_MACHINE = -2147483646;
    private static final int HKEY_USERS = -2147483645;
    private static final int HKEY_PERFORMANCE_DATA = -2147483644;
    private static final int HKEY_CURRENT_CONFIG = -2147483643;
    private static final int HKEY_DYN_DATA = -2147483642;
    public static final RegistryKey ClassesRoot = new RegistryKey(Integer.MIN_VALUE);
    public static final RegistryKey CurrentUser = new RegistryKey(-2147483647L);
    public static final RegistryKey LocalMachine = new RegistryKey(-2147483646L);
    private long m_hkey;
    private String subkey;

    private RegistryKey() {
    }

    private RegistryKey(long hkey) {
        this.m_hkey = hkey;
    }

    public synchronized void close() {
        if (this.m_hkey != 0L) {
            RegistryKey.RegCloseKey(this.m_hkey);
            this.m_hkey = 0L;
        }
    }

    public RegistryKey createSubKey(String subkey) {
        return new RegistryKey(RegistryKey.RegCreateKey(this.m_hkey, subkey));
    }

    public String getSubKeyName() {
        return this.subkey;
    }

    public RegistryKey createSubKey(String subkey, String value) throws Win32Exception {
        RegistryKey keyResult = null;
        long hkey = RegistryKey.RegCreateKey(this.m_hkey, subkey);
        if (hkey != 0L) {
            keyResult = new RegistryKey(hkey);
            if (keyResult != null) {
                keyResult.setStringValue(null, value);
            }
        } else {
            throw new Win32Exception("Error creating subkey");
        }
        return keyResult;
    }

    public RegistryKey createSubKey(String subkey, int value) throws Win32Exception {
        RegistryKey keyResult = null;
        long hkey = RegistryKey.RegCreateKey(this.m_hkey, subkey);
        if (hkey != 0L) {
            keyResult = new RegistryKey(hkey);
            if (keyResult != null) {
                keyResult.setIntValue(null, value);
            }
        } else {
            throw new Win32Exception("Error creating subkey");
        }
        return keyResult;
    }

    public void deleteSubKey(String subkey) {
        RegistryKey.RegDeleteKey(this.m_hkey, subkey);
    }

    public void deleteSubKeyTree(String subkey) {
    }

    public void deleteValue(String name) {
        RegistryKey.RegDeleteValue(this.m_hkey, name);
    }

    public void flush() {
        RegistryKey.RegFlushKey(this.m_hkey);
    }

    public int getIntValue(String name) throws Win32Exception {
        int iResult = 0;
        try {
            iResult = RegistryKey.RegQueryIntValue(this.m_hkey, name);
        }
        catch (Throwable t2) {
            throw new Win32Exception("Error getting int value");
        }
        return iResult;
    }

    public int getIntValue(String name, int defaultValue) {
        int iResult;
        try {
            iResult = this.getIntValue(name);
        }
        catch (Win32Exception e) {
            iResult = defaultValue;
        }
        return iResult;
    }

    public String getStringValue(String name) throws Win32Exception {
        String strResult = RegistryKey.RegQueryStringValue(this.m_hkey, name);
        if (strResult == null) {
            throw new Win32Exception("Error getting string value");
        }
        return strResult;
    }

    public void getMultiStringValue(String name, List values) throws Win32Exception {
        RegistryKey.RegQueryMultiStringValue(this.m_hkey, name, values);
    }

    public String getStringValue(String name, String defaultValue) {
        String strResult;
        try {
            strResult = this.getStringValue(name);
        }
        catch (Win32Exception e) {
            strResult = defaultValue;
        }
        return strResult;
    }

    public String[] getSubKeyNames() {
        String strName;
        Vector<String> coll = new Vector<String>();
        int i = 0;
        while ((strName = RegistryKey.RegEnumKey(this.m_hkey, i)) != null) {
            coll.add(strName);
            ++i;
        }
        return coll.toArray(new String[coll.size()]);
    }

    public String[] getValueNames() {
        String strName;
        Vector<String> coll = new Vector<String>();
        int i = 0;
        while ((strName = RegistryKey.RegEnumValueName(this.m_hkey, i)) != null) {
            coll.add(strName);
            ++i;
        }
        return coll.toArray(new String[coll.size()]);
    }

    public RegistryKey openSubKey(String subkey) throws Win32Exception {
        long hkey = RegistryKey.RegOpenKey(this.m_hkey, subkey);
        if (hkey == 0L) {
            throw new Win32Exception("Error opening subkey");
        }
        RegistryKey key = new RegistryKey(hkey);
        key.subkey = subkey;
        return key;
    }

    public void setIntValue(String name, int value) throws Win32Exception {
        int iResult = RegistryKey.RegSetIntValue(this.m_hkey, name, value);
        if (iResult != 0) {
            throw new Win32Exception("Error setting int value");
        }
    }

    public void setStringValue(String name, String value) throws Win32Exception {
        int iResult = RegistryKey.RegSetStringValue(this.m_hkey, name, value);
        if (iResult != 0) {
            throw new Win32Exception("Error setting string value");
        }
    }

    protected void finalize() {
        this.close();
    }

    private static native int RegCloseKey(long var0);

    private static native long RegCreateKey(long var0, String var2);

    private static native int RegDeleteKey(long var0, String var2);

    private static native int RegDeleteValue(long var0, String var2);

    private static native String RegEnumKey(long var0, int var2);

    private static native String RegEnumValueName(long var0, int var2);

    private static native int RegFlushKey(long var0);

    private static native int RegLoadKey(long var0, String var2, String var3);

    private static native long RegOpenKey(long var0, String var2);

    private static native byte[] RegQueryBufferValue(long var0, String var2);

    private static native int RegQueryIntValue(long var0, String var2);

    private static native String RegQueryStringValue(long var0, String var2);

    private static native void RegQueryMultiStringValue(long var0, String var2, List var3);

    private static native int RegSetIntValue(long var0, String var2, int var3);

    private static native int RegSetStringValue(long var0, String var2, String var3);
}

