/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.example;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.spark.transports.storage.StorageCredentialPair;
import org.apache.cassandra.spark.transports.storage.StorageCredentials;
import org.apache.cassandra.spark.transports.storage.extensions.CoordinationSignalListener;
import org.apache.cassandra.spark.transports.storage.extensions.CredentialChangeListener;
import org.apache.cassandra.spark.transports.storage.extensions.ObjectFailureListener;
import org.apache.cassandra.spark.transports.storage.extensions.StorageTransportConfiguration;
import org.apache.cassandra.spark.transports.storage.extensions.StorageTransportExtension;
import org.apache.cassandra.util.ThreadUtil;
import org.apache.spark.SparkConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExampleStorageTransportExtension
implements StorageTransportExtension {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExampleStorageTransportExtension.class);
    private SparkConf conf;
    private ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(ThreadUtil.threadFactory((String)"ExampleBlobStorageOperations"));
    private String jobId;
    private long tokenCount = 0L;
    private CredentialChangeListener credentialChangeListener;
    private ObjectFailureListener objectFailureListener;
    private CoordinationSignalListener coordinationSignalListener;
    private boolean shouldFail;

    public void initialize(String jobId, SparkConf conf, boolean isOnDriver) {
        this.jobId = jobId;
        this.conf = conf;
        this.shouldFail = conf.getBoolean("blob_operations_should_fail", false);
    }

    public StorageTransportConfiguration getStorageConfiguration() {
        ImmutableMap additionalTags = ImmutableMap.of((Object)"additional-key", (Object)"additional-value");
        return new StorageTransportConfiguration("writebucket-name", "us-west-2", "readbucket-name", "eu-west-1", "some-prefix-for-each-job", this.generateTokens(this.tokenCount++), (Map)additionalTags);
    }

    public void onTransportStart(long elapsedMillis) {
    }

    public void setCredentialChangeListener(CredentialChangeListener credentialChangeListener) {
        LOGGER.info("Token listener registered for job {}", (Object)this.jobId);
        this.credentialChangeListener = credentialChangeListener;
        this.startFakeTokenRefresh();
    }

    public void setObjectFailureListener(ObjectFailureListener objectFailureListener) {
        this.objectFailureListener = objectFailureListener;
        if (this.shouldFail) {
            this.scheduledExecutorService.schedule(this::fail, 1L, TimeUnit.SECONDS);
        }
    }

    private void fail() {
        this.objectFailureListener.onObjectFailed(this.jobId, "failed_bucket", "failed_key", "Fake failure");
    }

    public void onObjectPersisted(String bucket, String key, long sizeInBytes) {
        LOGGER.info("Object {}/{} for job {} persisted with size {} bytes", new Object[]{bucket, key, this.jobId, sizeInBytes});
    }

    public void onAllObjectsPersisted(long objectsCount, long rowCount, long elapsedMillis) {
        LOGGER.info("All {} objects, totaling {} rows, are persisted with elapsed time {}ms", new Object[]{objectsCount, rowCount, elapsedMillis});
    }

    public void onObjectApplied(String bucket, String key, long sizeInBytes, long elapsedMillis) {
    }

    public void onJobSucceeded(long elapsedMillis) {
        LOGGER.info("Job {} succeeded with elapsed time {}ms", (Object)this.jobId, (Object)elapsedMillis);
    }

    public void onJobFailed(long elapsedMillis, Throwable throwable) {
        LOGGER.error("Job {} failed after {}ms", new Object[]{this.jobId, elapsedMillis, throwable});
    }

    private void startFakeTokenRefresh() {
        this.scheduledExecutorService.scheduleAtFixedRate(this::refreshTokens, 1L, 1L, TimeUnit.SECONDS);
    }

    private void refreshTokens() {
        this.credentialChangeListener.onCredentialsChanged(this.jobId, this.generateTokens(this.tokenCount++));
    }

    private StorageCredentialPair generateTokens(long tokenCount) {
        return new StorageCredentialPair("writeRegion", new StorageCredentials("writeAccessKeyId-" + tokenCount, "writeSecretKey-" + tokenCount, "writeSessionToken-" + tokenCount), "readRegion", new StorageCredentials("readAccessKeyId-" + tokenCount, "readSecretKey-" + tokenCount, "readSessionToken-" + tokenCount));
    }

    public void onStageSucceeded(String clusterId, long elapsedMillis) {
        LOGGER.info("Job {} has all objects staged at cluster {} after {}ms", new Object[]{this.jobId, clusterId, elapsedMillis});
    }

    public void onStageFailed(String clusterId, Throwable cause) {
        LOGGER.error("Cluster {} failed to stage objects", (Object)clusterId, (Object)cause);
    }

    public void onImportSucceeded(String clusterId, long elapsedMillis) {
        LOGGER.info("Job {} has all objects applied at cluster {} after {}ms", new Object[]{this.jobId, clusterId, elapsedMillis});
    }

    public void onImportFailed(String clusterId, Throwable cause) {
        LOGGER.error("Cluster {} failed to apply objects", (Object)clusterId, (Object)cause);
    }

    public void setCoordinationSignalListener(CoordinationSignalListener listener) {
        this.coordinationSignalListener = listener;
        LOGGER.info("CoordinationSignalListener initialized. listener={}", (Object)listener);
    }
}

