/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import com.codahale.metrics.Gauge;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.metrics.CassandraMetricsRegistry;
import org.apache.cassandra.metrics.DefaultNameFactory;
import org.apache.cassandra.net.InboundMessageHandlers;

public class InternodeInboundMetrics {
    private final CassandraMetricsRegistry.MetricName corruptFramesRecovered;
    private final CassandraMetricsRegistry.MetricName corruptFramesUnrecovered;
    private final CassandraMetricsRegistry.MetricName errorBytes;
    private final CassandraMetricsRegistry.MetricName errorCount;
    private final CassandraMetricsRegistry.MetricName expiredBytes;
    private final CassandraMetricsRegistry.MetricName expiredCount;
    private final CassandraMetricsRegistry.MetricName pendingBytes;
    private final CassandraMetricsRegistry.MetricName pendingCount;
    private final CassandraMetricsRegistry.MetricName processedBytes;
    private final CassandraMetricsRegistry.MetricName processedCount;
    private final CassandraMetricsRegistry.MetricName receivedBytes;
    private final CassandraMetricsRegistry.MetricName receivedCount;
    private final CassandraMetricsRegistry.MetricName throttledCount;
    private final CassandraMetricsRegistry.MetricName throttledNanos;

    public InternodeInboundMetrics(InetAddressAndPort peer, InboundMessageHandlers handlers) {
        DefaultNameFactory factory = new DefaultNameFactory("InboundConnection", peer.getHostAddressAndPortForJMX());
        this.corruptFramesRecovered = factory.createMetricName("CorruptFramesRecovered");
        InternodeInboundMetrics.register(this.corruptFramesRecovered, handlers::corruptFramesRecovered);
        this.corruptFramesUnrecovered = factory.createMetricName("CorruptFramesUnrecovered");
        InternodeInboundMetrics.register(this.corruptFramesUnrecovered, handlers::corruptFramesUnrecovered);
        this.errorBytes = factory.createMetricName("ErrorBytes");
        InternodeInboundMetrics.register(this.errorBytes, handlers::errorBytes);
        this.errorCount = factory.createMetricName("ErrorCount");
        InternodeInboundMetrics.register(this.errorCount, handlers::errorCount);
        this.expiredBytes = factory.createMetricName("ExpiredBytes");
        InternodeInboundMetrics.register(this.expiredBytes, handlers::expiredBytes);
        this.expiredCount = factory.createMetricName("ExpiredCount");
        InternodeInboundMetrics.register(this.expiredCount, handlers::expiredCount);
        this.pendingBytes = factory.createMetricName("ScheduledBytes");
        InternodeInboundMetrics.register(this.pendingBytes, handlers::scheduledBytes);
        this.pendingCount = factory.createMetricName("ScheduledCount");
        InternodeInboundMetrics.register(this.pendingCount, handlers::scheduledCount);
        this.processedBytes = factory.createMetricName("ProcessedBytes");
        InternodeInboundMetrics.register(this.processedBytes, handlers::processedBytes);
        this.processedCount = factory.createMetricName("ProcessedCount");
        InternodeInboundMetrics.register(this.processedCount, handlers::processedCount);
        this.receivedBytes = factory.createMetricName("ReceivedBytes");
        InternodeInboundMetrics.register(this.receivedBytes, handlers::receivedBytes);
        this.receivedCount = factory.createMetricName("ReceivedCount");
        InternodeInboundMetrics.register(this.receivedCount, handlers::receivedCount);
        this.throttledCount = factory.createMetricName("ThrottledCount");
        InternodeInboundMetrics.register(this.throttledCount, handlers::throttledCount);
        this.throttledNanos = factory.createMetricName("ThrottledNanos");
        InternodeInboundMetrics.register(this.throttledNanos, handlers::throttledNanos);
    }

    public void release() {
        InternodeInboundMetrics.remove(this.corruptFramesRecovered);
        InternodeInboundMetrics.remove(this.corruptFramesUnrecovered);
        InternodeInboundMetrics.remove(this.errorBytes);
        InternodeInboundMetrics.remove(this.errorCount);
        InternodeInboundMetrics.remove(this.expiredBytes);
        InternodeInboundMetrics.remove(this.expiredCount);
        InternodeInboundMetrics.remove(this.pendingBytes);
        InternodeInboundMetrics.remove(this.pendingCount);
        InternodeInboundMetrics.remove(this.processedBytes);
        InternodeInboundMetrics.remove(this.processedCount);
        InternodeInboundMetrics.remove(this.receivedBytes);
        InternodeInboundMetrics.remove(this.receivedCount);
        InternodeInboundMetrics.remove(this.throttledCount);
        InternodeInboundMetrics.remove(this.throttledNanos);
    }

    private static void register(CassandraMetricsRegistry.MetricName name, Gauge gauge) {
        CassandraMetricsRegistry.Metrics.register(name, gauge);
    }

    private static void remove(CassandraMetricsRegistry.MetricName name) {
        CassandraMetricsRegistry.Metrics.remove(name);
    }
}

