/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.bridge;

import java.net.URL;
import java.net.URLClassLoader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PostDelegationClassLoader
extends URLClassLoader {
    public PostDelegationClassLoader(@NotNull URL[] urls, @Nullable ClassLoader parent) {
        super(urls, parent);
    }

    @Override
    @Nullable
    protected synchronized Class<?> loadClass(@Nullable String name, boolean resolve) throws ClassNotFoundException {
        Class<?> type = this.findLoadedClass(name);
        if (type == null) {
            try {
                type = this.findClass(name);
            }
            catch (ClassNotFoundException | LinkageError | SecurityException throwable) {
                // empty catch block
            }
            if (type == null) {
                type = super.loadClass(name, false);
            }
        }
        if (resolve) {
            this.resolveClass(type);
        }
        return type;
    }
}

