/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.data.partitioner;

import java.math.BigInteger;
import org.apache.cassandra.spark.data.partitioner.ConsistencyLevel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NotEnoughReplicasException
extends RuntimeException {
    public NotEnoughReplicasException(String message) {
        super(message);
    }

    public NotEnoughReplicasException(@NotNull ConsistencyLevel consistencyLevel, @Nullable BigInteger lower, @Nullable BigInteger upper, int minRequired, int numInstances, @Nullable String dataCenter) {
        super(String.format("Insufficient replicas found to achieve consistency level %s for token range %s - %s, required %d but only %d found, dataCenter=%s", consistencyLevel.name(), lower, upper, minRequired, numInstances, dataCenter));
    }

    static boolean isNotEnoughReplicasException(@Nullable Throwable throwable) {
        for (Throwable cause = throwable; cause != null; cause = cause.getCause()) {
            if (!(cause instanceof NotEnoughReplicasException)) continue;
            return true;
        }
        return false;
    }
}

